/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.ModifyStringType;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.EnvVars;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ModifyEnvironmentVariableAction
extends SystemInstallOrUninstallAction
implements AutoUninstallAction {
    private ModifyStringType type = ModifyStringType.SET;
    private String variableName;
    private String value;
    private boolean userSpecific = true;
    private boolean revertOnUninstallation = true;
    private boolean revertOnlyIfNotModified = false;
    private Properties persistentProperties = new Properties();
    private static final String PROP_VARIABLE_NAME = "variableName";
    private static final String PROP_VARIABLE_VALUE = "variableValue";
    private static final String PROP_USER_SPECIFIC = "userSpecific";
    private static final String PROP_TYPE = "type";
    private static final String PROP_ORIGINAL_VALUE = "originalValue";
    private static final String PROP_MODIFIED_VALUE = "modifiedValue";
    private static final String PROP_AUTO_UNINSTALL_TYPE = "autoUninstallType";
    private static final String AUTO_UNINSTALL_TYPE_NEVER = "never";
    private static final String AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED = "onlyIfNotModified";
    private static final String AUTO_UNINSTALL_TYPE_ALWAYS = "always";

    public ModifyStringType getType() {
        return this.type;
    }

    public void setType(ModifyStringType type) {
        this.type = type;
    }

    public String getVariableName() {
        return ModifyEnvironmentVariableAction.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getValue() {
        return ModifyEnvironmentVariableAction.replaceVariables(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    public void setUserSpecific(boolean userSpecific) {
        this.userSpecific = userSpecific;
    }

    public boolean isRevertOnUninstallation() {
        return this.revertOnUninstallation;
    }

    public void setRevertOnUninstallation(boolean revertOnUninstallation) {
        this.revertOnUninstallation = revertOnUninstallation;
    }

    public boolean isRevertOnlyIfNotModified() {
        return this.revertOnlyIfNotModified;
    }

    public void setRevertOnlyIfNotModified(boolean revertOnlyIfNotModified) {
        this.revertOnlyIfNotModified = revertOnlyIfNotModified;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        try {
            String modifiedValue;
            String autoUninstallType = AUTO_UNINSTALL_TYPE_NEVER;
            if (this.revertOnUninstallation) {
                String originalValue = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific());
                if (originalValue != null) {
                    this.persistentProperties.setProperty(PROP_ORIGINAL_VALUE, originalValue);
                }
                autoUninstallType = this.revertOnlyIfNotModified ? AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED : AUTO_UNINSTALL_TYPE_ALWAYS;
            }
            List<InstallAction> rollbackActions = EnvVars.set(this.getVariableName(), this.getValue(), this.isUserSpecific(), this.type == ModifyStringType.APPEND, this.type == ModifyStringType.PREPEND);
            this.addRollbackActions(rollbackActions);
            if (rollbackActions.size() == 0) {
                autoUninstallType = AUTO_UNINSTALL_TYPE_NEVER;
            }
            if (!autoUninstallType.equals(AUTO_UNINSTALL_TYPE_NEVER) && (modifiedValue = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific())) != null) {
                this.persistentProperties.setProperty(PROP_MODIFIED_VALUE, modifiedValue);
            }
            this.persistentProperties.setProperty(PROP_VARIABLE_NAME, this.getVariableName());
            this.persistentProperties.setProperty(PROP_VARIABLE_VALUE, this.getValue());
            this.persistentProperties.setProperty(PROP_USER_SPECIFIC, String.valueOf(this.isUserSpecific()));
            this.persistentProperties.setProperty(PROP_TYPE, this.getType().toString());
            this.persistentProperties.setProperty(PROP_AUTO_UNINSTALL_TYPE, autoUninstallType);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (this.persistentProperties.size() == 0) {
            return this.execute(context);
        }
        try {
            String autoUninstallType = this.persistentProperties.getProperty(PROP_AUTO_UNINSTALL_TYPE);
            if (!autoUninstallType.equals(AUTO_UNINSTALL_TYPE_NEVER)) {
                String variableName = this.persistentProperties.getProperty(PROP_VARIABLE_NAME);
                boolean userSpecific = Boolean.valueOf(this.persistentProperties.getProperty(PROP_USER_SPECIFIC));
                String currentValue = EnvVars.getWinNT(variableName, userSpecific);
                String originalValue = this.persistentProperties.getProperty(PROP_ORIGINAL_VALUE);
                if (currentValue != null) {
                    if (autoUninstallType.equals(AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED)) {
                        if (currentValue.equals(this.persistentProperties.getProperty(PROP_MODIFIED_VALUE))) {
                            EnvVars.setWinNT(variableName, originalValue, userSpecific);
                        }
                    } else {
                        ModifyStringType type = ModifyStringType.getFromString(this.persistentProperties.getProperty(PROP_TYPE));
                        if (type == ModifyStringType.SET || currentValue.equals(this.persistentProperties.getProperty(PROP_MODIFIED_VALUE))) {
                            EnvVars.setWinNT(variableName, originalValue, userSpecific);
                        } else {
                            int index;
                            String addedMainValue;
                            String addedValue = addedMainValue = this.persistentProperties.getProperty(PROP_VARIABLE_VALUE);
                            if (type == ModifyStringType.APPEND) {
                                if (originalValue != null && originalValue.length() > 0) {
                                    addedValue = ";" + addedValue;
                                }
                                if ((index = currentValue.endsWith(addedValue) ? currentValue.length() - addedValue.length() : currentValue.lastIndexOf(addedValue + ";")) == -1) {
                                    addedValue = addedMainValue;
                                    index = currentValue.endsWith(addedValue) ? currentValue.length() - addedValue.length() : currentValue.lastIndexOf(addedValue + ";");
                                }
                            } else {
                                if (originalValue != null && originalValue.length() > 0) {
                                    addedValue = addedValue + ";";
                                }
                                if ((index = currentValue.startsWith(addedValue) ? 0 : currentValue.indexOf(";" + addedValue) - 1) < 0) {
                                    addedValue = addedMainValue;
                                    index = currentValue.startsWith(addedValue) ? 0 : currentValue.indexOf(";" + addedValue) - 1;
                                }
                            }
                            if (index > -1) {
                                String newValue = currentValue.substring(0, index) + currentValue.substring(index + addedValue.length());
                                EnvVars.setWinNT(variableName, newValue, userSpecific);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    @Override
    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }
}

