/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.misc.MacosVmOptionsType;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractModifyVmOptionsAction
extends SystemInstallAction {
    private String launcherId = "";
    private MacosVmOptionsType macosVmOptionsType = MacosVmOptionsType.INNER;
    private static final String[] REPLACE_OPTION_PREFIXES = new String[]{"-Xmx", "-Xms", "-Xss", "-Xloggc:", "-Xbootclasspath:", "-Xbootclasspath/a:", "-Xbootclasspath/p:", "-verbose:", "-ea:", "-da:", "-enableassertions:", "-disableassertions:", "-agentlib:", "-agentpath:", "-javaagent:", "-splash:", "-classpath ", "-classpath/a ", "-classpath/p "};

    protected abstract String[] getAddVmOptions();

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public MacosVmOptionsType getMacosVmOptionsType() {
        return this.macosVmOptionsType;
    }

    public void setMacosVmOptionsType(MacosVmOptionsType macosVmOptionsType) {
        this.macosVmOptionsType = macosVmOptionsType;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        File launcherFile = null;
        LauncherSetup launcherSetup = context.getLauncherById(this.launcherId);
        if (launcherSetup != null) {
            MacSpecificConfig macSpecificConfig = InstallerConfig.getCurrentInstance().getMacSpecificConfig();
            launcherFile = Util.isMacosInstaller() && macSpecificConfig.isSingleBundle() ? context.getDestinationFile(macSpecificConfig.getSingleBundleName()) : context.getDestinationFile(launcherSetup.getRelativeFileName());
        }
        if (launcherFile == null || !launcherFile.exists()) {
            Logger.getInstance().error(this, "launcher file " + launcherFile + " does not exist.");
            return false;
        }
        try {
            if (launcherFile.isDirectory()) {
                if (InstallerConfig.getCurrentInstance().getMacSpecificConfig().isAppleLauncher()) {
                    return this.modifyInfoPlist(launcherFile, context);
                }
                File vmOptionsFile = this.getMacosVmOptionsType() == MacosVmOptionsType.OUTER ? new File(launcherFile.getParentFile(), launcherFile.getName().replace(".app", "") + ".vmoptions") : new File(launcherFile, "Contents/vmoptions.txt");
                return this.modifyVmOptions(vmOptionsFile, context);
            }
            String vmOptionsPath = launcherFile.getAbsolutePath();
            if (vmOptionsPath.endsWith(".exe")) {
                vmOptionsPath = vmOptionsPath.substring(0, vmOptionsPath.length() - 4);
            }
            vmOptionsPath = vmOptionsPath + ".vmoptions";
            return this.modifyVmOptions(new File(vmOptionsPath), context);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.getInstance().log(e);
            return false;
        }
    }

    private boolean modifyVmOptions(File vmOptionsFile, InstallerContext context) throws IOException, UserCanceledException {
        if (!vmOptionsFile.exists()) {
            FileInstaller.getInstance().registerUninstallFile(vmOptionsFile);
        } else {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(vmOptionsFile, false);
            backupAction.install(context);
            this.addRollbackAction(backupAction);
        }
        List<String> oldVmOptions = AbstractModifyVmOptionsAction.readVmOptions(vmOptionsFile);
        List<String> newVmOptions = AbstractModifyVmOptionsAction.addVmOptions(oldVmOptions, new ArrayList<String>(Arrays.asList(this.getAddVmOptions())));
        AbstractModifyVmOptionsAction.writeFile(vmOptionsFile, newVmOptions);
        return true;
    }

    private static void writeFile(final File vmOptionsFile, final List<String> newVmOptions) {
        HelperCommunication.getInstance().executeAction(ContentInstaller.getExecutionContext(), new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                PrintWriter pw = new PrintWriter(new FileOutputStream(vmOptionsFile));
                for (String newVmOption : newVmOptions) {
                    pw.println(newVmOption);
                }
                pw.close();
            }
        });
    }

    private static List<String> addVmOptions(List<String> oldVmOptions, List<String> addVmOptions) {
        ArrayList<String> newOptions = new ArrayList<String>();
        for (String oldVmOption : oldVmOptions) {
            String option = oldVmOption.trim();
            addVmOptions.remove(option);
            if (option.startsWith("-D")) {
                option = AbstractModifyVmOptionsAction.findReplaceOption(addVmOptions, AbstractModifyVmOptionsAction.getParameterPrefix(option), option);
            } else {
                for (String replaceOptionPrefix : REPLACE_OPTION_PREFIXES) {
                    if (!option.startsWith(replaceOptionPrefix)) continue;
                    option = AbstractModifyVmOptionsAction.findReplaceOption(addVmOptions, replaceOptionPrefix, option);
                }
            }
            newOptions.add(option);
        }
        for (String addVmOption : addVmOptions) {
            newOptions.add(addVmOption);
        }
        return newOptions;
    }

    private static String getParameterPrefix(String option) {
        int equalPos = option.indexOf(61);
        if (equalPos > -1) {
            return option.substring(0, equalPos + 1);
        }
        return option;
    }

    private static String findReplaceOption(List<String> addVmOptions, String prefix, String oldOption) {
        Iterator<String> iterator = addVmOptions.iterator();
        while (iterator.hasNext()) {
            String option = iterator.next();
            if (!option.trim().startsWith(prefix)) continue;
            iterator.remove();
            return option;
        }
        return oldOption;
    }

    private static List<String> readVmOptions(File vmOptionsFile) throws IOException {
        ArrayList<String> vmOptions = new ArrayList<String>();
        if (vmOptionsFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(vmOptionsFile));
            String line = reader.readLine();
            while (line != null) {
                vmOptions.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        return vmOptions;
    }

    private boolean modifyInfoPlist(File launcherFile, InstallerContext context) throws IOException, UserCanceledException {
        File infoPlistFile = new File(launcherFile, "/Contents/Info.plist");
        if (!infoPlistFile.exists()) {
            Logger.getInstance().error(this, "Info.plist file " + infoPlistFile + " does not exist.");
            return false;
        }
        BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(infoPlistFile, false);
        backupAction.install(context);
        this.addRollbackAction(backupAction);
        SplitupVMOptions splitupVMOptions = AbstractModifyVmOptionsAction.splitupVMOptions(this.getAddVmOptions());
        File tempFile = new File(infoPlistFile.getAbsolutePath() + ".temp");
        tempFile.delete();
        infoPlistFile.renameTo(tempFile);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "UTF-8"));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlistFile), "UTF-8"));
        String line = bufferedReader.readLine();
        while (line != null) {
            int vmOptionsEndTagIndex = line.indexOf("</string><!-- I4J_INSERT_VMOPTIONS -->");
            int classpathEndTagIndex = line.indexOf("</string><!-- I4J_INSERT_CLASSPATH -->");
            if (vmOptionsEndTagIndex > -1) {
                pw.print(line.substring(0, vmOptionsEndTagIndex));
                if (line.charAt(vmOptionsEndTagIndex - 1) != '>') {
                    pw.print(" ");
                }
                pw.print(splitupVMOptions.rest);
                pw.println(line.substring(vmOptionsEndTagIndex));
            } else if (classpathEndTagIndex > -1) {
                this.addClasspath(pw, line, classpathEndTagIndex, splitupVMOptions);
            } else if (line.contains("<!-- I4J_INSERT_PROPERTIES -->")) {
                for (Map.Entry<Object, Object> entry : splitupVMOptions.vmProperties.entrySet()) {
                    pw.println("<key>" + entry.getKey() + "</key>");
                    pw.println("<string>" + entry.getValue() + "</string>");
                }
                pw.println(line);
            } else {
                pw.println(line);
            }
            line = bufferedReader.readLine();
        }
        pw.close();
        bufferedReader.close();
        tempFile.delete();
        return true;
    }

    private void addClasspath(PrintWriter pw, String line, int classpathEndTagIndex, SplitupVMOptions vmOptionsWithoutProperties) throws IOException {
        int startIndex = line.indexOf(".install4j/i4jruntime.jar");
        if (startIndex == -1) {
            throw new IOException("could not find i4jruntime.jar in Info.plist file");
        }
        String oldClasspath = line.substring(startIndex += ".install4j/i4jruntime.jar".length(), classpathEndTagIndex);
        if (oldClasspath.startsWith(File.pathSeparator)) {
            oldClasspath = oldClasspath.substring(1);
        }
        String classpath = "";
        if (vmOptionsWithoutProperties.classpathPrepend != null && vmOptionsWithoutProperties.classpathPrepend.length() > 0) {
            if (!classpath.endsWith(File.pathSeparator) && classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + vmOptionsWithoutProperties.classpathPrepend;
        }
        if (vmOptionsWithoutProperties.classpath != null && vmOptionsWithoutProperties.classpath.length() > 0) {
            if (!classpath.endsWith(File.pathSeparator) && classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + vmOptionsWithoutProperties.classpath;
        } else if (oldClasspath.length() > 0) {
            if (!classpath.endsWith(File.pathSeparator) && classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + oldClasspath;
        }
        if (vmOptionsWithoutProperties.classpathAppend != null && vmOptionsWithoutProperties.classpathAppend.length() > 0) {
            if (!classpath.endsWith(File.pathSeparator) && classpath.length() > 0) {
                classpath = classpath + File.pathSeparator;
            }
            classpath = classpath + vmOptionsWithoutProperties.classpathAppend;
        }
        pw.print(line.substring(0, startIndex));
        if (classpath.length() > 0) {
            pw.print(File.pathSeparator);
        }
        pw.print(classpath);
        pw.println(line.substring(classpathEndTagIndex));
    }

    private static SplitupVMOptions splitupVMOptions(String[] vmOptions) {
        SplitupVMOptions splitupVmOptions = new SplitupVMOptions();
        for (String vmOption : vmOptions) {
            int equalPos = vmOption.indexOf(61);
            if (vmOption.startsWith("-D") && equalPos > -1 && vmOption.length() > equalPos + 1) {
                String key = vmOption.substring(2, equalPos);
                String value = vmOption.substring(equalPos + 1);
                splitupVmOptions.vmProperties.setProperty(key, value);
                continue;
            }
            if (vmOption.startsWith("-classpath ")) {
                splitupVmOptions.classpath = AbstractModifyVmOptionsAction.fixPath(vmOption.substring("-classpath ".length()));
                continue;
            }
            if (vmOption.startsWith("-classpath/a ")) {
                splitupVmOptions.classpathAppend = AbstractModifyVmOptionsAction.fixPath(vmOption.substring("-classpath/a ".length()));
                continue;
            }
            if (vmOption.startsWith("-classpath/p ")) {
                splitupVmOptions.classpathPrepend = AbstractModifyVmOptionsAction.fixPath(vmOption.substring("-classpath/p ".length()));
                continue;
            }
            if (splitupVmOptions.rest.length() > 0) {
                splitupVmOptions.rest = splitupVmOptions.rest + " ";
            }
            splitupVmOptions.rest = splitupVmOptions.rest + vmOption;
        }
        return splitupVmOptions;
    }

    private static String fixPath(String path) {
        return path.replace('\\', File.separatorChar).replace('/', File.separatorChar).replace(':', File.pathSeparatorChar).replace(';', File.pathSeparatorChar);
    }

    private static class SplitupVMOptions {
        Properties vmProperties = new Properties();
        String classpath;
        String classpathAppend;
        String classpathPrepend;
        String rest = "";

        private SplitupVMOptions() {
        }
    }
}

