/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinAssociations;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.desktop.MacAssociationRole;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public class CreateFileAssociationAction
extends SystemAutoUninstallInstallAction {
    private String extension = "";
    private String description = "";
    private String launcherId = "";
    private boolean selected = true;
    private boolean windows = true;
    private ExternalFile windowsIconFile = null;
    private String winAdditionalParameters = null;
    private boolean mac = true;
    private ExternalFile macIconFile = null;
    private boolean restartFinder = false;
    private MacAssociationRole macAssociationRole = MacAssociationRole.VIEWER;
    private static final String PROP_EXTENSION = "extension";
    private static final String PROP_EXECUTABLE = "executable";
    private static boolean finderRestarted = false;

    public boolean isRestartFinder() {
        return this.restartFinder;
    }

    public void setRestartFinder(boolean restartFinder) {
        this.restartFinder = restartFinder;
    }

    public String getExtension() {
        return CreateFileAssociationAction.replaceVariables(this.extension);
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getDescription() {
        return CreateFileAssociationAction.replaceVariables(this.description, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public void setWindows(boolean windows) {
        this.windows = windows;
    }

    public ExternalFile getWindowsIconFile() {
        return this.windowsIconFile;
    }

    public void setWindowsIconFile(ExternalFile windowsIconFile) {
        this.windowsIconFile = windowsIconFile;
    }

    public String getWinAdditionalParameters() {
        return CreateFileAssociationAction.replaceVariables(this.winAdditionalParameters);
    }

    public void setWinAdditionalParameters(String winAdditionalParameters) {
        this.winAdditionalParameters = winAdditionalParameters;
    }

    public boolean isMac() {
        return this.mac;
    }

    public void setMac(boolean mac) {
        this.mac = mac;
    }

    public ExternalFile getMacIconFile() {
        return this.macIconFile;
    }

    public void setMacIconFile(ExternalFile macIconFile) {
        this.macIconFile = macIconFile;
    }

    public MacAssociationRole getMacRole() {
        return this.macAssociationRole;
    }

    public void setMacRole(MacAssociationRole macAssociationRole) {
        this.macAssociationRole = macAssociationRole;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (!this.isSelected()) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows() && this.isWindows()) {
                return this.installWindows(context);
            }
            if (InstallerUtil.isMacOS() && this.isMac()) {
                return this.installMac(context);
            }
            Util.logInfo(this, "Nothing to do");
        }
        catch (IOException e) {
            Util.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean uninstall(UninstallerContext context) {
        try {
            if (InstallerUtil.isWindows()) {
                this.uninstallWindows();
            }
        }
        catch (Throwable e) {
            Util.log(e);
        }
        return true;
    }

    private void uninstallWindows() throws IOException {
        Properties persistentProperties = this.getPersistentProperties();
        String extension = persistentProperties.getProperty(PROP_EXTENSION);
        String executablePath = persistentProperties.getProperty(PROP_EXECUTABLE);
        if (executablePath == null || extension == null) {
            return;
        }
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        File executable = new File(executablePath).getCanonicalFile();
        String registeredExecutableName = WinAssociations.getExecutable(extension);
        if (registeredExecutableName != null && new File(registeredExecutableName).getCanonicalFile().equals(executable)) {
            WinAssociations.remove(extension);
        }
    }

    private boolean installWindows(InstallerContext context) throws UserCanceledException {
        File executable = this.getExecutableFile(context);
        if (executable == null || !executable.exists()) {
            Util.logError(this, "executable does not exist: " + executable);
            return false;
        }
        File icon = context.getExternalFile(this.getWindowsIconFile(), true);
        String usedExtension = this.getExtension();
        if (!usedExtension.startsWith(".")) {
            usedExtension = "." + usedExtension;
        }
        this.addRollbackActions(FileAssociations.create(usedExtension, this.getDescription(), icon, executable, this.getWinAdditionalParameters()));
        Properties persistentProperties = this.getPersistentProperties();
        persistentProperties.setProperty(PROP_EXTENSION, usedExtension);
        persistentProperties.setProperty(PROP_EXECUTABLE, executable.getAbsolutePath());
        return true;
    }

    private boolean installMac(InstallerContext context) throws IOException {
        File bundleDir = this.getBundleDir(context);
        if (bundleDir != null && bundleDir.exists()) {
            File infoPlistFile = new File(bundleDir, "Contents/Info.plist");
            if (infoPlistFile.exists()) {
                CreateFileAssociationAction.addAssociation(infoPlistFile, this.getExtension(), this.getDescription(), context.getExternalFile(this.getMacIconFile(), true), this.getMacRole().toString());
                this.refresh(bundleDir);
                return true;
            }
            Util.logError(this, "infoPlistFile not found: " + infoPlistFile);
        } else {
            Util.logError(this, "bundleDir not found: " + bundleDir);
        }
        return false;
    }

    private File getBundleDir(Context context) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File bundleDir = null;
        if (config.getMacSpecificConfig().isSingleBundle()) {
            bundleDir = context.getDestinationFile(config.getMacSpecificConfig().getSingleBundleName());
        } else {
            LauncherConfig launcher = config.getLauncherConfigById(this.getLauncherId());
            if (launcher != null) {
                bundleDir = context.getDestinationFile(launcher.getFile());
            }
        }
        return bundleDir;
    }

    private File getExecutableFile(Context context) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        LauncherConfig launcher = config.getLauncherConfigById(this.getLauncherId());
        if (launcher == null) {
            return null;
        }
        return context.getDestinationFile(launcher.getFile());
    }

    private void refresh(File bundleDir) {
        try {
            String[] command = new String[]{"/System/Library/Frameworks/ApplicationServices.framework/Frameworks/LaunchServices.framework/Support/lsregister", "-R", "-f", bundleDir.getAbsolutePath()};
            if (!new File(command[0]).exists()) {
                command[0] = "/System/Library/Frameworks/CoreServices.framework/Frameworks/LaunchServices.framework/Support/lsregister";
            }
            if (!Execution.executeAndWait(command, null)) {
                Util.logError(this, "refresh db not successful");
            }
        }
        catch (IOException e) {
            Util.logError(this, "could not refresh db: " + e.getMessage());
        }
        if (this.restartFinder && !finderRestarted) {
            finderRestarted = true;
            Runtime.getRuntime().addShutdownHook(new Thread("finder restart"){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec("killall -SIGHUP Finder");
                    }
                    catch (IOException e) {
                        System.err.println("could not restart finder: " + e.getMessage());
                    }
                }
            });
        }
    }

    private static void addAssociation(File infoPlistFile, String extension, String description, File icon, String role) throws IOException {
        if (icon != null) {
            File resourceFile = new File(new File(infoPlistFile.getParentFile(), "Resources"), icon.getName());
            FileUtil.copyFile(icon, resourceFile);
            FileInstaller.getInstance().registerUninstallFile(resourceFile);
        }
        File tempFile = new File(infoPlistFile.getAbsolutePath() + ".temp");
        tempFile.delete();
        infoPlistFile.renameTo(tempFile);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "UTF-8"));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlistFile), "UTF-8"));
        String line = bufferedReader.readLine();
        boolean doctypesFound = false;
        boolean inserted = false;
        while (line != null) {
            pw.println(line);
            String nextLine = bufferedReader.readLine();
            if (!inserted) {
                if (line.contains("CFBundleDocumentTypes")) {
                    doctypesFound = true;
                } else if (doctypesFound && line.contains("<array>")) {
                    CreateFileAssociationAction.insertAssociation(pw, extension, description, icon, role);
                    inserted = true;
                } else if (line.contains("<!-- I4J_INSERT_DOCTYPE -->") && (nextLine == null || !nextLine.contains("CFBundleDocumentTypes"))) {
                    pw.println("<key>CFBundleDocumentTypes</key>");
                    pw.println("<array>");
                    CreateFileAssociationAction.insertAssociation(pw, extension, description, icon, role);
                    pw.println("</array>");
                    inserted = true;
                }
            }
            line = nextLine;
        }
        pw.close();
        bufferedReader.close();
        tempFile.delete();
    }

    private static void insertAssociation(PrintWriter pw, String extension, String description, File icon, String role) {
        pw.println("<dict>");
        pw.println("<key>CFBundleTypeExtensions</key>");
        pw.println("<array>");
        pw.println("<string>" + extension + "</string>");
        pw.println("</array>");
        pw.println("<key>CFBundleTypeName</key>");
        pw.println("<string>" + description + "</string>");
        if (icon != null) {
            pw.println("<key>CFBundleTypeIconFile</key>");
            pw.println("<string>" + icon.getName() + "</string>");
        }
        pw.println("<key>CFBundleTypeRole</key>");
        pw.println("<string>" + role + "</string>");
        pw.println("</dict>");
    }

    @Override
    public void rollback(InstallerContext context) {
        super.rollback(context);
        if (InstallerUtil.isWindows()) {
            Registry.changeNotifyAssociations();
        }
    }

    public boolean fileExists(Context context) {
        File testFile = null;
        if (Util.isWindowsInstaller()) {
            testFile = this.getExecutableFile(context);
        } else if (Util.isMacosInstaller()) {
            testFile = this.getBundleDir(context);
        }
        return testFile != null && testFile.exists();
    }
}

