/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;

public class SetVariableAction
extends SystemInstallOrUninstallAction {
    private ScriptProperty script;
    private String variableName;
    private boolean onlyIfUndefined = false;
    private boolean failIfNull = false;
    private boolean responseFileVariable = false;

    public ScriptProperty getScript() {
        return this.script;
    }

    public void setScript(ScriptProperty script) {
        this.script = script;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isOnlyIfUndefined() {
        return this.onlyIfUndefined;
    }

    public void setOnlyIfUndefined(boolean onlyIfUndefined) {
        this.onlyIfUndefined = onlyIfUndefined;
    }

    public boolean isFailIfNull() {
        return this.failIfNull;
    }

    public void setFailIfNull(boolean failIfNull) {
        this.failIfNull = failIfNull;
    }

    public boolean isResponseFileVariable() {
        return this.responseFileVariable;
    }

    public void setResponseFileVariable(boolean responseFileVariable) {
        this.responseFileVariable = responseFileVariable;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            String name = this.getVariableName();
            if (!this.onlyIfUndefined || context.getVariable(name) == null) {
                Object value = context.runScript(this.script, this, null);
                if (value == null && this.failIfNull) {
                    return false;
                }
                context.setVariable(name, value);
                if (this.responseFileVariable) {
                    context.registerResponseFileVariable(name);
                }
            }
            return true;
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
            return false;
        }
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

