/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net.connection;

import com.jscape.util.aV;
import com.jscape.util.io.DataCodec;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncMessageConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.MessageCodecConnection;
import com.jscape.util.net.connection.SyncMessageConnectionSyncRawBase;
import com.jscape.util.net.connection.SyncRawConnection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncMessageConnectionSyncRawBase<M>
implements AsyncMessageConnection<M>,
MessageCodecConnection<M>,
Runnable {
    private final SyncMessageConnectionSyncRawBase<M> base;
    private final ExecutorService executorService;
    private final AtomicBoolean closed;
    private AsyncMessageConnection.Listener<M> listener;

    public AsyncMessageConnectionSyncRawBase(SyncRawConnection syncRawConnection, DataCodec<M> dataCodec, ExecutorService executorService) {
        this(new SyncMessageConnectionSyncRawBase<M>(syncRawConnection, dataCodec), executorService);
    }

    public AsyncMessageConnectionSyncRawBase(SyncMessageConnectionSyncRawBase<M> syncMessageConnectionSyncRawBase, ExecutorService executorService) {
        aV.a(syncMessageConnectionSyncRawBase);
        this.base = syncMessageConnectionSyncRawBase;
        aV.a(executorService);
        this.executorService = executorService;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public long creationTime() {
        return this.base.creationTime();
    }

    @Override
    public TransportAddress localAddress() {
        return this.base.localAddress();
    }

    @Override
    public TransportAddress remoteAddress() {
        return this.base.remoteAddress();
    }

    @Override
    public Map<Object, Object> attributes() {
        return this.base.attributes();
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.base.close();
        if (this.listener != null) {
            this.listener.onClosed(this);
        }
    }

    @Override
    public void start(AsyncMessageConnection.Listener<M> listener) throws Connection.ConnectionException {
        aV.a(listener);
        this.listener = listener;
        this.executorService.submit(this);
    }

    @Override
    public void write(M m10) throws Connection.ConnectionException {
        this.base.write(m10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int n2 = Connection.ConnectionException.b();
        try {
            while (!this.closed.get()) {
                try {
                    this.readNextMessage();
                    if (n2 != 0 && n2 != 0) continue;
                    return;
                }
                catch (Throwable throwable) {
                    throw AsyncMessageConnectionSyncRawBase.a(throwable);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.processError(throwable);
        }
    }

    public SyncRawConnection base() {
        return this.base.base();
    }

    @Override
    public DataCodec<M> messageCodec() {
        return this.base.messageCodec();
    }

    @Override
    public void messageCodec(DataCodec<M> dataCodec) {
        this.base.messageCodec(dataCodec);
    }

    public String toString() {
        return this.base.toString();
    }

    private void readNextMessage() throws Exception {
        try {
            M m10 = this.base.read();
            this.listener.onMessage(this, m10);
        }
        catch (Connection.ReadTimeoutException readTimeoutException) {
            try {
                if (!this.closed.get()) {
                    this.listener.onIdle(this);
                }
            }
            catch (Connection.ReadTimeoutException readTimeoutException2) {
                throw AsyncMessageConnectionSyncRawBase.a(readTimeoutException2);
            }
        }
        catch (Connection.EOFException eOFException) {
            try {
                if (!this.closed.get()) {
                    this.listener.onEof(this);
                }
            }
            catch (Connection.ReadTimeoutException readTimeoutException) {
                throw AsyncMessageConnectionSyncRawBase.a(readTimeoutException);
            }
        }
    }

    private void processError(Throwable throwable) {
        if (!this.closed.get()) {
            this.listener.onError(this, throwable);
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

