/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net.connection;

import com.jscape.util.aV;
import com.jscape.util.io.ByteArrayInputStream;
import com.jscape.util.io.ByteArrayOutputStream;
import com.jscape.util.io.DataCodec;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncMessageConnection;
import com.jscape.util.net.connection.AsyncRawConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.MessageCodecConnection;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncMessageConnectionAsyncRawBase<M>
implements AsyncMessageConnection<M>,
MessageCodecConnection<M>,
AsyncRawConnection.Listener {
    private final AsyncRawConnection base;
    private DataCodec<M> messageCodec;
    private final ByteArrayOutputStream writeBuffer;
    private final ByteArrayOutputStream readBuffer;
    private final ByteArrayInputStream in;
    private final AtomicBoolean closed;
    private AsyncMessageConnection.Listener<M> listener;

    public AsyncMessageConnectionAsyncRawBase(AsyncRawConnection asyncRawConnection, DataCodec<M> dataCodec) {
        int n2 = Connection.ConnectionException.c();
        aV.a(asyncRawConnection);
        this.base = asyncRawConnection;
        aV.a(dataCodec);
        this.messageCodec = dataCodec;
        int n3 = n2;
        this.writeBuffer = new ByteArrayOutputStream();
        this.readBuffer = new ByteArrayOutputStream();
        this.in = new ByteArrayInputStream(this.readBuffer.a());
        this.closed = new AtomicBoolean(false);
        if (n3 != 0) {
            aV.b(new String[1]);
        }
    }

    @Override
    public long creationTime() {
        return this.base.creationTime();
    }

    @Override
    public TransportAddress localAddress() {
        return this.base.localAddress();
    }

    @Override
    public TransportAddress remoteAddress() {
        return this.base.remoteAddress();
    }

    @Override
    public Map<Object, Object> attributes() {
        return this.base.attributes();
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.base.close();
        if (this.listener != null) {
            this.listener.onClosed(this);
        }
    }

    @Override
    public void start(AsyncMessageConnection.Listener<M> listener) throws Connection.ConnectionException {
        aV.a(listener);
        this.listener = listener;
        this.base.start(this);
    }

    @Override
    public void write(M m10) throws Connection.ConnectionException {
        try {
            this.messageCodec.write(m10, this.writeBuffer);
            this.base.write(this.writeBuffer.a(), 0, this.writeBuffer.b());
            this.base.flush();
        }
        catch (Exception exception) {
            throw Connection.ConnectionException.wrap(exception);
        }
        finally {
            this.writeBuffer.c();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onData(AsyncRawConnection asyncRawConnection, byte[] byArray, int n2, int n3) {
        this.readBuffer.write(byArray, n2, n3);
        int n4 = Connection.ConnectionException.c();
        this.in.a(this.readBuffer.a(), 0, this.readBuffer.b());
        int n5 = n4;
        try {
            M m10;
            while ((m10 = this.nextMessage()) != null) {
                try {
                    this.listener.onMessage(this, m10);
                    if (n5 == 0 && n5 == 0) continue;
                    return;
                }
                catch (Exception exception) {
                    throw AsyncMessageConnectionAsyncRawBase.a(exception);
                    return;
                }
            }
        }
        catch (Exception exception) {
            try {
                if (this.closed.get()) return;
                this.listener.onError(this, exception);
                return;
            }
            catch (Exception exception2) {
                throw AsyncMessageConnectionAsyncRawBase.a(exception2);
            }
        }
    }

    @Override
    public void onEof(AsyncRawConnection asyncRawConnection) {
        if (!this.closed.get()) {
            this.listener.onEof(this);
        }
    }

    @Override
    public void onError(AsyncRawConnection asyncRawConnection, Throwable throwable) {
        if (!this.closed.get()) {
            this.listener.onError(this, throwable);
        }
    }

    @Override
    public void onClosed(AsyncRawConnection asyncRawConnection) {
        if (!this.closed.get()) {
            this.listener.onError(this, new Connection.ConnectionClosedException());
        }
    }

    @Override
    public void onIdle(AsyncRawConnection asyncRawConnection) {
        if (!this.closed.get()) {
            this.listener.onIdle(this);
        }
    }

    public AsyncRawConnection base() {
        return this.base;
    }

    @Override
    public DataCodec<M> messageCodec() {
        return this.messageCodec;
    }

    @Override
    public void messageCodec(DataCodec<M> dataCodec) {
        aV.a(dataCodec);
        this.messageCodec = dataCodec;
    }

    public String toString() {
        return this.base.toString();
    }

    private M nextMessage() throws IOException {
        try {
            if (this.in.available() == 0) {
                return null;
            }
            Object t2 = this.messageCodec.read(this.in);
            int n2 = this.readBuffer.b() - this.in.available();
            this.readBuffer.b(n2);
            this.in.a(this.readBuffer.a(), 0, this.readBuffer.b());
            return (M)t2;
        }
        catch (Connection.EOFException | EOFException iOException) {
            return null;
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

