/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.util.net;

import com.jscape.util.aV;
import com.jscape.util.aa;
import com.jscape.util.eC;
import com.jscape.util.net.MessageConnectionHandler;
import com.jscape.util.net.TransportAddress;
import com.jscape.util.net.connection.AsyncConnector;
import com.jscape.util.net.connection.AsyncMessageConnection;
import com.jscape.util.net.connection.Connection;
import com.jscape.util.net.connection.RawConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageConnectionServer<C extends RawConnection, M>
extends eC<MessageConnectionHandler<C, M>>
implements AsyncConnector.Listener<C>,
AsyncMessageConnection.Listener<M> {
    private final AsyncConnector<C> connector;
    private final String name;
    private final AtomicInteger totalConnectionCount;
    private final List<AsyncMessageConnection<M>> connections;
    private final Lock lock;
    private final AtomicBoolean paused;
    private final AtomicReference<Throwable> error;
    private final Logger logger;
    private static final String[] d;

    public MessageConnectionServer(AsyncConnector<C> asyncConnector, String string, Logger logger) {
        aV.a(asyncConnector);
        this.connector = asyncConnector;
        String string2 = TransportAddress.b();
        aV.a((Object)string);
        String string3 = string2;
        this.name = string;
        this.totalConnectionCount = new AtomicInteger(0);
        this.connections = new LinkedList<AsyncMessageConnection<M>>();
        this.lock = new ReentrantLock();
        this.paused = new AtomicBoolean(false);
        this.error = new AtomicReference();
        aV.a(logger);
        this.logger = logger;
        if (string3 != null) {
            aV.b(new String[5]);
        }
    }

    public TransportAddress boundAddress() {
        return this.connector.boundAddress();
    }

    public boolean paused() {
        return this.paused.get();
    }

    public int connectionCount() {
        this.lock.lock();
        try {
            int n2 = this.connections.size();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int totalConnectionCount() {
        return this.totalConnectionCount.get();
    }

    public Collection<AsyncMessageConnection<M>> connections() {
        this.lock.lock();
        try {
            ArrayList<AsyncMessageConnection<M>> arrayList = new ArrayList<AsyncMessageConnection<M>>(this.connections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onConnection(AsyncConnector<C> asyncConnector, C c10) {
        try {
            if (this.paused.get()) {
                c10.close();
                return;
            }
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            throw MessageConnectionServer.a(operationException);
        }
        this.logIncomingConnection((Connection)c10);
        this.totalConnectionCount.incrementAndGet();
        try {
            AsyncMessageConnection asyncMessageConnection = ((MessageConnectionHandler)this.b).onConnection(c10);
            this.add(asyncMessageConnection);
            this.startConnection(asyncMessageConnection);
        }
        catch (MessageConnectionHandler.OperationException operationException) {
            c10.close();
        }
    }

    @Override
    public void onError(AsyncConnector<C> asyncConnector, Throwable throwable) {
        this.logConnectorError(throwable);
        this.error.set(throwable);
        this.a();
    }

    @Override
    public void onMessage(AsyncMessageConnection<M> asyncMessageConnection, M m10) {
        ((MessageConnectionHandler)this.b).onMessage(asyncMessageConnection, m10);
    }

    @Override
    public void onEof(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionEof(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onIdle(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionIdle(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onIdle(asyncMessageConnection);
    }

    @Override
    public void onError(AsyncMessageConnection<M> asyncMessageConnection, Throwable throwable) {
        if (!(throwable instanceof Connection.ConnectionClosedException)) {
            this.logConnectionError(asyncMessageConnection, throwable);
        }
        ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
    }

    @Override
    public void onClosed(AsyncMessageConnection<M> asyncMessageConnection) {
        this.logConnectionClosed(asyncMessageConnection);
        this.remove(asyncMessageConnection);
        ((MessageConnectionHandler)this.b).onClosed(asyncMessageConnection);
    }

    public synchronized void pause() throws aa {
        this.g();
        this.paused.set(true);
        this.logServicePaused();
    }

    public synchronized void resume() throws aa {
        this.g();
        this.paused.set(false);
        this.logServiceResumed();
    }

    @Override
    protected void actualStart() throws Exception {
        this.paused.set(false);
        this.error.set(null);
        this.connector.a(this);
        this.assertNoErrors();
        ((MessageConnectionHandler)this.b).onServerStarted(this.connector.boundAddress());
        this.logServiceStarted();
    }

    @Override
    protected void actualStop() {
        this.connector.a();
        ((MessageConnectionHandler)this.b).onServerStopped();
        this.logServiceStopped();
    }

    @Override
    protected void actualDispose() {
        this.connector.f();
        this.closeConnections();
        this.logServiceDisposed();
    }

    private void assertNoErrors() throws Exception {
        Throwable throwable = this.error.get();
        try {
            if (throwable != null) {
                throw new Exception(throwable);
            }
        }
        catch (Exception exception) {
            throw MessageConnectionServer.a(exception);
        }
    }

    protected void closeConnections() {
        String string = TransportAddress.b();
        for (AsyncMessageConnection<M> asyncMessageConnection : this.connections()) {
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
            if (string == null) continue;
        }
    }

    private void startConnection(AsyncMessageConnection<M> asyncMessageConnection) {
        try {
            asyncMessageConnection.start(this);
        }
        catch (Connection.ConnectionException connectionException) {
            this.logErrorStartingConnection(asyncMessageConnection, connectionException);
            this.remove(asyncMessageConnection);
            ((MessageConnectionHandler)this.b).close(asyncMessageConnection);
        }
    }

    private void add(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.add(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void remove(AsyncMessageConnection<M> asyncMessageConnection) {
        this.lock.lock();
        try {
            this.connections.remove(asyncMessageConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logServiceStarted() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[8], this.name, this.connector.boundAddress()));
        }
    }

    private void logServiceStopped() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[2], this.name));
        }
    }

    private void logServicePaused() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[1], this.name));
        }
    }

    private void logServiceResumed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[6], this.name));
        }
    }

    private void logServiceDisposed() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, String.format(d[9], this.name));
        }
    }

    private void logIncomingConnection(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[11], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionEof(Connection connection) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, String.format(d[0], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectorError(Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[7], this.name), throwable);
        }
    }

    private void logConnectionIdle(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[4], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logConnectionError(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[3], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private void logConnectionClosed(Connection connection) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, String.format(d[5], this.name, connection.localAddress(), connection.remoteAddress()));
        }
    }

    private void logErrorStartingConnection(Connection connection, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, String.format(d[10], this.name, connection.localAddress(), connection.remoteAddress()), throwable);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "Nv5,\u0013v\u0017\u000efa&\u0013vY.JSu\\C\\\u0018%)bB8\\\u0018X;\u0011Nv5\u001c\u0019j\u000f\u000ew5?\u001dm\n\u000ea;\u0012Nv5\u001c\u0019j\u000f\u000ew5<\bw\t\u001b`qa!Nv5,\u0013v\u0017\u000efa&\u0013vY\u000ewg \u000e\"Y0 fo@5GK f\u0012R Nv5,\u0013v\u0017\u000efa&\u0013vY\u0002ay*F8\"Nv5sQ&YNvHa\"Nv5,\u0013v\u0017\u000efa&\u0013vY\biz<\u0019|CK^0<\\$TU%0<!6\u0012Nv5\u001c\u0019j\u000f\u000ew5=\u0019k\f\u0006`qa\u0013Nv5,\u0013v\u0017\u000efa \u000e8\u001c\u0019wz=R\u001aNv5\u001c\u0019j\u000f\u000ew5<\by\u000b\u001f`qo\u001dlY0 f\u0012R\u0013Nv5\u001c\u0019j\u000f\u000ew5+\u0015k\t\u0004vp+R";
                var4_3 = "Nv5,\u0013v\u0017\u000efa&\u0013vY.JSu\\C\\\u0018%)bB8\\\u0018X;\u0011Nv5\u001c\u0019j\u000f\u000ew5?\u001dm\n\u000ea;\u0012Nv5\u001c\u0019j\u000f\u000ew5<\bw\t\u001b`qa!Nv5,\u0013v\u0017\u000efa&\u0013vY\u000ewg \u000e\"Y0 fo@5GK f\u0012R Nv5,\u0013v\u0017\u000efa&\u0013vY\u0002ay*F8\"Nv5sQ&YNvHa\"Nv5,\u0013v\u0017\u000efa&\u0013vY\biz<\u0019|CK^0<\\$TU%0<!6\u0012Nv5\u001c\u0019j\u000f\u000ew5=\u0019k\f\u0006`qa\u0013Nv5,\u0013v\u0017\u000efa \u000e8\u001c\u0019wz=R\u001aNv5\u001c\u0019j\u000f\u000ew5<\by\u000b\u001f`qo\u001dlY0 f\u0012R\u0013Nv5\u001c\u0019j\u000f\u000ew5+\u0015k\t\u0004vp+R".length();
                var1_4 = 31;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 61;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0000YI\u000e \u0016$1JI\u0015;X0e\u000eHA1Y9+NX\u0015;Y9\u007f\u000b`D!\u0016kh\u0015\u001bD!ky$\fEX\u000e?_9\"\u000b\u001e\u0012rU8+E^\u0002&_8+\u0011\u001b:wEwy\u0006\u0005AwE\nk";
                    var4_3 = "\u0000YI\u000e \u0016$1JI\u0015;X0e\u000eHA1Y9+NX\u0015;Y9\u007f\u000b`D!\u0016kh\u0015\u001bD!ky$\fEX\u000e?_9\"\u000b\u001e\u0012rU8+E^\u0002&_8+\u0011\u001b:wEwy\u0006\u0005AwE\nk".length();
                    var1_4 = 42;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 19;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 86;
                            break;
                        }
                        case 1: {
                            v15 = 56;
                            break;
                        }
                        case 2: {
                            v15 = 40;
                            break;
                        }
                        case 3: {
                            v15 = 114;
                            break;
                        }
                        case 4: {
                            v15 = 65;
                            break;
                        }
                        case 5: {
                            v15 = 37;
                            break;
                        }
                        default: {
                            v15 = 68;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        MessageConnectionServer.d = var5;
    }
}

