/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.gateway.adapter.web;

import com.jscape.a.Page;
import com.jscape.a.PageRequest;
import com.jscape.inet.gateway.adapter.web.a;
import com.jscape.inet.gateway.adapter.web.b;
import com.jscape.inet.gateway.adapter.web.c;
import com.jscape.inet.gateway.adapter.web.e;
import com.jscape.inet.gateway.adapter.web.f;
import com.jscape.inet.gateway.adapter.web.h;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ErrorCode;
import com.jscape.inet.gateway.adapter.web.protocol.messages.ErrorSummary;
import com.jscape.inet.gateway.adapter.web.protocol.messages.NewPasswordData;
import com.jscape.inet.gateway.adapter.web.protocol.messages.SubmitState;
import com.jscape.inet.gateway.operation.A;
import com.jscape.inet.gateway.operation.B;
import com.jscape.inet.gateway.operation.BlockIpRequest;
import com.jscape.inet.gateway.operation.IpAccessConfiguration;
import com.jscape.inet.gateway.operation.V;
import com.jscape.inet.gateway.operation.aJ;
import com.jscape.inet.gateway.operation.administrator.AdministratorData;
import com.jscape.inet.gateway.operation.administrator.AdministratorSessionSummary;
import com.jscape.inet.gateway.operation.administrator.AdministratorSummary;
import com.jscape.inet.gateway.operation.agent.AgentServiceConfiguration;
import com.jscape.inet.gateway.operation.agent.GatewayAgentData;
import com.jscape.inet.gateway.operation.agent.GatewayAgentSessionSummary;
import com.jscape.inet.gateway.operation.agent.GatewayAgentSummary;
import com.jscape.inet.gateway.operation.authentication.credentials.PasswordCredentials;
import com.jscape.inet.gateway.operation.cluster.ClusterData;
import com.jscape.inet.gateway.operation.cluster.ClusterInfo;
import com.jscape.inet.gateway.operation.cluster.ClusterSummary;
import com.jscape.inet.gateway.operation.database.DatabaseConfiguration;
import com.jscape.inet.gateway.operation.database.DatabaseTestResult;
import com.jscape.inet.gateway.operation.email.EmailServiceConfiguration;
import com.jscape.inet.gateway.operation.key.CertificateGenerationData;
import com.jscape.inet.gateway.operation.key.CertificateImportData;
import com.jscape.inet.gateway.operation.key.ServerKeyGenerationData;
import com.jscape.inet.gateway.operation.key.ServerKeyImportData;
import com.jscape.inet.gateway.operation.key.ServerKeySummary;
import com.jscape.inet.gateway.operation.log.LogRecord;
import com.jscape.inet.gateway.operation.log.LogServiceConfiguration;
import com.jscape.inet.gateway.operation.monitor.MonitorServiceConfiguration;
import com.jscape.inet.gateway.operation.proxy.ProxyServiceData;
import com.jscape.inet.gateway.operation.proxy.ProxyServiceSummary;
import com.jscape.inet.gateway.operation.proxy.ProxySessionSummary;
import com.jscape.inet.gateway.operation.statistics.ServerParameters;
import com.jscape.inet.gateway.operation.statistics.ServerStatistics;
import com.jscape.inet.gateway.operation.web.WebServiceConfiguration;
import com.jscape.inet.gateway.operation.y;
import com.jscape.util.FileService;
import com.jscape.util.a1;
import com.jscape.util.aG;
import com.jscape.util.aR;
import com.jscape.util.aV;
import com.jscape.util.io.ByteArrayOutputStream;
import com.jscape.util.io.LimitedInputStream;
import com.jscape.util.net.TransportAddress;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/")
@Api(value="/api", description="Application operations")
@a1
public class ApiServer {
    private static final int MAX_LICENSE_FILE_SIZE = 2048;
    private final HttpServletRequest request;
    private final boolean debugAllowed;
    private HttpSession httpSession;
    private final V gateway;
    private final String sessionId;
    private final Logger logger;
    private static final String[] a;

    public ApiServer(@Context ServletContext servletContext, @Context HttpServletRequest httpServletRequest) {
        aV.a(httpServletRequest);
        this.request = httpServletRequest;
        this.debugAllowed = (Boolean)com.jscape.inet.gateway.adapter.web.a.DEBUG_ALLOWED.of(servletContext);
        this.httpSession = this.request.getSession();
        this.initHttpConnectionAddresses();
        this.gateway = (V)com.jscape.inet.gateway.adapter.web.a.GATEWAY.of(servletContext);
        this.sessionId = (String)c.SESSION_ID.of(this.httpSession);
        this.logger = Logger.getLogger(a[7]);
        this.logRequest();
    }

    @GET
    @Path(value="/test")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Test API", notes="Tests an API accessibility.", response=String.class)
    public String test() {
        return a[9];
    }

    @GET
    @Path(value="/csrf-token")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get CSRF token", notes="Obtains current CSRF token.", response=String.class)
    public String csrfToken() {
        return f.a(this.httpSession.getId());
    }

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Login API", notes="Performs user authentication for accessing API.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void login(@ApiParam(value="Authentication credentials", required=true) PasswordCredentials passwordCredentials) throws h {
        this.assertCsrfTokenValid();
        this.logout();
        try {
            this.httpSession = this.request.getSession(true);
            this.initHttpConnectionAddresses();
            aJ aJ2 = this.gateway.a(new e(this.httpSession, null));
            c.SESSION_ID.set(this.httpSession, aJ2.a());
            try {
                aJ2.a(passwordCredentials);
            }
            catch (Exception exception) {
                aJ2.f();
                throw exception;
            }
        }
        catch (A a10) {
            this.cleanupHttpSession();
            String[] stringArray = a;
            throw new h(ErrorCode.NOT_AUTHENTICATED, stringArray[6], "");
        }
        catch (B b10) {
            this.cleanupHttpSession();
            throw new h(ErrorCode.NOT_AUTHENTICATED, a[3], "");
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/logout")
    @ApiOperation(value="Logout API", notes="Performs user logout.")
    public void logout() {
        try {
            if (this.sessionId != null) {
                aJ aJ2 = this.session();
                aJ2.f();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.cleanupHttpSession();
            this.httpSession.invalidate();
        }
    }

    @POST
    @Path(value="/login/test")
    @ApiOperation(value="Check user logged in", notes="Checks if user is still logged in.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void assertLoggedIn() throws h {
        this.assertAuthenticated();
    }

    @POST
    @Path(value="/password-changing/start")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Start password changing", notes="Starts password changing procedure.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void startPasswordChanging(String string) throws h {
        this.assertCsrfTokenValid();
        this.logout();
        try {
            this.httpSession = this.request.getSession(true);
            this.initHttpConnectionAddresses();
            aJ aJ2 = this.gateway.a(new e(this.httpSession, null));
            c.SESSION_ID.set(this.httpSession, aJ2.a());
            try {
                aJ2.b(string);
            }
            catch (Exception exception) {
                aJ2.f();
                throw exception;
            }
        }
        catch (y y2) {
            this.cleanupHttpSession();
            throw new h(ErrorCode.INVALID_OPERATION_DATA, a[8], "");
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/password-changing/finish")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Finish password changing", notes="Finishes password changing procedure.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void finishPasswordChanging(NewPasswordData newPasswordData) throws h {
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            try {
                aJ2.a(newPasswordData.securityCode, newPasswordData.password);
            }
            finally {
                aJ2.f();
            }
        }
        catch (Throwable throwable) {
            this.cleanupHttpSession();
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server parameters", notes="Obtains server parameters.", response=ServerParameters.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerParameters serverParameters() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.d();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/parameters/addresses")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server IP's", notes="Obtains available server IP's.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public String[] serverAddresses() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.e();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/server/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server statistics", notes="Obtains current server statistics.", response=ServerStatistics.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerStatistics serverStatistics() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.f();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/license")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import license", notes="Imports an application license.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importLicense(@ApiParam(value="Form", required=true) FormDataMultiPart formDataMultiPart, @ApiParam(value="License file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aG.b((InputStream)new LimitedInputStream(inputStream, 2048L, false), (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.d();
            aJ2.a(byArray);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get proxy services", notes="Obtains available proxy services.", response=ProxyServiceSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceSummary[] proxyServices() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<ProxyServiceSummary> list = aJ2.h();
            return list.toArray(new ProxyServiceSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get proxy service", notes="Obtains a proxy service data.", response=ProxyServiceData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceData proxyServiceFor(@ApiParam(value="Service ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.c(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add proxy service", notes="Adds a new proxy service.", response=ProxyServiceSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceSummary addProxyService(@ApiParam(value="Data", required=true) ProxyServiceData proxyServiceData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(proxyServiceData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update proxy service", notes="Updates a proxy service.", response=ProxyServiceSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxyServiceSummary updateProxyService(@ApiParam(value="Data", required=true) ProxyServiceData proxyServiceData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(proxyServiceData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/start")
    @ApiOperation(value="Start proxy service", notes="Starts a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void startProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.e(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/stop")
    @ApiOperation(value="Stop proxy service", notes="Stops a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void stopProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.f(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/proxy")
    @ApiOperation(value="Delete proxy service", notes="Deletes a proxy service.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeProxyService(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.g(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/http/cache/clear")
    @ApiOperation(value="Clear HTTP service cache", notes="Clears an HTTP service cache.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void clearHttpProxyServiceCache(@QueryParam(value="id") @ApiParam(value="Service ID", required=true) String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.h(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/proxy/sessions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get proxy sessions", notes="Obtains current proxy sessions.", response=ProxySessionSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ProxySessionSummary[] proxySessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<ProxySessionSummary> list = aJ2.i();
            return list.toArray(new ProxySessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/proxy/session/close")
    @ApiOperation(value="Close agent session", notes="Closes specified agent session.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void closeProxySession(@ApiParam(value="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.i(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/clusters")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get clusters", notes="Obtains available clusters.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterInfo[] clusters() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<ClusterInfo> list = aJ2.j();
            return list.toArray(new ClusterInfo[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/clusters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get clusters", notes="Obtains available clusters.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<ClusterSummary> clustersFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/cluster")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get cluster data", notes="Obtains a cluster data.", response=ClusterData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterData clusterFor(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.j(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add cluster", notes="Adds a new cluster.", response=ClusterSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterSummary addCluster(@ApiParam(value="Data", required=true) ClusterData clusterData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(clusterData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/cluster")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update cluster", notes="Updates a cluster.", response=ClusterSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ClusterSummary updateCluster(@ApiParam(value="Data", required=true) ClusterData clusterData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(clusterData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/cluster")
    @ApiOperation(value="Delete cluster", notes="Deletes a cluster.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeCluster(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.k(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/ip-access/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get IP access service configuration", notes="Obtains an IP access service configuration.", response=IpAccessConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public IpAccessConfiguration ipAccessConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.k();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update IP access service configuration", notes="Updates an IP access service configuration.", response=IpAccessConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public IpAccessConfiguration updateIpAccessConfiguration(@ApiParam(value="Configuration", required=true) IpAccessConfiguration ipAccessConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(ipAccessConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/ip-access/block-ip")
    @Produces(value={"application/json"})
    @ApiOperation(value="Block client IP", notes="Blocks client IP that corresponds to the server connection.", response=TransportAddress.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public TransportAddress blockClientIpFor(@QueryParam(value="gatewayHost") @ApiParam(value="GatewayHost", required=true) String string, @QueryParam(value="gatewayPort") @ApiParam(value="GatewayPort", required=true) int n2, @QueryParam(value="serverHost") @ApiParam(value="ServerHost", required=true) String string2, @QueryParam(value="serverPort") @ApiParam(value="ServerPort", required=true) int n3, @QueryParam(value="period") @ApiParam(value="Period") Long l10) throws h {
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            BlockIpRequest blockIpRequest = new BlockIpRequest(new TransportAddress(string, n2), new TransportAddress(string2, n3), l10);
            return aJ2.a(blockIpRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/log/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get log service configuration", notes="Obtains a log service configuration.", response=LogServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogServiceConfiguration logServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.l();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update log service configuration", notes="Updates a log service configuration.", response=LogServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogServiceConfiguration updateLogServiceConfiguration(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/configuration/test")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Test log service configuration", notes="Tests a log service configuration.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void testLogServiceConfiguration(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.b(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/log/repository/init")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Init log service repository", notes="Initializes a log service record repository.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void initLogRepository(@ApiParam(value="Configuration", required=true) LogServiceConfiguration logServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.c(logServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get log records", notes="Obtains latest log records.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public LogRecord[] latestLogRecords(@QueryParam(value="count") @ApiParam(value="Records count", required=true) int n2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<LogRecord> list = aJ2.a(n2);
            return list.toArray(new LogRecord[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/monitor/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get monitor service configuration", notes="Obtains a monitor service configuration.", response=MonitorServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public MonitorServiceConfiguration monitorServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.m();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/monitor/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update monitor service configuration", notes="Updates a monitor service configuration.", response=MonitorServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public MonitorServiceConfiguration updateMonitorServiceConfiguration(@ApiParam(value="Configuration", required=true) MonitorServiceConfiguration monitorServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(monitorServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrators")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get administrators", notes="Obtains available administrators.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<AdministratorSummary> administratorsFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/administrator")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get administrator data", notes="Obtains an administrator data.", response=AdministratorData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorData administratorFor(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.l(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add administrator", notes="Adds a new administrator.", response=AdministratorSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorSummary addAdministrator(@ApiParam(value="Data", required=true) AdministratorData administratorData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(administratorData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/administrator")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update administrator", notes="Updates an administrator.", response=AdministratorSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorSummary updateAdministrator(@ApiParam(value="Data", required=true) AdministratorData administratorData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(administratorData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/administrator")
    @ApiOperation(value="Delete administrator", notes="Deletes an administrator.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeAdministrator(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.m(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/administrator/sessions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get administrator sessions", notes="Obtains administrator sessions.", response=AdministratorSessionSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AdministratorSessionSummary[] administratorSessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<AdministratorSessionSummary> list = aJ2.p();
            return list.toArray(new AdministratorSessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agents")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agents", notes="Obtains available agents.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<GatewayAgentSummary> agentsFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.c(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/agent")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agent data", notes="Obtains an agent data.", response=GatewayAgentData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public GatewayAgentData agentFor(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.n(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add agent", notes="Adds a new agent.", response=GatewayAgentSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public GatewayAgentSummary addAgent(@ApiParam(value="Data", required=true) GatewayAgentData gatewayAgentData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(gatewayAgentData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update agent", notes="Updates an agent.", response=GatewayAgentSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public GatewayAgentSummary updateAgent(@ApiParam(value="Data", required=true) GatewayAgentData gatewayAgentData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(gatewayAgentData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/agent")
    @ApiOperation(value="Delete agent", notes="Deletes an agent.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeAgent(@ApiParam(value="Username", required=true) @QueryParam(value="username") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.o(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/installer/update")
    @ApiOperation(value="Update agent installer", notes="Updates an agent installer.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void updateAgentInstaller(@ApiParam(value="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            aR.a(String.format(a[1], string)).newThread(() -> this.updateAgentInstaller(aJ2, string)).start();
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/installer/start")
    @ApiOperation(value="Start agent installer", notes="Starts an agent installer.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void startAgentInstaller(@ApiParam(value="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.q(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/keys/server")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server keys", notes="Obtains available server keys.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public Page<ServerKeySummary> serverKeysFor(@ApiParam(value="Page request", required=true) PageRequest pageRequest) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.d(pageRequest);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/keys/server/names")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get server key names", notes="Obtains available server key names.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public String[] serverKeyNames() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<String> list = aJ2.q();
            return list.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate server key", notes="Generates a new server key.", response=ServerKeySummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerKeySummary generateServerKey(@ApiParam(value="Key data", required=true) ServerKeyGenerationData serverKeyGenerationData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(serverKeyGenerationData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import server key", notes="Imports a server key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importServerKey(@ApiParam(value="Form", required=true) FormDataMultiPart formDataMultiPart, @ApiParam(value="Key file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        String string = c.b();
        this.assertAuthenticated();
        String string2 = string;
        try {
            aJ aJ2 = this.session();
            String[] stringArray = a;
            String string3 = formDataMultiPart.getField(stringArray[10]).getValue().trim();
            String string4 = formDataMultiPart.getField(stringArray[0]).getValue();
            String string5 = formDataMultiPart.getField(stringArray[15]).getValue().trim();
            String string6 = formDataMultiPart.getField(stringArray[11]).getValue();
            ServerKeyImportData serverKeyImportData = new ServerKeyImportData(string3, string4, string5, string6);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = aJ2.a(serverKeyImportData, inputStream);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
        try {
            if (aV.b() == null) {
                c.b("Li1j1b");
            }
        }
        catch (Throwable throwable) {
            throw ApiServer.a(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Import server certificate", notes="Imports a server certificate(s).")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void importServerCertificate(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string, @ApiParam(value="Form", required=true) FormDataMultiPart formDataMultiPart, @ApiParam(value="Certificate file", required=true) @FormDataParam(value="dataFile") InputStream inputStream) throws h {
        this.assertCsrfTokenValid(formDataMultiPart);
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            String[] stringArray = a;
            String string2 = formDataMultiPart.getField(stringArray[4]).getValue();
            String string3 = formDataMultiPart.getField(stringArray[13]).getValue().trim();
            CertificateImportData certificateImportData = new CertificateImportData(string, string2, string3);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            ServerKeySummary serverKeySummary = aJ2.a(certificateImportData, inputStream);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done(serverKeySummary));
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/key/server/certificate/generate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Generate server certificate", notes="Generates a self-signed server certificate.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public ServerKeySummary generateServerCertificate(@ApiParam(value="Name", required=true) @QueryParam(value="name") String string, @ApiParam(value="Certificate data", required=true) CertificateGenerationData certificateGenerationData) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(string, certificateGenerationData);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/{name}.key")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server private key", notes="Exports a server private key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverKeyFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2, @ApiParam(value="File password", required=true) @QueryParam(value="password") String string3) throws h {
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(string, string2, string3);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/certificate/{name}.cer")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server certificate", notes="Exports a server certificate.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverCertificateFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2) throws h {
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(string, string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/public-key/{name}.pub")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Export server public key", notes="Exports a server public key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverPublicKeyFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string, @ApiParam(value="File format", required=true) @QueryParam(value="format") String string2) throws h {
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            return aJ2.c(string, string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/key/server/csr/{name}.csr")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Generate CSR", notes="Generates a CSR.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public InputStream serverKeyCsrFor(@ApiParam(value="Key name", required=true) @PathParam(value="name") String string) throws h {
        this.assertAuthenticated();
        try {
            aJ aJ2 = this.session();
            return aJ2.r(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @DELETE
    @Path(value="/key/server")
    @ApiOperation(value="Delete server key", notes="Deletes a server key.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void removeServerKey(@ApiParam(value="Key name", required=true) @QueryParam(value="name") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.s(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/email/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get email service configuration", notes="Obtains an email service configuration.", response=EmailServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public EmailServiceConfiguration emailServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.r();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update email service configuration", notes="Updates an email service configuration.", response=EmailServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public EmailServiceConfiguration updateEmailServiceConfiguration(@ApiParam(value="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(emailServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/email/configuration/test")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Test email service configuration", notes="Tests an email service configuration.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void testEmailServiceConfiguration(@ApiParam(value="Configuration", required=true) EmailServiceConfiguration emailServiceConfiguration, @ApiParam(value="Recipient", required=true) @QueryParam(value="recipient") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.a(emailServiceConfiguration, string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/web/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get web service configuration", notes="Obtains a web service configuration.", response=WebServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public WebServiceConfiguration webServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.s();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/web/configuration/database")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get web service configuration", notes="Obtains a web service configuration from the specified database.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public WebServiceConfiguration webConfigurationFor(@ApiParam(value="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.d(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/web/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update web service configuration", notes="Updates a web service configuration.", response=WebServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public WebServiceConfiguration updateWebServiceConfiguration(@ApiParam(value="Configuration", required=true) WebServiceConfiguration webServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(webServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/service/agent/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agent service configuration", notes="Obtains an agent service configuration.", response=AgentServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentServiceConfiguration agentServiceConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.t();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/service/agent/configuration")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update agent service configuration", notes="Updates an agent service configuration.", response=AgentServiceConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public AgentServiceConfiguration updateAgentServiceConfiguration(@ApiParam(value="Configuration", required=true) AgentServiceConfiguration agentServiceConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.a(agentServiceConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/agent/sessions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get agent sessions", notes="Obtains current agent sessions.", response=GatewayAgentSessionSummary.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public GatewayAgentSessionSummary[] agentSessions() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            List<GatewayAgentSessionSummary> list = aJ2.u();
            return list.toArray(new GatewayAgentSessionSummary[0]);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/agent/session/close")
    @ApiOperation(value="Close agent session", notes="Closes specified agent session.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void closeAgentSession(@ApiParam(value="ID", required=true) @QueryParam(value="id") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.t(string);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/database/configuration")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get database configuration", notes="Obtains a database configuration.", response=DatabaseConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public DatabaseConfiguration databaseConfiguration() throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.g();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/configuration")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update database configuration", notes="Updates a database configuration.", response=DatabaseConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void updateDatabaseConfiguration(@ApiParam(value="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.a(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/configuration/test")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Test database configuration", notes="Tests a database configuration.", response=DatabaseTestResult.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public DatabaseTestResult testDatabaseConfiguration(@ApiParam(value="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            return aJ2.b(databaseConfiguration);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @POST
    @Path(value="/database/migrate")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Migrate data", notes="Migrates data to the specified configuration.")
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public void migrateData(@ApiParam(value="Configuration", required=true) DatabaseConfiguration databaseConfiguration) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.inProgress());
            aR.a(a[17]).newThread(() -> this.migrateData(aJ2, databaseConfiguration)).start();
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="List log directory", notes="Obtains available log directories.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry listLogDirectory(@ApiParam(value="Path") @QueryParam(value="path") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            String string2;
            aJ aJ2;
            aJ aJ3 = this.session();
            try {
                aJ2 = aJ3;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return aJ2.u(string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/log")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create log directory", notes="Creates a new log directory.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry createLogDirectory(@ApiParam(value="Path", required=true) @QueryParam(value="path") String string, @ApiParam(value="Name", required=true) @QueryParam(value="name") String string2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.d(string.trim(), string2);
            return aJ2.u(string.trim());
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="List cache directory", notes="Obtains available cache directories.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry listCacheDirectory(@ApiParam(value="Path") @QueryParam(value="path") String string) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            String string2;
            aJ aJ2;
            aJ aJ3 = this.session();
            try {
                aJ2 = aJ3;
                string2 = string != null ? string.trim() : null;
            }
            catch (Throwable throwable) {
                throw ApiServer.a(throwable);
            }
            return aJ2.v(string2);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @PUT
    @Path(value="/files/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create cache directory", notes="Creates a new cache directory.", response=FileService.Entry.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public FileService.Entry createCacheDirectory(@ApiParam(value="Path", required=true) @QueryParam(value="path") String string, @ApiParam(value="Name", required=true) @QueryParam(value="name") String string2) throws h {
        this.assertAuthenticated();
        this.assertCsrfTokenValid();
        try {
            aJ aJ2 = this.session();
            aJ2.e(string.trim(), string2);
            return aJ2.v(string.trim());
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    @GET
    @Path(value="/submit/state")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get import state", notes="Obtains current operation state.", response=SubmitState.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Server error", response=ErrorSummary.class)})
    public SubmitState submitState() throws h {
        SubmitState submitState;
        block10: {
            this.assertAuthenticated();
            this.assertCsrfTokenValid();
            submitState = (SubmitState)c.SUBMIT_STATE.of(this.httpSession);
            try {
                if (submitState == null) {
                    return SubmitState.none();
                }
            }
            catch (h h10) {
                throw ApiServer.a((Throwable)((Object)h10));
            }
            try {
                try {
                    if (submitState.status != SubmitState.Status.DONE && submitState.status != SubmitState.Status.ERROR) break block10;
                }
                catch (h h11) {
                    throw ApiServer.a((Throwable)((Object)h11));
                }
                c.SUBMIT_STATE.set(this.httpSession, SubmitState.none());
            }
            catch (h h12) {
                throw ApiServer.a((Throwable)((Object)h12));
            }
        }
        try {
            if (submitState.status == SubmitState.Status.ERROR) {
                throw this.wrap((Throwable)submitState.data);
            }
        }
        catch (h h13) {
            throw ApiServer.a((Throwable)((Object)h13));
        }
        return submitState;
    }

    private void updateAgentInstaller(aJ aJ2, String string) {
        try {
            aJ2.p(string);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
        }
    }

    private void migrateData(aJ aJ2, DatabaseConfiguration databaseConfiguration) {
        try {
            aJ2.c(databaseConfiguration);
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.done());
        }
        catch (Throwable throwable) {
            c.SUBMIT_STATE.set(this.httpSession, SubmitState.error(throwable));
        }
    }

    private void assertAuthenticated() {
        try {
            if (this.sessionId == null) {
                throw new h(ErrorCode.NOT_AUTHENTICATED, a[2], "");
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
    }

    private void assertCsrfTokenValid() {
        String string = this.request.getHeader(a[5]);
        this.assertCsrfTokenValid(string);
    }

    private void assertCsrfTokenValid(FormDataMultiPart formDataMultiPart) {
        String string = formDataMultiPart.getField(a[16]).getValue();
        this.assertCsrfTokenValid(string);
    }

    private void assertCsrfTokenValid(String string) {
        block4: {
            try {
                try {
                    if (string != null && f.a(this.httpSession.getId(), string)) break block4;
                }
                catch (h h10) {
                    throw ApiServer.a((Throwable)((Object)h10));
                }
                throw new h(ErrorCode.PROTOCOL_ERROR, "", "");
            }
            catch (h h11) {
                throw ApiServer.a((Throwable)((Object)h11));
            }
        }
    }

    private void initHttpConnectionAddresses() {
        try {
            c.LOCAL_ADDRESS.set(this.httpSession, new TransportAddress(this.request.getLocalAddr(), this.request.getLocalPort()));
            c.REMOTE_ADDRESS.set(this.httpSession, new TransportAddress(this.request.getRemoteHost(), this.request.getRemotePort()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanupHttpSession() {
        c.cleanup(this.httpSession);
    }

    private aJ session() throws Exception {
        try {
            return this.gateway.a(this.sessionId);
        }
        catch (y y2) {
            throw new h(ErrorCode.NOT_AUTHENTICATED, a[12], "");
        }
    }

    private h wrap(Throwable throwable) {
        try {
            if (this.debugAllowed) {
                b.ERROR.set(this.request, throwable);
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
        return h.a(throwable, this.debugAllowed);
    }

    private void logRequest() {
        try {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, a[14] + this.request);
            }
        }
        catch (h h10) {
            throw ApiServer.a((Throwable)((Object)h10));
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[18];
                var3_1 = 0;
                var2_2 = "(e\u0015dBE7={\u0016sv\"\u000fk\u001cof\u0004ck\u007f^![J7:m\u0015mwVd\u001b|\u001d`fAd\u001ad\u000bds@\u0012\u0000c\r!sQ0&i\u0017u{G%:i\u001d/\u0015\u000fy\riwJ0'o\u0018u{K*ni\u000bs}Vj\f(e\u0015dBE7={\u0016sv\f\u0016!:R@bi\u001ac\u0012d|*\u000fy\riwJ0'o\u0018u{K*ni\u000bs}V~ne\u0017wsH-*,\u001asw@! x\u0010`~Wj#-c\u0014/xW'/|\u001c/{J!:\"\u001e`fA3/uW`vE4:i\u000b/eA&\u0017\u0007b\u000f`~M nc\td`E0'c\u0017!vE0/\"$\u0004_:@Bad\u0003J-!UE0+{\u0018x2s!,,8Q[\u001ed:i\nu2k\u000f`\u0005/`\u0010`a\u000b%i\u0000QsW79c\u000be\u0012\u0000c\r!sQ0&i\u0017u{G%:i\u001d/\u000b/`\u0010`am*\be\u0015d\u0016\u0007b\u001an\u007fM*),8Q[\u00046+}\fdaP~n\u000b/`\u0010`am*\be\u0015d";
                var4_3 = "(e\u0015dBE7={\u0016sv\"\u000fk\u001cof\u0004ck\u007f^![J7:m\u0015mwVd\u001b|\u001d`fAd\u001ad\u000bds@\u0012\u0000c\r!sQ0&i\u0017u{G%:i\u001d/\u0015\u000fy\riwJ0'o\u0018u{K*ni\u000bs}Vj\f(e\u0015dBE7={\u0016sv\f\u0016!:R@bi\u001ac\u0012d|*\u000fy\riwJ0'o\u0018u{K*ni\u000bs}V~ne\u0017wsH-*,\u001asw@! x\u0010`~Wj#-c\u0014/xW'/|\u001c/{J!:\"\u001e`fA3/uW`vE4:i\u000b/eA&\u0017\u0007b\u000f`~M nc\td`E0'c\u0017!vE0/\"$\u0004_:@Bad\u0003J-!UE0+{\u0018x2s!,,8Q[\u001ed:i\nu2k\u000f`\u0005/`\u0010`a\u000b%i\u0000QsW79c\u000be\u0012\u0000c\r!sQ0&i\u0017u{G%:i\u001d/\u000b/`\u0010`am*\be\u0015d\u0016\u0007b\u001an\u007fM*),8Q[\u00046+}\fdaP~n\u000b/`\u0010`am*\be\u0015d".length();
                var1_4 = 12;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 98;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "nYB*8\u001a\u0011b\u001bj\u001c\u0004\u0015r\u0015u\u0018J\u0011UQ\u0006`\r\u00033R\u0016 i\u000b\u000f=X";
                    var4_3 = "nYB*8\u001a\u0011b\u001bj\u001c\u0004\u0015r\u0015u\u0018J\u0011UQ\u0006`\r\u00033R\u0016 i\u000b\u000f=X".length();
                    var1_4 = 12;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 26;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 44;
                            break;
                        }
                        case 1: {
                            v15 = 110;
                            break;
                        }
                        case 2: {
                            v15 = 27;
                            break;
                        }
                        case 3: {
                            v15 = 99;
                            break;
                        }
                        case 4: {
                            v15 = 112;
                            break;
                        }
                        case 5: {
                            v15 = 70;
                            break;
                        }
                        default: {
                            v15 = 38;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        ApiServer.a = var5;
    }
}

