/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public abstract class BCSNIServerName {
    private final int nameType;
    private final byte[] encoded;

    protected BCSNIServerName(int n, byte[] byArray) {
        if (!TlsUtils.isValidUint8(n)) {
            throw new IllegalArgumentException("'nameType' should be between 0 and 255");
        }
        if (byArray == null) {
            throw new NullPointerException("'encoded' cannot be null");
        }
        this.nameType = n;
        this.encoded = Arrays.clone((byte[])byArray);
    }

    public final int getType() {
        return this.nameType;
    }

    public final byte[] getEncoded() {
        return Arrays.clone((byte[])this.encoded);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BCSNIServerName)) {
            return false;
        }
        BCSNIServerName bCSNIServerName = (BCSNIServerName)object;
        return this.nameType == bCSNIServerName.nameType && Arrays.areEqual((byte[])this.encoded, (byte[])bCSNIServerName.encoded);
    }

    public int hashCode() {
        return this.nameType ^ Arrays.hashCode((byte[])this.encoded);
    }
}

