/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.WebController=Class.extend({init:function(page,changeWebConfigurationController){this.page=page;this.changeWebConfigurationController=changeWebConfigurationController;},start:function(){jscape.OPERATION_SERVICE.webServiceConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeWebConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setHttp(this.configuration.httpAddress.host,this.configuration.httpAddress.port,this.configuration.httpEnabled);this.page.setHttps(this.configuration.httpsAddress.host,this.configuration.httpsAddress.port,this.configuration.httpsKeyAlias,this.configuration.httpsEnabled);this.page.setTimeout(this.configuration.sessionTimeoutMillis);}});jscape.WebPage=Class.extend({TIMEOUT_FACTOR:60*1000,init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.httpField=$("#httpField");this.httpsField=$("#httpsField");this.sessionTimeoutField=$("#sessionTimeoutField");this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setHttp:function(host,port,enabled){var text=enabled?"{host}:{port}".supplant({host:host,port:port}):jscape.Resources["disabled"];this.httpField.text(text);},setHttps:function(host,port,key,enabled){var text=enabled?jscape.Resources["webPage.httpsField.text"].supplant({host:host,port:port,key:key}):jscape.Resources["disabled"];this.httpsField.text(text);},setTimeout:function(value){var text=jscape.Resources["webPage.sessionTimeoutField.text"].supplant({timeout:value/this.TIMEOUT_FACTOR});this.sessionTimeoutField.text(text);},_onChange:function(){this.listener.onChange();}});jscape.ChangeWebConfigurationController=Class.extend({init:function(dialog,protocol,uri){this.dialog=dialog;this.protocol=protocol;this.uri=uri;this.parametersController=new jscape.WebParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onSubmit:function(){var configuration={httpAddress:{host:this.dialog.getHttpHost(),port:this.dialog.getHttpPort()},httpEnabled:this.dialog.isHttpEnabled(),httpsAddress:{host:this.dialog.getHttpsHost(),port:this.dialog.getHttpsPort()},httpsEnabled:this.dialog.isHttpsEnabled(),httpsKeyAlias:this.dialog.getKey(),sessionTimeoutMillis:this.dialog.getTimeout(),version:this.configuration.version};jscape.OPERATION_SERVICE.updateWebServiceConfiguration(configuration,$.proxy(function(){this._configurationUpdated(configuration);},this),$.proxy(function(error){this._configurationUpdated(configuration,error);},this),$.proxy(function(error){return!this._configurationUpdatedResponse(error);},this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_parametersLoaded:function(hosts,keys){this.dialog.setHosts(hosts);this.dialog.setKeys(keys);jscape.OPERATION_SERVICE.webServiceConfiguration($.proxy(this._configurationLoaded,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setHttpEnabled(this.configuration.httpEnabled);this.dialog.setHttpHost(this.configuration.httpAddress.host);this.dialog.setHttpPort(this.configuration.httpAddress.port);this.dialog.setHttpsEnabled(this.configuration.httpsEnabled);this.dialog.setHttpsHost(this.configuration.httpsAddress.host);this.dialog.setHttpsPort(this.configuration.httpsAddress.port);this.dialog.setKey(this.configuration.httpsKeyAlias);this.dialog.setTimeout(this.configuration.sessionTimeoutMillis);this.dialog.show(this);},_configurationUpdated:function(configuration,error){this.dialog.hide();if(!error||!this._configurationUpdatedResponse(error)){this._showConfigurationUpdated($.proxy(function(){this.callback(configuration);},this));}else{this._showConfigurationUpdated($.proxy(function(){this._reloadPage(configuration);},this));}},_showConfigurationUpdated:function(callback){$.messager.alert(jscape.Resources["webServiceConfigurationAppliedDialog.title"],jscape.Resources["webServiceConfigurationAppliedDialog.message"],"info",callback);},_reloadPage:function(configuration){if((this.protocol==="https"||configuration.httpsEnabled)&&!configuration.httpEnabled){var httpsHost=this._adjustHost(configuration.httpsAddress.host);var httpsPort=configuration.httpsAddress.port==="443"?"":":"+configuration.httpsAddress.port;window.location="https://{host}{port}{uri}".supplant({host:httpsHost,port:httpsPort,uri:this.uri});}else{var httpHost=this._adjustHost(configuration.httpAddress.host);var httpPort=configuration.httpAddress.port==="80"?"":":"+configuration.httpAddress.port;window.location="http://{host}{port}{uri}".supplant({host:httpHost,port:httpPort,uri:this.uri});}},_configurationUpdatedResponse:function(error){return error.httpStatus===0||error.httpStatus===404||(error.serverResponse&&error.serverResponse.code==="NOT_AUTHENTICATED");},_adjustHost:function(host){return host!==this.dialog.DEFAULT_HOST?host:window.location.hostname;}});jscape.ChangeWebConfigurationDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:60*1000,init:function(){this.dialog=$("#webConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["webConfigurationDialog.title"],width:jscape.Resources.intVal("webConfigurationDialog.width"),height:jscape.Resources.intVal("webConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.httpEnabledBox=$("#httpEnabledBox");this.httpEnabledBox.click($.proxy(this._httpEnableBoxClicked,this));this.httpHostBox=$("#httpHostBox");this.httpHostBox.combobox({editable:false,valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["webConfigurationDialog.error.emptyHttpHost.message"],validType:requiredFieldRule("requiredHttpHost",jscape.Resources["webConfigurationDialog.error.emptyHttpHost.message"]),disabled:true});this.httpPortField=$("#httpPortField");this.httpPortField.numberspinner({min:1,max:65535,value:30880,increment:1,required:true,missingMessage:jscape.Resources["webConfigurationDialog.error.emptyHttpPort.message"],disabled:true});this.httpsEnabledBox=$("#httpsEnabledBox");this.httpsEnabledBox.click($.proxy(this._httpsEnableBoxClicked,this));this.httpsHostBox=$("#httpsHostBox");this.httpsHostBox.combobox({editable:false,valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["webConfigurationDialog.error.emptyHttpsHost.message"],validType:requiredFieldRule("requiredHttpsHost",jscape.Resources["webConfigurationDialog.error.emptyHttpsHost.message"]),disabled:true});this.httpsPortField=$("#httpsPortField");this.httpsPortField.numberspinner({min:1,max:65535,value:30843,increment:1,required:true,missingMessage:jscape.Resources["webConfigurationDialog.error.emptyHttpsPort.message"],disabled:true});this.keyBox=$("#keyBox");this.keyBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,disabled:true});this.timeoutField=$("#timeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:30,increment:1,required:true,missingMessage:jscape.Resources["webConfigurationDialog.error.emptyTimeout.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.httpHostBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setHosts:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.httpHostBox.combobox("loadData",hosts);this.httpsHostBox.combobox("loadData",hosts);},setKeys:function(values){this.keys=$.map(values,function(value){return{text:value,value:value};});this.keyBox.combobox("loadData",this.keys);if(this.keys.length===0){this.httpsEnabledBox.prop("disabled",true);}},isHttpEnabled:function(){return this.httpEnabledBox.prop("checked");},setHttpEnabled:function(value){this.httpEnabledBox.prop("checked",value);this._httpEnableBoxClicked();},getHttpHost:function(){return this.httpHostBox.combobox("getValue").trim();},setHttpHost:function(value){value=value&&value.length>0?value:this.DEFAULT_HOST;this.httpHostBox.combobox("setValue",value).combobox("select",value);},getHttpPort:function(){return parseInt(this.httpPortField.numberspinner("getValue"),10);},setHttpPort:function(value){this.httpPortField.numberspinner("setValue",value);},isHttpsEnabled:function(){return this.httpsEnabledBox.prop("checked");},setHttpsEnabled:function(value){if(!this.httpsEnabledBox.prop("disabled")){this.httpsEnabledBox.prop("checked",value);this._httpsEnableBoxClicked();}},getHttpsHost:function(){return this.httpsHostBox.combobox("getValue").trim();},setHttpsHost:function(value){value=value&&value.length>0?value:this.DEFAULT_HOST;this.httpsHostBox.combobox("setValue",value).combobox("select",value);},getHttpsPort:function(){return parseInt(this.httpsPortField.numberspinner("getValue"),10);},setHttpsPort:function(value){this.httpsPortField.numberspinner("setValue",value);},getKey:function(){return this.keyBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.keyBox.combobox("setValue",value).combobox("select",value);}else if(this.keys.length>0){this.keyBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_httpEnableBoxClicked:function(){var enable=this.httpEnabledBox.prop("checked")?"enable":"disable";this.httpHostBox.combobox(enable);this.httpPortField.numberspinner(enable);},_httpsEnableBoxClicked:function(){var enable=this.httpsEnabledBox.prop("checked")?"enable":"disable";this.httpsHostBox.combobox(enable);this.httpsPortField.numberspinner(enable);this.keyBox.combobox(enable);},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.WebParametersController=Class.extend({start:function(callback){this.callback=callback;this._loadAddresses();},_loadAddresses:function(){jscape.OPERATION_SERVICE.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.addresses=addresses;this._loadKeys();},_loadKeys:function(){jscape.OPERATION_SERVICE.serverKeyAliases($.proxy(this._keysLoaded,this));},_keysLoaded:function(keys){this.callback(this.addresses,keys);}});