/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.StatusController=Class.extend({init:function(page,autoUpdateInterval){this.page=page;this.autoUpdateInterval=autoUpdateInterval;this.parametersController=new jscape.StatusParametersController();},start:function(){this.parametersController.start($.proxy(function(parameters,statistics){this._parametersUpdated(parameters,statistics);this.page.show(this);this._scheduleNextStatisticsUpdate();},this));},_parametersUpdated:function(parameters,statistics){this.page.updateParameters(parameters);this.page.updateStatistics(statistics);},_updateStatistics:function(){this.parametersController.start($.proxy(this._statisticsUpdated,this));},_statisticsUpdated:function(parameters,statistics){this.page.updateParameters(parameters);this.page.updateStatistics(statistics);this._scheduleNextStatisticsUpdate();},_scheduleNextStatisticsUpdate:function(){setTimeout($.proxy(this._updateStatistics,this),this.autoUpdateInterval);}});jscape.StatusPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});var connectionsChartDiv=$("#connectionsChart");this.connectionsChart=$.plot("#connectionsChart",[],{series:{lines:{show:true,lineWidth:2},points:{show:false},shadowSize:0},grid:{borderWidth:1,borderColor:"#95B8E7",hoverable:true,clickable:true,labelMargin:10,margin:{left:20}},xaxis:{show:true,mode:"time",timezone:"browser",timeformat:"%m/%d %H:%M",min:this._chartLowerBound(),max:this._chartUpperBound(),tickSize:[6,"hour"],minTickSize:[6,"hour"]},yaxis:{show:true,min:0,tickDecimals:0},selection:{mode:"x"}});var connectionsYAxisLabel=$("<div class='chartAxisLabel chartYAxisLabel'></div>").text(jscape.Resources["statusPage.connectionsChart.legend.y"]).appendTo(connectionsChartDiv);connectionsYAxisLabel.css("margin-top",connectionsYAxisLabel.width()/2-20);$("<div class='chartZoomOutButton' style='right:20px;top:20px'></div>").text(jscape.Resources["statusPage.connectionsChart.zoomOutButton.text"]).appendTo(connectionsChartDiv).click($.proxy(this._zoomConnectionsChartOut,this));connectionsChartDiv.bind("plotselected",$.proxy(this._zoomConnectionsChartIn,this));connectionsChartDiv.bind("plothover",function(event,pos,item){var tooltip=$("#chartTooltip");if(item){var text=jscape.Resources["statusPage.connectionsChart.tooltip.text"].supplant({date:DateFormat.format(new Date(item.datapoint[0])),value:item.datapoint[1]});tooltip.html(text).css({top:item.pageY+5,left:item.pageX+5}).fadeIn(200);}else{tooltip.hide();}});var memoryChartDiv=$("#memoryChart");this.memoryChart=$.plot("#memoryChart",[],{series:{lines:{show:true,lineWidth:2},points:{show:false},shadowSize:0},grid:{borderWidth:1,borderColor:"#95B8E7",hoverable:true,clickable:true,labelMargin:10,margin:{left:20}},xaxis:{show:true,mode:"time",timezone:"browser",timeformat:"%m/%d %H:%M",min:this._chartLowerBound(),max:this._chartUpperBound(),tickSize:[6,"hour"],minTickSize:[6,"hour"]},yaxis:{show:true,min:0,tickDecimals:0},legend:{show:true,noColumns:3,position:"ne"},selection:{mode:"x"}});var memoryYAxisLabel=$("<div class='chartAxisLabel chartYAxisLabel'></div>").text(jscape.Resources["statusPage.memoryChart.legend.y"]).appendTo(memoryChartDiv);memoryYAxisLabel.css("margin-top",memoryYAxisLabel.width()/2-20);$("<div class='chartZoomOutButton' style='right:20px;top:40px'></div>").text(jscape.Resources["statusPage.memoryChart.zoomOutButton.text"]).appendTo(memoryChartDiv).click($.proxy(this._zoomMemoryChartOut,this));memoryChartDiv.bind("plotselected",$.proxy(this._zoomMemoryChartIn,this));memoryChartDiv.bind("plothover",function(event,pos,item){var tooltip=$("#chartTooltip");if(item){var text=jscape.Resources["statusPage.memoryChart.tooltip.text"].supplant({date:DateFormat.format(new Date(item.datapoint[0])),value:item.datapoint[1].toFixed(2)});tooltip.html(text).css({top:item.pageY+5,left:item.pageX+5}).fadeIn(200);}else{tooltip.hide();}});var threadsChartDiv=$("#threadsChart");this.threadsChart=$.plot("#threadsChart",[],{series:{lines:{show:true},points:{show:false},shadowSize:0},grid:{borderWidth:1,borderColor:"#95B8E7",hoverable:true,clickable:true,labelMargin:10,margin:{left:20}},xaxis:{show:true,mode:"time",timezone:"browser",timeformat:"%m/%d %H:%M",min:this._chartLowerBound(),max:this._chartUpperBound(),tickSize:[6,"hour"],minTickSize:[6,"hour"]},yaxis:{show:true,min:0,tickDecimals:0},selection:{mode:"x"}});var threadsYAxisLabel=$("<div class='chartAxisLabel chartYAxisLabel'></div>").text(jscape.Resources["statusPage.threadsChart.legend.y"]).appendTo(threadsChartDiv);threadsYAxisLabel.css("margin-top",threadsYAxisLabel.width()/2-20);$("<div class='chartZoomOutButton' style='right:20px;top:20px'></div>").text(jscape.Resources["statusPage.threadsChart.zoomOutButton.text"]).appendTo(threadsChartDiv).click($.proxy(this._zoomThreadsChartOut,this));threadsChartDiv.bind("plotselected",$.proxy(this._zoomThreadsChartIn,this));threadsChartDiv.bind("plothover",function(event,pos,item){var tooltip=$("#chartTooltip");if(item){var text=jscape.Resources["statusPage.threadsChart.tooltip.text"].supplant({date:DateFormat.format(new Date(item.datapoint[0])),value:item.datapoint[1]});tooltip.html(text).css({top:item.pageY+5,left:item.pageX+5}).fadeIn(200);}else{tooltip.hide();}});this.versionField=$("#versionField");this.licenseTypeField=$("#licenseTypeField");this.licenseOwnerField=$("#licenseOwnerField");this.licenseHostField=$("#licenseHostField");this.licenseMacField=$("#licenseMacField");this.licenseExpirationField=$("#licenseExpirationField");this.maxConnectionsField=$("#maxConnectionsField");this.timezoneField=$("#timezoneField");this.uptimeField=$("#uptimeField");this.memoryField=$("#memoryField");this.threadsField=$("#threadsField");this.totalUserConnectionsField=$("#totalUserConnectionsField");this.currentUserConnectionsField=$("#currentUserConnectionsField");this.currentAgentsField=$("#currentAgentsField");this.currentAdministratorConnectionsField=$("#currentAdministratorConnectionsField");this.interfacesTable=$("#interfacesTable");this.interfacesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["statusPage.interfacesTable.column.0"],width:20,halign:"left",align:"left",sortable:true},{field:"displayName",title:jscape.Resources["statusPage.interfacesTable.column.1"],width:40,halign:"left",align:"left",sortable:true},{field:"addresses",title:jscape.Resources["statusPage.interfacesTable.column.2"],width:40,halign:"left",align:"left",sortable:true,formatter:function(value,row){return row.addresses.join(", ");}}]]});this.parameters=null;},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},updateParameters:function(parameters){this.parameters=parameters;this.interfacesTable.datagrid("loadData",parameters.interfaces);},updateStatistics:function(statistics){this._updateConnectionsChart(statistics.connectionsMeasurements);this._updateMemoryChart(statistics.maxMemory,statistics.memoryMeasurements);this._updateThreadsChart(statistics.threadsMeasurements);this._updateStatistics(statistics);},_chartLowerBound:function(){var date=new Date();date.setDate(date.getDate()-4);date.setHours(0);date.setMinutes(0);date.setSeconds(0);date.setMilliseconds(0);return date.getTime();},_chartUpperBound:function(){var date=new Date();date.setDate(date.getDate()+1);date.setHours(0);date.setMinutes(0);date.setSeconds(0);date.setMilliseconds(0);return date.getTime();},_updateConnectionsChart:function(measurements){var data={data:[],color:"#95B8E7",clickable:true,hoverable:true};var i;for(i=0;i<measurements.length;++i){data.data.push([measurements[i].date,measurements[i].value]);}
this.connectionsChart.setData([data]);this.connectionsChart.setupGrid();this.connectionsChart.draw();},_updateMemoryChart:function(maxValue,measurements){var maxData={data:[],label:jscape.Resources["statusPage.memoryChart.legend.max"],color:"red",clickable:true,hoverable:true};var heapData={data:[],label:jscape.Resources["statusPage.memoryChart.legend.heap"],color:"#EDC240",clickable:true,hoverable:true};var allocatedData={data:[],color:"#95B8E7",label:jscape.Resources["statusPage.memoryChart.legend.allocated"],clickable:true,hoverable:true};var i;for(i=0;i<measurements.length;++i){maxData.data.push([measurements[i].date,maxValue/1024/1024]);heapData.data.push([measurements[i].date,measurements[i].heapValue/1024/1024]);allocatedData.data.push([measurements[i].date,measurements[i].allocatedValue/1024/1024]);}
this.memoryChart.setData([maxData,heapData,allocatedData]);this.memoryChart.setupGrid();this.memoryChart.draw();},_updateThreadsChart:function(measurements){var data={data:[],color:"#95B8E7",clickable:true,hoverable:true};var i;for(i=0;i<measurements.length;++i){data.data.push([measurements[i].date,measurements[i].value]);}
this.threadsChart.setData([data]);this.threadsChart.setupGrid();this.threadsChart.draw();},_updateStatistics:function(statistics){this.versionField.text(this.parameters.version);this.timezoneField.text(this.parameters.timeZone);this.licenseTypeField.text(this.parameters.licenseType);this.licenseOwnerField.text(this.parameters.licenseOwner);this.licenseHostField.text(this.parameters.licenseHost||jscape.Resources["statusPage.licenseHost.nonbinding"]);this.licenseMacField.text(this.parameters.licenseMac||jscape.Resources["statusPage.licenseMac.nonbinding"]);this.licenseExpirationField.text(this.parameters.licenseExpirationDate?this._formatDate(this.parameters.licenseExpirationDate):jscape.Resources["statusPage.licenseExpiration.nonexpiring"]);this.maxConnectionsField.text(this.parameters.maxConnections<2147483647?this.parameters.maxConnections:jscape.Resources["statusPage.maxConnections.unlimited"]);this.uptimeField.text(this._formatUptime(statistics.uptime));this.memoryField.text(this._formatMemory(statistics.totalMemory-statistics.freeMemory,statistics.maxMemory));this.threadsField.text(statistics.threads);this.totalUserConnectionsField.text(statistics.totalUserConnections);this.currentUserConnectionsField.text(statistics.currentUserConnections);this.currentAgentsField.text(statistics.currentAgentConnections);this.currentAdministratorConnectionsField.text(statistics.currentAdministratorConnections);},_zoomConnectionsChartIn:function(event,ranges){var options=this.connectionsChart.getXAxes()[0].options;options.min=ranges.xaxis.from;options.max=ranges.xaxis.to;this.connectionsChart.setupGrid();this.connectionsChart.draw();this.connectionsChart.clearSelection();},_zoomConnectionsChartOut:function(event){event.preventDefault();var options=this.connectionsChart.getXAxes()[0].options;options.min=this._chartLowerBound();options.max=this._chartUpperBound();this.connectionsChart.setupGrid();this.connectionsChart.draw();},_zoomMemoryChartIn:function(event,ranges){var options=this.memoryChart.getXAxes()[0].options;options.min=ranges.xaxis.from;options.max=ranges.xaxis.to;this.memoryChart.setupGrid();this.memoryChart.draw();this.memoryChart.clearSelection();},_zoomMemoryChartOut:function(event){event.preventDefault();var options=this.memoryChart.getXAxes()[0].options;options.min=this._chartLowerBound();options.max=this._chartUpperBound();this.memoryChart.setupGrid();this.memoryChart.draw();},_zoomThreadsChartIn:function(event,ranges){var options=this.threadsChart.getXAxes()[0].options;options.min=ranges.xaxis.from;options.max=ranges.xaxis.to;this.threadsChart.setupGrid();this.threadsChart.draw();this.threadsChart.clearSelection();},_zoomThreadsChartOut:function(event){event.preventDefault();var options=this.threadsChart.getXAxes()[0].options;options.min=this._chartLowerBound();options.max=this._chartUpperBound();this.threadsChart.setupGrid();this.threadsChart.draw();},_formatUptime:function(time){var interval=new TimeInterval(time);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_formatDate:function(date){return date?DateFormat.formatShort(date):"";},_formatMemory:function(usedMemory,maxMemory){return"{usedMemory} of {maxMemory}".supplant({usedMemory:MemorySizeFormat.format(usedMemory),maxMemory:MemorySizeFormat.format(maxMemory)});}});jscape.StatusParametersController=Class.extend({start:function(callback){this.callback=callback;this._loadParameters();},_loadParameters:function(){jscape.OPERATION_SERVICE.serverParameters($.proxy(this._parametersLoaded,this));},_parametersLoaded:function(parameters){this.parameters=parameters;this._loadStatistics();},_loadStatistics:function(){jscape.OPERATION_SERVICE.serverStatistics($.proxy(this._statisticsLoaded,this));},_statisticsLoaded:function(statistics){this.callback(this.parameters,statistics);}});