/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.ServicesController=Class.extend({init:function(page,controllers){this.page=page;this.controllers=controllers;},start:function(){this.page.show(this);$.each(this.controllers,function(index,controller){controller.start();});},onTabVisible:function(index){this.controllers[index].onVisible();}});jscape.ServicesPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true,onSelect:$.proxy(function(title,index){if(this.listener){this.listener.onTabVisible(index);}},this)});},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},selectTab:function(index){this.infoPanel.tabs("select",index);}});jscape.ServicesPanelController=Class.extend({init:function(panel,addServiceController,stopServiceController,deleteServiceController,autoUpdateInterval){this.panel=panel;this.addServiceController=addServiceController;this.stopServiceController=stopServiceController;this.deleteServiceController=deleteServiceController;this.autoUpdateInterval=autoUpdateInterval;},start:function(){this.panel.show(this);this._updateServices();},onVisible:function(){this.panel.resize();},onAddService:function(){this.addServiceController.start($.proxy(function(summary,startRequired){if(startRequired){this.onStartService(summary);}else{this._updateServices();}},this));},onStartService:function(service){jscape.OPERATION_SERVICE.startProxyService(service.id,$.proxy(function(){this._serviceStarted(service);},this),$.proxy(this._updateServices,this));},onStopServices:function(services){this.stopServiceController.start(services,$.proxy(this._updateServices,this),$.proxy(this._updateServices,this));},onDeleteServices:function(services){this.deleteServiceController.start(services,$.proxy(this._updateServices,this));},_updateServices:function(){jscape.OPERATION_SERVICE.proxyServices($.proxy(this._servicesUpdated,this));},_servicesUpdated:function(services){this.services=services;this.panel.setServices(this.services);this._scheduleNextServicesUpdate();},_scheduleNextServicesUpdate:function(){setTimeout($.proxy(this._updateServices,this),this.autoUpdateInterval);},_serviceStarted:function(service){$.messager.alert(jscape.Resources["serviceStartedDialog.title"],jscape.Resources["serviceStartedDialog.message"].supplant(service.localAddress),"info",$.proxy(this._updateServices,this));}});jscape.ServicesPanel=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.servicesTable=$("#servicesTable");this.servicesTable.datagrid({fitColumns:true,remoteSort:true,sortName:"protocol",sortOrder:"asc",singleSelect:true,columns:[[{field:"clientProtocol",title:jscape.Resources["servicesPage.servicesTable.column.0"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._clientProtocolOf,this)},{field:"serverProtocol",title:jscape.Resources["servicesPage.servicesTable.column.1"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._serverProtocolOf,this)},{field:"localAddress",title:jscape.Resources["servicesPage.servicesTable.column.2"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.localAddress);}},{field:"remoteAddress",title:jscape.Resources["servicesPage.servicesTable.column.3"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return row.remoteAddress?"{host}:{port}".supplant(row.remoteAddress):"";}},{field:"clusterName",title:jscape.Resources["servicesPage.servicesTable.column.4"],width:15,halign:"left",align:"left",sortable:true},{field:"agentUsed",title:jscape.Resources["servicesPage.servicesTable.column.5"],width:12,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._delegationStatusOf,this)},{field:"fipsModeEnabled",title:jscape.Resources["servicesPage.servicesTable.column.6"],width:10,halign:"center",align:"center",sortable:true,formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});}},{field:"state",title:jscape.Resources["servicesPage.servicesTable.column.7"],width:15,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._stateOf,this)},{field:"uptime",title:jscape.Resources["servicesPage.servicesTable.column.8"],width:20,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._uptimeOf,this)},{field:"currentConnections",title:jscape.Resources["servicesPage.servicesTable.column.9"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return row.currentConnectionCount;}},{field:"totalConnections",title:jscape.Resources["servicesPage.servicesTable.column.10"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return row.totalConnectionCount;}}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),onSortColumn:$.proxy(this._sort,this)});this.sorter={"clientProtocol.asc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},this),"clientProtocol.desc":$.proxy(function(a,b){return window.sort(this._clientProtocolOf(null,b),this._clientProtocolOf(null,a));},this),"serverProtocol.asc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,a),this._serverProtocolOf(null,b));},this),"serverProtocol.desc":$.proxy(function(a,b){return window.sort(this._serverProtocolOf(null,b),this._serverProtocolOf(null,a));},this),"localAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.localAddress,b.localAddress));},this),"localAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.localAddress,a.localAddress));},this),"remoteAddress.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(a.remoteAddress,b.remoteAddress));},this),"remoteAddress.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortAddress(b.remoteAddress,a.remoteAddress));},this),"clusterName.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.clusterName,b.clusterName));},this),"clusterName.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.clusterName,a.clusterName));},this),"agentUsed.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(a.agentUsed,b.agentUsed));},this),"agentUsed.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(b.agentUsed,a.agentUsed));},this),"fipsModeEnabled.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(a.fipsModeEnabled,b.fipsModeEnabled));},this),"fipsModeEnabled.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sortBoolean(b.fipsModeEnabled,a.fipsModeEnabled));},this),"state.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(this._stateOf(null,a),this._stateOf(null,b)));},this),"state.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(this._stateOf(null,b),this._stateOf(null,a)));},this),"uptime.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.uptimeMillis,b.uptimeMillis));},this),"uptime.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.uptimeMillis,a.uptimeMillis));},this),"currentConnections.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.currentConnections,b.currentConnections));},this),"currentConnections.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.currentConnections,a.currentConnections));},this),"totalConnections.asc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(a.totalConnections,b.totalConnections));},this),"totalConnections.desc":$.proxy(function(a,b){return this._sortColumn(a,b,window.sort(b.totalConnections,a.totalConnections));},this)};this.addServiceButton=$("#addServiceButton");this.addServiceButton.linkbutton({width:jscape.Resources.buttonSize()});this.addServiceButton.click($.proxy(function(){this.listener.onAddService();},this));this.startServiceButton=$("#startServiceButton");this.startServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.startServiceButton.click($.proxy(function(){if(!this.startServiceButton.linkbutton("options").disabled){this.listener.onStartService(this.rowValue);}},this));this.stopServiceButton=$("#stopServiceButton");this.stopServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.stopServiceButton.click($.proxy(this._stop,this));this.deleteServiceButton=$("#deleteServiceButton");this.deleteServiceButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteServiceButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.servicesTable.datagrid("resize");},resize:function(){this.servicesTable.datagrid("resize");},setServices:function(value){this.services=value;this._sort(this.sortedColumn||"protocol",this.sortOrder||"asc");},_rowSelected:function(row,rowValue){this.row=row;this.rowValue=rowValue;if(this.rowValue){this.startServiceButton.linkbutton(rowValue.uptimeMillis?"disable":"enable");this.stopServiceButton.linkbutton(rowValue.uptimeMillis?"enable":"disable");this.deleteServiceButton.linkbutton("enable");}},_rowUnselected:function(){if(this.servicesTable.datagrid("getSelections").length===0){this._resetButtons();}},_sort:function(name,order){this.sortedColumn=name;this.sortOrder=order;this.services.sort(this.sorter[name+"."+order]);this.servicesTable.datagrid("loadData",this.services);this._resetButtons();this._restoreSelection();},_sortColumn:function(a,b,value){return value?value:window.sort(this._clientProtocolOf(null,a),this._clientProtocolOf(null,b));},_restoreSelection:function(){if(!this.rowValue){return;}
var i;var length=this.services.length;var value;for(i=0;i<length;++i){value=this.services[i];if(value.id===this.rowValue.id){this.servicesTable.datagrid("selectRow",i);return;}}},_stop:function(){if(this.stopServiceButton.linkbutton("options").disabled){return;}
var values=this.servicesTable.datagrid("getSelections");if(values.length>0){this.listener.onStopServices(values);}},_delete:function(){if(this.deleteServiceButton.linkbutton("options").disabled){return;}
var values=this.servicesTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteServices(values);}},_clientProtocolOf:function(value,service){return jscape.Resources["protocol."+service.clientProtocolAlias];},_serverProtocolOf:function(value,service){return jscape.Resources["protocol."+service.serverProtocolAlias];},_delegationStatusOf:function(value,service){return service.agentUsed?jscape.Resources["service.delegated"]:jscape.Resources["service.non-delegated"]},_stateOf:function(value,service){return service.uptimeMillis?jscape.Resources["service.started"]:service.errorMessage?jscape.Resources["service.stopped"]+": "+service.errorMessage:jscape.Resources["service.stopped"];},_uptimeOf:function(value,service){if(!service.uptimeMillis){return"";}
var interval=new TimeInterval(service.uptimeMillis);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_resetButtons:function(){this.startServiceButton.linkbutton("disable");this.stopServiceButton.linkbutton("disable");this.deleteServiceButton.linkbutton("disable");}});jscape.AddServiceController=Class.extend({DEFAULT_PORTS:{FTP:21,FTPS:21,FTPS_IMPLICIT:990,SFTP:22,HTTP:80,HTTPS:443,RAW:22,RAW_SSL:22,SSH_SFTP:22,SMTP:25,POP3:110,IMAP4:143,MYSQL:3306,UDP:3000},PROTOCOL_MAP:{SSH_SFTP:"RAW",SMTP:"RAW",POP3:"RAW",IMAP4:"RAW",MYSQL:"RAW"},init:function(dialog,controllerMap){this.dialog=dialog;this.controllerMap=controllerMap;this.parametersController=new jscape.ServiceParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onSubmit:function(){this.dialog.hide();var clientProtocol=this._resolveProtocol(this.dialog.getClientProtocol());var defaultClientPort=this._defaultPortOf(this.dialog.getClientProtocol());var serverProtocol=this._resolveProtocol(this.dialog.getServerProtocol());var defaultServerPort=this._defaultPortOf(this.dialog.getServerProtocol());var clusters=this._clustersFor(serverProtocol);var controllerKey="{clientProtocol}-{serverProtocol}".supplant({clientProtocol:clientProtocol,serverProtocol:serverProtocol});var controller=this.controllerMap[controllerKey];controller.start(clientProtocol,this.dialog.getClientProtocol(),defaultClientPort,serverProtocol,this.dialog.getServerProtocol(),defaultServerPort,this.addresses,this.keys,clusters,$.proxy(this._serviceAdded,this));},onCancel:function(){this.dialog.hide();},_parametersLoaded:function(addresses,keys,clusters){this.addresses=addresses;this.keys=keys;this.clusters=clusters;this.dialog.reset();this.dialog.show(this);},_clustersFor:function(protocol){var ret=[];var i;var cluster;for(i=0;i<this.clusters.length;i++){cluster=this.clusters[i];if(protocol===cluster.protocol){ret.push(cluster.name);}}
ret.sort();return ret;},_serviceAdded:function(summary,startRequired){$.messager.alert(jscape.Resources["serviceCreatedDialog.title"],jscape.Resources["serviceCreatedDialog.message"].supplant({clientProtocol:jscape.Resources["protocol."+summary.clientProtocolAlias],serverProtocol:jscape.Resources["protocol."+summary.serverProtocolAlias],host:summary.localAddress.host,port:summary.localAddress.port}),"info",$.proxy(function(){this.callback(summary,startRequired);},this));},_resolveProtocol:function(protocol){return this.PROTOCOL_MAP[protocol]?this.PROTOCOL_MAP[protocol]:protocol;},_defaultPortOf:function(protocol){return this.DEFAULT_PORTS[protocol]?this.DEFAULT_PORTS[protocol]:1000;}});jscape.ServiceProtocolDialog=Class.extend({PROTOCOL_MAP:{FTP:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS_IMPLICIT",text:jscape.Resources["protocol.FTPS_IMPLICIT"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],FTPS:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS",text:jscape.Resources["protocol.FTPS"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],FTPS_IMPLICIT:[{value:"FTP",text:jscape.Resources["protocol.FTP"]},{value:"FTPS_IMPLICIT",text:jscape.Resources["protocol.FTPS_IMPLICIT"]},{value:"SFTP",text:jscape.Resources["protocol.SFTP"]}],HTTP:[{value:"HTTP",text:jscape.Resources["protocol.HTTP"]},{value:"HTTPS",text:jscape.Resources["protocol.HTTPS"]}],HTTPS:[{value:"HTTP",text:jscape.Resources["protocol.HTTP"]},{value:"HTTPS",text:jscape.Resources["protocol.HTTPS"]}],RAW:[{value:"RAW",text:jscape.Resources["protocol.RAW"]},{value:"RAW_SSL",text:jscape.Resources["protocol.RAW_SSL"]}],RAW_SSL:[{value:"RAW",text:jscape.Resources["protocol.RAW"]},{value:"RAW_SSL",text:jscape.Resources["protocol.RAW_SSL"]}],SSH_SFTP:[{value:"SSH_SFTP",text:jscape.Resources["protocol.SSH_SFTP"]}],SMTP:[{value:"SMTP",text:jscape.Resources["protocol.SMTP"]}],POP3:[{value:"POP3",text:jscape.Resources["protocol.POP3"]}],IMAP4:[{value:"IMAP4",text:jscape.Resources["protocol.IMAP4"]}],MYSQL:[{value:"MYSQL",text:jscape.Resources["protocol.MYSQL"]}],UDP:[{value:"UDP",text:jscape.Resources["protocol.UDP"]}]},init:function(){this.dialog=$("#serviceProtocolDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["serviceProtocolDialog.title"],width:jscape.Resources.intVal("serviceProtocolDialog.width"),height:jscape.Resources.intVal("serviceProtocolDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.clientProtocolBox=$("#clientProtocolBox");this.clientProtocolBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,onChange:$.proxy(this._clientProtocolSelected,this)});this.serverProtocolBox=$("#serverProtocolBox");this.serverProtocolBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.clientProtocolBox.focus();this._clientProtocolSelected(this.getClientProtocol());},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getClientProtocol:function(){return this.clientProtocolBox.combobox("getValue");},getServerProtocol:function(){return this.serverProtocolBox.combobox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_clientProtocolSelected:function(newValue,oldValue){var serverProtocols=this.PROTOCOL_MAP[newValue];this.serverProtocolBox.combobox("clear");this.serverProtocolBox.combobox("loadData",serverProtocols);this.serverProtocolBox.combobox("select",serverProtocols[0].value);}});jscape.AddFtpServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),ftpData:{ignoreServerPassiveIp:this.dialog.isIgnorePasvIp()}};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddFtpServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpServiceDialog.title"],width:jscape.Resources.intVal("addFtpServiceDialog.width"),height:jscape.Resources.intVal("addFtpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#ftpLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpHost",jscape.Resources["addFtpServiceDialog.error.emptyLocalHost.message"])]});this.localPortField=$("#ftpLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#ftpRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#ftpRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpRemoteHost",jscape.Resources["addFtpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#ftpRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#ftpRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#ftpClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#ftpClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.connectionDelegationBox=$("#ftpConnectionDelegationBox");this.ignorePasvIpBox=$("#ftpIgnorePasvIpBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddFtpExplicitServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{ignoreServerPassiveIp:this.dialog.isIgnorePasvIp()}};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddFtpExplicitServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpExplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpExplicitServiceDialog.title"],width:jscape.Resources.intVal("addFtpExplicitServiceDialog.width"),height:jscape.Resources.intVal("addFtpExplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#ftpExplicitLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpExplicitHost",jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#ftpExplicitLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#ftpExplicitRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#ftpExplicitRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpExplicitRemoteHost",jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#ftpExplicitRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:21,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#ftpExplicitRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#ftpExplicitClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#ftpExplicitClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.keysBox=$("#ftpExplicitKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addFtpExplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.connectionDelegationBox=$("#ftpExplicitConnectionDelegationBox");this.fipsModeBox=$("#ftpExplicitFipsModeBox");this.ignorePasvIpBox=$("#ftpExplicitIgnorePasvIpBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpExplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},setKeys:function(values){var keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},getKey:function(){return this.keysBox.combobox("getValue");},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddFtpImplicitServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),ftpData:{ignoreServerPassiveIp:this.dialog.isIgnorePasvIp()}};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddFtpImplicitServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addFtpImplicitServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addFtpImplicitServiceDialog.title"],width:jscape.Resources.intVal("addFtpImplicitServiceDialog.width"),height:jscape.Resources.intVal("addFtpImplicitServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#ftpImplicitLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddFtpImplicitHost",jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#ftpImplicitLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#ftpImplicitRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#ftpImplicitRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddFtpImplicitRemoteHost",jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#ftpImplicitRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:990,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#ftpImplicitRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#ftpImplicitClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#ftpImplicitClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.keysBox=$("#ftpImplicitKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addFtpImplicitServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.connectionDelegationBox=$("#ftpImplicitConnectionDelegationBox");this.fipsModeBox=$("#ftpImplicitFipsModeBox");this.ignorePasvIpBox=$("#ftpImplicitIgnorePasvIpBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addFtpImplicitServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));if(clientProtocol==="FTP"){this.fipsModeBox.parent().hide();}else{this.fipsModeBox.parent().show();}},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},setKeys:function(values){var keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},getKey:function(){return this.keysBox.combobox("getValue");},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isIgnorePasvIp:function(){return this.ignorePasvIpBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddRawServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired()};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddRawServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addRawServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRawServiceDialog.title"],width:jscape.Resources.intVal("addRawServiceDialog.width"),height:jscape.Resources.intVal("addRawServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#rawLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddRawHost",jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#rawLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#rawRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#rawRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddRawRemoteHost",jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#rawRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#rawRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#rawClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#rawClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.connectionDelegationBox=$("#rawConnectionDelegationBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addRawServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddRawSslServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);this.dialog.setKeys(keys);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired()};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddRawSslServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addRawSslServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRawSslServiceDialog.title"],width:jscape.Resources.intVal("addRawSslServiceDialog.width"),height:jscape.Resources.intVal("addRawSslServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#rawSslLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddRawSslHost",jscape.Resources["addRawSslServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#rawSslLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#rawSslRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#rawSslRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddRawSslRemoteHost",jscape.Resources["addRawSslServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#rawSslRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:22,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#rawSslRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#rawSslClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#rawSslClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.keysBox=$("#rawSslKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addRawSslServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.connectionDelegationBox=$("#rawSslConnectionDelegationBox");this.fipsModeBox=$("#rawSslFipsModeBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addRawSslServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},setKeys:function(values){var keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},getKey:function(){return this.keysBox.combobox("getValue");},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddUdpServiceController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(addresses);this.dialog.setLocalPort(defaultClientPort);this.dialog.setRemotePort(defaultServerPort);this.dialog.setClusters(clusters);},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired()};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);}});jscape.AddUdpServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addUdpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addUdpServiceDialog.title"],width:jscape.Resources.intVal("addUdpServiceDialog.width"),height:jscape.Resources.intVal("addUdpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#udpLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddRawHost",jscape.Resources["addRawServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#udpLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#udpRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#udpRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddRawRemoteHost",jscape.Resources["addRawServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#udpRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:3000,increment:1,required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#udpRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addUdpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#udpClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#udpClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150,});this.connectionDelegationBox=$("#udpConnectionDelegationBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addUdpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}}});jscape.AddHttpServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialog,rulesController,testParametersController){this.dialog=dialog;this.rulesController=rulesController;this.testParametersController=testParametersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.defaultClientPort=defaultClientPort;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.defaultServerPort=defaultServerPort;this.addresses=addresses;this.clusters=clusters;this.callback=callback;this.testParameters=this.DEFAULT_TEST_PARAMETERS;jscape.OPERATION_SERVICE.httpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this._rules():[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null}};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},onSelectRules:function(){this.rulesController.start(this.rules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},_configurationLoaded:function(configuration){this.rules=$.map(configuration.rewriteRules,function(value){return{name:value.name,enabled:false};});this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setLocalPort(this.defaultClientPort);this.dialog.setRemotePort(this.defaultServerPort);this.dialog.setClusters(this.clusters);},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.rules=rules;},_rules:function(){var rules=[];$.each(this.rules,function(index,rule){if(rule.enabled){rules.push(rule.name)}});return rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;}});jscape.AddHttpServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addHttpServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addHttpServiceDialog.title"],width:jscape.Resources.intVal("addHttpServiceDialog.width"),height:jscape.Resources.intVal("addHttpServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#httpLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddHttpHost",jscape.Resources["addHttpServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#httpLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#httpRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#httpRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddHttpRemoteHost",jscape.Resources["addHttpServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#httpRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#httpRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addHttpServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#httpClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#httpClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.connectionDelegationBox=$("#httpConnectionDelegationBox");this.rewriteRulesBox=$("#httpUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._onRewriteRulesBoxClick,this));this.rewriteRulesButton=$("#httpRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("addHttpServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#httpTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#httpTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("addHttpServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addHttpServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_onRewriteRulesBoxClick:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");}});jscape.AddHttpsServiceController=Class.extend({DEFAULT_TEST_PARAMETERS:{path:"/",statusRegexp:"2[0-9][0-9]",bodyRegexp:""},init:function(dialog,rulesController,testParametersController){this.dialog=dialog;this.rulesController=rulesController;this.testParametersController=testParametersController;},start:function(clientProtocol,clientProtocolAlias,defaultClientPort,serverProtocol,serverProtocolAlias,defaultServerPort,addresses,keys,clusters,callback){this.clientProtocol=clientProtocol;this.clientProtocolAlias=clientProtocolAlias;this.defaultClientPort=defaultClientPort;this.serverProtocol=serverProtocol;this.serverProtocolAlias=serverProtocolAlias;this.defaultServerPort=defaultServerPort;this.addresses=addresses;this.keys=keys;this.clusters=clusters;this.callback=callback;this.testParameters=this.DEFAULT_TEST_PARAMETERS;jscape.OPERATION_SERVICE.httpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onSubmit:function(startRequired){var service={localAddress:{host:this.dialog.getLocalHost(),port:this.dialog.getLocalPort()},remoteDescriptor:this.dialog.getRemoteHost()?{remoteAddress:{host:this.dialog.getRemoteHost(),port:this.dialog.getRemotePort()},timeout:this.dialog.getRemoteTimeout()}:null,clusterName:this.dialog.getRemoteHost()?null:this.dialog.getCluster(),clientProtocol:this.clientProtocol,clientProtocolAlias:this.clientProtocolAlias,serverProtocol:this.serverProtocol,serverProtocolAlias:this.serverProtocolAlias,keyAlias:this.dialog.getKey(),connectionDelegationRequired:this.dialog.isConnectionDelegationRequired(),fipsModeRequired:this.dialog.isFipsModeRequired(),httpData:{rewriteRules:this.dialog.isUseRewriteRules()?this._rules():[],testParameters:this.dialog.isUseTestParameters()?this.testParameters:null}};jscape.OPERATION_SERVICE.addProxyService(service,$.proxy(function(summary){this._serviceAdded(summary,startRequired);},this));},onCancel:function(){this.dialog.hide();},onSelectRules:function(){this.rulesController.start(this.rules,$.proxy(this._rulesSelected,this));},onSetupTestParameters:function(){this.testParametersController.start(this.testParameters,$.proxy(this._testParametersSelected,this));},_configurationLoaded:function(configuration){this.rules=$.map(configuration.rewriteRules,function(value){return{name:value.name,enabled:false};});this.dialog.reset();this.dialog.show(this);this.dialog.setProtocols(this.clientProtocolAlias,this.serverProtocolAlias);this.dialog.setAddresses(this.addresses);this.dialog.setLocalPort(this.defaultClientPort);this.dialog.setRemotePort(this.defaultServerPort);this.dialog.setClusters(this.clusters);this.dialog.setKeys(this.keys);},_serviceAdded:function(summary,startRequired){this.dialog.hide();this.callback(summary,startRequired);},_rulesSelected:function(rules){this.rules=rules;},_rules:function(){var rules=[];$.each(this.rules,function(index,rule){if(rule.enabled){rules.push(rule.name)}});return rules;},_testParametersSelected:function(testParameters){this.testParameters=testParameters;}});jscape.AddHttpsServiceDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#addHttpsServiceDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addHttpsServiceDialog.title"],width:jscape.Resources.intVal("addHttpsServiceDialog.width"),height:jscape.Resources.intVal("addHttpsServiceDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(function(){this._onSubmit(false);},this)},{text:jscape.Resources["button.addStart.text"],width:jscape.Resources.intVal("button.addStart.width"),handler:$.proxy(function(){this._onSubmit(true);},this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.localHostField=$("#httpsLocalHostField");this.localHostField.combobox({valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyLocalHost.message"],validType:[requiredFieldRule("requiredAddHttpsHost",jscape.Resources["addHttpsServiceDialog.error.emptyLocalHost.message"]),]});this.localPortField=$("#httpsLocalPortField");this.localPortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyLocalPort.message"]});this.remoteServerButton=$("#httpsRemoteServerButton");this.remoteServerButton.click($.proxy(this._strategySelected,this));this.remoteHostField=$("#httpsRemoteHostField");this.remoteHostField.textbox({required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemoteHost.message"],validType:requiredFieldRule("requiredAddHttpsRemoteHost",jscape.Resources["addHttpsServiceDialog.error.emptyRemoteHost.message"])});this.remotePortField=$("#httpsRemotePortField");this.remotePortField.numberspinner({min:1,max:65535,value:443,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemotePort.message"]});this.remoteTimeoutField=$("#httpsRemoteTimeoutField");this.remoteTimeoutField.numberspinner({min:1,max:999,value:30,increment:1,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyRemoteTimeout.message"]});this.clusterButton=$("#httpsClusterButton");this.clusterButton.click($.proxy(this._strategySelected,this));this.clustersBox=$("#httpsClustersBox");this.clustersBox.combobox({valueField:"value",textField:"value",editable:false,disabled:true,panelHeight:"auto",panelMaxHeight:150});this.keysBox=$("#httpsKeysBox");this.keysBox.combobox({valueField:"value",textField:"value",editable:false,required:true,missingMessage:jscape.Resources["addHttpsServiceDialog.error.emptyKey.message"],panelHeight:"auto"});this.connectionDelegationBox=$("#httpsConnectionDelegationBox");this.fipsModeBox=$("#httpsFipsModeBox");this.rewriteRulesBox=$("#httpsUseRewriteRulesBox");this.rewriteRulesBox.click($.proxy(this._rewriteRulesBoxClicked,this));this.rewriteRulesButton=$("#httpsRewriteRulesButton");this.rewriteRulesButton.linkbutton({width:jscape.Resources.intVal("addHttpsServiceDialog.rewriteRulesButton.width"),disabled:true});this.rewriteRulesButton.click($.proxy(function(){this.listener.onSelectRules();},this));this.testParametersBox=$("#httpsTestParametersBox");this.testParametersBox.click($.proxy(this._onTestParametersBoxClick,this));this.testParametersButton=$("#httpsTestParametersButton");this.testParametersButton.linkbutton({width:jscape.Resources.intVal("addHttpsServiceDialog.testParametersButton.width"),disabled:true});this.testParametersButton.click($.proxy(function(){this.listener.onSetupTestParameters();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.localHostField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._strategySelected();this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");},setProtocols:function(clientProtocol,serverProtocol){this.dialog.dialog("setTitle",jscape.Resources["addHttpsServiceDialog.title"].supplant({clientProtocol:jscape.Resources["protocol."+clientProtocol],serverProtocol:jscape.Resources["protocol."+serverProtocol]}));},setAddresses:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.localHostField.combobox("loadData",hosts);this.localHostField.combobox("setValue",this.DEFAULT_HOST).combobox("select",this.DEFAULT_HOST);},setClusters:function(values){var clusters=$.map(values,function(value){return{value:value};});this.clustersBox.combobox("loadData",clusters);if(values.length>0){this.clustersBox.combobox("setValue",values[0]).combobox("select",values[0]);}else{this.clusterButton.prop("disabled",true);}},setKeys:function(values){var keys=$.map(values,function(value){return{value:value};});this.keysBox.combobox("loadData",keys);if(values.length>0){this.keysBox.combobox("setValue",values[0]).combobox("select",values[0]);}},getLocalHost:function(){return this.localHostField.combobox("getValue").trim();},getLocalPort:function(){return parseInt(this.localPortField.numberspinner("getValue"),10);},setLocalPort:function(value){this.localPortField.numberspinner("setValue",value);},getRemoteHost:function(){return this.remoteServerButton.prop("checked")?this.remoteHostField.textbox("getValue").trim():null;},getRemotePort:function(){return parseInt(this.remotePortField.numberspinner("getValue"),10);},setRemotePort:function(value){this.remotePortField.numberspinner("setValue",value);},getRemoteTimeout:function(){return parseInt(this.remoteTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},getCluster:function(){return this.clusterButton.prop("checked")?this.clustersBox.combobox("getValue"):null;},getKey:function(){return this.keysBox.combobox("getValue");},isConnectionDelegationRequired:function(){return this.connectionDelegationBox.prop("checked");},isFipsModeRequired:function(){return this.fipsModeBox.prop("checked");},isUseRewriteRules:function(){return this.rewriteRulesBox.prop("checked");},isUseTestParameters:function(){return this.testParametersBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(startRequired){if(this.form.form("validate")){this.listener.onSubmit(startRequired);}},_onCancel:function(){this.listener.onCancel();},_strategySelected:function(){if(this.remoteServerButton.prop("checked")){this.remoteHostField.textbox("enable");this.remoteHostField.textbox("enableValidation");this.remotePortField.numberspinner("enable");this.clustersBox.combobox("disable");}else if(this.clusterButton.prop("checked")){this.remoteHostField.textbox("disable");this.remoteHostField.textbox("disableValidation");this.remotePortField.numberspinner("disable");this.clustersBox.combobox("enable");}},_rewriteRulesBoxClicked:function(){this.rewriteRulesButton.linkbutton(this.rewriteRulesBox.prop("checked")?"enable":"disable");},_onTestParametersBoxClick:function(){this.testParametersButton.linkbutton(this.testParametersBox.prop("checked")?"enable":"disable");}});jscape.HttpTestParametersController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(parameters,callback){this.parameters=parameters;this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setPath(this.parameters.path);this.dialog.setStatusRegexp(this.parameters.statusRegexp);this.dialog.setBodyRegexp(this.parameters.bodyRegexp);},onSubmit:function(){var parameters={path:this.dialog.getPath(),statusRegexp:this.dialog.getStatusRegexp(),bodyRegexp:this.dialog.getBodyRegexp()};this.dialog.hide();this.callback(parameters);},onCancel:function(){this.dialog.hide();}});jscape.HttpTestParametersDialog=Class.extend({init:function(){this.dialog=$("#httpTestParametersDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["httpTestParametersDialog.title"],width:jscape.Resources.intVal("httpTestParametersDialog.width"),height:jscape.Resources.intVal("httpTestParametersDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.pathField=$("#httpMonitorPathField");this.pathField.textbox({required:true,missingMessage:jscape.Resources["httpTestParametersDialog.error.emptyMonitorPath.message"],validType:[requiredFieldRule("requiredHttpMonitorPath",jscape.Resources["httpTestParametersDialog.error.emptyMonitorPath.message"])]});this.statusRegexpField=$("#httpMonitorStatusRegexpField");this.statusRegexpField.textbox({required:true,missingMessage:jscape.Resources["httpTestParametersDialog.error.emptyMonitorStatusRegexp.message"],validType:[requiredFieldRule("requiredHttpsMonitorStatusRegexp",jscape.Resources["httpTestParametersDialog.error.emptyMonitorStatusRegexp.message"])]});this.bodyRegexpField=$("#httpMonitorBodyRegexpField");this.bodyRegexpField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.pathField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getPath:function(){return this.pathField.textbox("getValue").trim();},setPath:function(value){this.pathField.textbox("setValue",value);this.pathField.textbox("validate");},getStatusRegexp:function(){return this.statusRegexpField.textbox("getValue").trim();},setStatusRegexp:function(value){this.statusRegexpField.textbox("setValue",value);this.statusRegexpField.textbox("validate");},getBodyRegexp:function(){return this.bodyRegexpField.textbox("getValue").trim();},setBodyRegexp:function(value){this.bodyRegexpField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.HttpServiceRulesController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(rules,callback){this._initRules(rules);this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setRules(this.rules);},onSubmit:function(){this.dialog.hide();this.callback(this.rules);},onCancel:function(){this.dialog.hide();},onRuleUp:function(index){if(0<index&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index-1];this.rules[index-1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index-1);}},onRuleDown:function(index){if(index<this.rules.length-1&&this.rules.length>1){var tmp=this.rules[index];this.rules[index]=this.rules[index+1];this.rules[index+1]=tmp;this.dialog.setRules(this.rules);this.dialog.selectRule(index+1);}},_initRules:function(rules){this.rules=[];var enabledRules=[];var disabledRules=[];var i;var rule;for(i=0;i<rules.length;++i){rule={name:rules[i].name,enabled:rules[i].enabled};if(rule.enabled){enabledRules.push(rule);}else{disabledRules.push(rule);}}
this.rules=enabledRules.concat(disabledRules);}});jscape.HttpServiceRulesDialog=Class.extend({init:function(){this.dialog=$("#httpServiceRulesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["httpServiceRulesDialog.title"],width:jscape.Resources.intVal("httpServiceRulesDialog.width"),height:jscape.Resources.intVal("httpServiceRulesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.rulesTable=$("#httpServiceRulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["httpServiceRulesDialog.rulesTable.column.0"],sortable:false,width:80},{field:"enabled",title:jscape.Resources["httpServiceRulesDialog.rulesTable.column.1"],sortable:false,width:20,checkbox:true}]],selectOnCheck:false,checkOnSelect:false,onSelect:$.proxy(this._ruleSelected,this),onCheck:function(index,row){row.enabled=true;},onUncheck:function(index,row){row.enabled=false;},onCheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=true;}},onUncheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=false;}}});this.ruleUpButton=$("#httpServiceRuleUpButton");this.ruleUpButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleUpButton.click($.proxy(function(){if(!this.ruleUpButton.linkbutton("options").disabled){this.listener.onRuleUp(this.row);}},this));this.ruleDownButton=$("#httpServiceRuleDownButton");this.ruleDownButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.ruleDownButton.click($.proxy(function(){if(!this.ruleDownButton.linkbutton("options").disabled){this.listener.onRuleDown(this.row);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.rulesTable.datagrid("loadData",[]);this.ruleUpButton.linkbutton("disable");this.ruleDownButton.linkbutton("disable");},setRules:function(values){this.rulesTable.datagrid("loadData",values);var i;for(i=0;i<values.length;++i){if(values[i].enabled){this.rulesTable.datagrid("checkRow",i);}}
this.ruleUpButton.linkbutton("disable");this.ruleDownButton.linkbutton("disable");},selectRule:function(index){this.rulesTable.datagrid("selectRow",index);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_ruleSelected:function(row,rule){this.row=row;this.rule=rule;this.ruleUpButton.linkbutton(row>0?"enable":"disable");this.ruleDownButton.linkbutton(row<this.rulesTable.datagrid("getData").rows.length-1?"enable":"disable");}});jscape.ServiceParametersController=Class.extend({start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.addresses=addresses;jscape.OPERATION_SERVICE.serverKeyAliases($.proxy(this._keysLoaded,this));},_keysLoaded:function(keys){this.keys=keys;jscape.OPERATION_SERVICE.clusters($.proxy(this._clustersLoaded,this));},_clustersLoaded:function(clusters){this.callback(this.addresses,this.keys,clusters);}});jscape.StopServiceController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["stopServiceDialog.title"],this.values.length===1?jscape.Resources["stopServiceDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["stopServiceDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.OPERATION_SERVICE.stopProxyService(this.values[this.valueIndex++].id,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){$.messager.alert(jscape.Resources["serviceStoppedDialog.title"],this.values.length===1?jscape.Resources["serviceStoppedDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["serviceStoppedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}),"info",$.proxy(this.callback,this));}});jscape.DeleteServiceController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteServiceDialog.title"],this.values.length===1?jscape.Resources["deleteServiceDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["deleteServiceDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.OPERATION_SERVICE.deleteProxyService(this.values[this.valueIndex++].id,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){$.messager.alert(jscape.Resources["serviceDeletedDialog.title"],this.values.length===1?jscape.Resources["serviceDeletedDialog.message"].supplant(this.values[0].localAddress):jscape.Resources["serviceDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}),"info",$.proxy(this.callback,this));}});jscape.SslCiphersController=Class.extend({STRONG_CIPHERS:["SSL_RSA_WITH_RC4_128_MD5","SSL_RSA_WITH_RC4_128_SHA","SSL_RSA_WITH_3DES_EDE_CBC_SHA","SSL_RSA_WITH_AES_128_CBC_SHA","SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA","SSL_DHE_RSA_WITH_AES_128_CBC_SHA","SSL_DHE_DSS_WITH_AES_128_CBC_SHA","SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA","SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA","SSL_DHE_DSS_WITH_RC4_128_SHA","SSL_KRB5_WITH_RC4_128_SHA","SSL_KRB5_WITH_RC4_128_MD5","SSL_KRB5_WITH_3DES_EDE_CBC_SHA","SSL_KRB5_WITH_3DES_EDE_CBC_MD5","TLS_RSA_WITH_AES_128_CBC_SHA","TLS_DHE_RSA_WITH_AES_128_CBC_SHA","TLS_DHE_DSS_WITH_AES_128_CBC_SHA","TLS_KRB5_WITH_RC4_128_SHA","TLS_KRB5_WITH_RC4_128_MD5","TLS_KRB5_WITH_3DES_EDE_CBC_SHA","TLS_KRB5_WITH_3DES_EDE_CBC_MD5"],MEDIUM_CIPHERS:["SSL_DHE_RSA_WITH_DES_CBC_SHA","SSL_DHE_DSS_WITH_DES_CBC_SHA","SSL_RSA_WITH_DES_CBC_SHA","SSL_RSA_FIPS_WITH_DES_CBC_SHA","SSL_KRB5_WITH_DES_CBC_SHA","SSL_KRB5_WITH_DES_CBC_MD5","TLS_KRB5_WITH_DES_CBC_SHA","TLS_KRB5_WITH_DES_CBC_MD5"],init:function(dialog){this.dialog=dialog;},start:function(ciphers,callback){this.enabledCiphers=ciphers;this.callback=callback;jscape.OPERATION_SERVICE.serverParameters($.proxy(this._parametersLoaded,this));},onSubmit:function(){this.dialog.hide();var enabledCiphers=[];$.each(this.ciphers,function(index,cipher){if(cipher.enabled){enabledCiphers.push(cipher.cipher);}});this.callback(enabledCiphers);},onCancel:function(){this.dialog.hide();},onSelectStrong:function(){this._selectCiphers(this.STRONG_CIPHERS);this.dialog.setCiphers(this.ciphers);},onSelectStrongMedium:function(){this._selectCiphers(this.STRONG_CIPHERS.concat(this.MEDIUM_CIPHERS));this.dialog.setCiphers(this.ciphers);},_parametersLoaded:function(parameters){this._initCiphers(parameters.sslCipherSuites);this.dialog.reset();this.dialog.show(this);this.dialog.setCiphers(this.ciphers);},_initCiphers:function(sslCipherSuites){this.ciphers=[];var enabledCiphers=[];var disableCiphers=[];var i;var cipherName;var cipher;for(i=0;i<sslCipherSuites.length;++i){cipherName=sslCipherSuites[i];cipher={cipher:cipherName,enabled:!this.enabledCiphers||this.enabledCiphers.indexOf(cipherName)>-1};if(cipher.enabled){enabledCiphers.push(cipher);}else{disableCiphers.push(cipher);}}
this.ciphers=enabledCiphers.concat(disableCiphers);},_selectCiphers:function(targetCiphers){var enabledCiphers=[];var disableCiphers=[];var i;var cipher;for(i=0;i<this.ciphers.length;++i){cipher=this.ciphers[i];if(targetCiphers.indexOf(cipher.cipher)>-1){cipher.enabled=true;enabledCiphers.push(cipher);}else{cipher.enabled=false;disableCiphers.push(cipher);}}
this.ciphers=enabledCiphers.concat(disableCiphers);}});jscape.SslCiphersDialog=Class.extend({init:function(){this.dialog=$("#sslCiphersDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["sslCiphersDialog.title"],width:jscape.Resources.intVal("sslCiphersDialog.width"),height:jscape.Resources.intVal("sslCiphersDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.ciphersTable=$("#sslCiphersTable");this.ciphersTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"cipher",title:jscape.Resources["sslCiphersDialog.ciphersTable.column.0"],sortable:false,width:80},{field:"enabled",title:jscape.Resources["sslCiphersDialog.ciphersTable.column.1"],sortable:false,width:20,checkbox:true}]],selectOnCheck:false,checkOnSelect:false,onCheck:function(index,row){row.enabled=true;},onUncheck:function(index,row){row.enabled=false;},onCheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=true;}},onUncheckAll:function(rows){var i;for(i=0;i<rows.length;++i){rows[i].enabled=false;}}});this.selectStrongButton=$("#selectSslStrongButton");this.selectStrongButton.linkbutton({width:jscape.Resources.intVal("sslCiphersDialog.selectStrongButton.width")});this.selectStrongButton.click($.proxy(function(){this.listener.onSelectStrong();},this));this.selectMediumButton=$("#selectSslMediumButton");this.selectMediumButton.linkbutton({width:jscape.Resources.intVal("sslCiphersDialog.selectSslMediumButton.width")});this.selectMediumButton.click($.proxy(function(){this.listener.onSelectStrongMedium();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.ciphersTable.datagrid("loadData",[]);},setCiphers:function(values){this.ciphersTable.datagrid("loadData",values);var i;for(i=0;i<values.length;++i){if(values[i].enabled){this.ciphersTable.datagrid("checkRow",i);}}},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.FtpConfigurationController=Class.extend({init:function(panel,changeConfigurationController){this.panel=panel;this.changeConfigurationController=changeConfigurationController;},start:function(){jscape.OPERATION_SERVICE.ftpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onVisible:function(){},onChange:function(){this.changeConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPanel();this.panel.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPanel();},_initPanel:function(){this.panel.setCommandTimeout(this.configuration.commandConnectionTimeoutMillis);this.panel.setCommandNagleAlgorithm(this.configuration.commandSocketNagleAlgorithmDisabled);this.panel.setDataTimeout(this.configuration.dataConnectionTimeoutMillis);this.panel.setDataChannelBufferSize(this.configuration.dataSocketBufferSizeBytes);this.panel.setDataNagleAlgorithm(this.configuration.dataSocketNagleAlgorithmDisabled);this.panel.setDataTransferBufferSize(this.configuration.dataTransferBufferSizeBytes);this.panel.setPassiveIp(this.configuration.passiveTransferConfiguration.outerIp);this.panel.setPortRange(this.configuration.passiveTransferConfiguration.lowerPortBound,this.configuration.passiveTransferConfiguration.upperPortBound);this.panel.setBlockBounceAttack(this.configuration.blockBounceAttack);this.panel.setBlockPasvAttack(this.configuration.blockPasvAttack);}});jscape.FtpConfigurationPanel=Class.extend({TIMEOUT_FACTOR:1000,SIZE_FACTOR:1024,init:function(){this.commandTimeoutField=$("#commandChannelTimeoutValueField");this.commandNagleAlgorithmField=$("#commandChannelNagleAlgorithmField");this.dataTimeoutField=$("#dataChannelTimeoutValueField");this.dataChannelBufferSizeField=$("#dataChannelBufferSizeField");this.dataChannelNagleAlgorithmField=$("#dataChannelNagleAlgorithmField");this.dataTransferBufferSizeField=$("#dataTransferBufferSizeField");this.passiveIpField=$("#passiveIpValueField");this.passivePortRangeField=$("#passivePortRangeValueField");this.blockBounceField=$("#bounceAttackValueField");this.blockPasvField=$("#pasvAttackValueField");this.changeButton=$("#changeFtpConfigurationButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;},setCommandTimeout:function(value){this.commandTimeoutField.text(jscape.Resources["servicesPage.ftpTab.timeoutValue.text"].supplant({value:value/this.TIMEOUT_FACTOR}));},setCommandNagleAlgorithm:function(value){this.commandNagleAlgorithmField.text(jscape.Resources[value===null||value===undefined?"default":!value?"enabled":"disabled"]);},setDataTimeout:function(value){this.dataTimeoutField.text(jscape.Resources["servicesPage.ftpTab.timeoutValue.text"].supplant({value:value/this.TIMEOUT_FACTOR}));},setDataChannelBufferSize:function(value){this.dataChannelBufferSizeField.text(value===null||value===undefined?jscape.Resources["default"]:jscape.Resources["servicesPage.ftpTab.bufferSizeValue.text"].supplant({value:value}));},setDataNagleAlgorithm:function(value){this.dataChannelNagleAlgorithmField.text(jscape.Resources[value===null||value===undefined?"default":!value?"enabled":"disabled"]);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.text(jscape.Resources["servicesPage.ftpTab.bufferSizeValue.text"].supplant({value:value}));},setPassiveIp:function(value){this.passiveIpField.text(value?value:"");},setPortRange:function(lowerBound,upperBound){this.passivePortRangeField.text(lowerBound&&upperBound?jscape.Resources["servicesPage.ftpTab.portRangeValue.text"].supplant({lowerBound:lowerBound,upperBound:upperBound}):"");},setBlockBounceAttack:function(value){this.blockBounceField.text(value?jscape.Resources["blocked"]:jscape.Resources["not.blocked"]);},setBlockPasvAttack:function(value){this.blockPasvField.text(value?jscape.Resources["blocked"]:jscape.Resources["not.blocked"]);},_onChange:function(){this.listener.onChange();}});jscape.ChangeFtpConfigurationController=Class.extend({init:function(dialog,sslCiphersController){this.dialog=dialog;this.sslCiphersController=sslCiphersController;},start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.ftpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(){var configuration={commandConnectionTimeoutMillis:this.dialog.getCommandTimeout(),commandSocketNagleAlgorithmDisabled:this.dialog.getCommandNagleAlgorithm(),dataConnectionTimeoutMillis:this.dialog.getDataTimeout(),dataSocketNagleAlgorithmDisabled:this.dialog.getDataNagleAlgorithm(),dataSocketBufferSizeBytes:this.dialog.getDataChannelBufferSize(),dataTransferBufferSizeBytes:this.dialog.getDataTransferBufferSize(),passiveTransferConfiguration:{outerIp:this.dialog.getPassiveIp(),innerIpRegexp:this.dialog.getPassiveIpRegexp(),lowerPortBound:this.dialog.getLowerPortBound(),upperPortBound:this.dialog.getUpperPortBound()},blockBounceAttack:this.dialog.isBlockBounceAttack(),blockPasvAttack:this.dialog.isBlockPasvAttack(),shutdownServerSsl:this.dialog.isShutdownSslServer(),shutdownClientSsl:this.dialog.isShutdownSslClient(),cipherSuites:this.ciphers,version:this.configuration.version};jscape.OPERATION_SERVICE.updateFtpProxyServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.ciphers=this.configuration.cipherSuites?this.configuration.cipherSuites.slice():[];this.dialog.reset();this.dialog.setCommandTimeout(this.configuration.commandConnectionTimeoutMillis);this.dialog.setCommandNagleAlgorithm(this.configuration.commandSocketNagleAlgorithmDisabled);this.dialog.setDataTimeout(this.configuration.dataConnectionTimeoutMillis);this.dialog.setDataNagleAlgorithm(this.configuration.dataSocketNagleAlgorithmDisabled);this.dialog.setDataChannelBufferSize(this.configuration.dataSocketBufferSizeBytes);this.dialog.setDataTransferBufferSize(this.configuration.dataTransferBufferSizeBytes);this.dialog.setPassiveIp(this.configuration.passiveTransferConfiguration.outerIp);this.dialog.setPassiveIpRegexp(this.configuration.passiveTransferConfiguration.innerIpRegexp);this.dialog.setPortRange(this.configuration.passiveTransferConfiguration);this.dialog.setBlockBounceAttack(this.configuration.blockBounceAttack);this.dialog.setBlockPasvAttack(this.configuration.blockPasvAttack);this.dialog.setShutdownSslServer(this.configuration.shutdownServerSsl);this.dialog.setShutdownSslClient(this.configuration.shutdownClientSsl);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["ftpServiceConfigurationAppliedDialog.title"],jscape.Resources["ftpServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.ChangeFtpConfigurationDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#ftpConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["ftpConfigurationDialog.title"],width:jscape.Resources.intVal("ftpConfigurationDialog.width"),height:jscape.Resources.intVal("ftpConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.commandTimeoutField=$("#ftpCommandTimeoutField");this.commandTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["ftpConfigurationDialog.error.emptyCommandTimeout.message"]});this.commandNagleAlgorithmField=$("#ftpCommandNagleAlgorithmField");this.commandNagleAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.dataTimeoutField=$("#ftpDataTimeoutField");this.dataTimeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["ftpConfigurationDialog.error.emptyDataTimeout.message"]});this.dataNagleAlgorithmField=$("#ftpDataNagleAlgorithmField");this.dataNagleAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.dataChannelBufferSizeEnabledBox=$("#ftpDataChannelBufferSizeEnabledBox");this.dataChannelBufferSizeEnabledBox.click($.proxy(this._dataChannelBufferSizeBoxClicked,this));this.dataChannelBufferSizeField=$("#ftpDataChannelBufferSizeField");this.dataChannelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["ftpConfigurationDialog.error.emptyDataChannelBufferSize.message"]});this.dataTransferBufferSizeField=$("#ftpDataTransferBufferSizeField");this.dataTransferBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["ftpConfigurationDialog.error.emptyDataTransferBufferSize.message"]});this.passiveIpField=$("#ftpPassiveIpField");this.passiveIpField.textbox({});this.passiveRegexpBox=$("#ftpPassiveRegexpBox");this.passiveRegexpBox.click($.proxy(this._regexpBoxClicked,this));$.extend($.fn.validatebox.defaults.rules,{validPassiveRegexp:{validator:$.proxy(function(value){return!this.passiveRegexpBox.prop("checked")||value.length>0;},this),message:jscape.Resources["ftpConfigurationDialog.error.emptyPassiveRegexp.message"]}});this.passiveRegexpField=$("#ftpPassiveRegexpField");this.passiveRegexpField.textbox({disabled:true,validType:"validPassiveRegexp"});this.passivePortBox=$("#ftpPassivePortBox");this.passivePortBox.click($.proxy(this._portBoxClicked,this));this.passivePortLowerBoundField=$("#ftpPassivePortLowerBoundField");this.passivePortLowerBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.passivePortUpperBoundField=$("#ftpPassivePortUpperBoundField");this.passivePortUpperBoundField.numberspinner({min:1,max:99999,value:60,increment:1,disabled:true});this.blockBounceBox=$("#ftpBlockBounceBox");this.blockPasvBox=$("#ftpBlockPasvBox");this.shutdownSslServerBox=$("#ftpShutdownSslServerBox");this.shutdownSslClientBox=$("#ftpShutdownSslClientBox");this.sslCiphersButton=$("#ftpConfigurationSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.commandTimeoutField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getCommandTimeout:function(){return parseInt(this.commandTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setCommandTimeout:function(value){this.commandTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getCommandNagleAlgorithm:function(){var value=this.commandNagleAlgorithmField.combobox("getValue");return value==="DEFAULT"?null:value==="DISABLED";},setCommandNagleAlgorithm:function(value){var comboValue=value===null||value===undefined?"DEFAULT":value?"DISABLED":"ENABLED";this.commandNagleAlgorithmField.combobox("setValue",comboValue).combobox("select",comboValue);},getDataTimeout:function(){return parseInt(this.dataTimeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setDataTimeout:function(value){this.dataTimeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getDataNagleAlgorithm:function(){var value=this.dataNagleAlgorithmField.combobox("getValue");return value==="DEFAULT"?null:value==="DISABLED";},setDataNagleAlgorithm:function(value){var comboValue=value===null||value===undefined?"DEFAULT":value?"DISABLED":"ENABLED";this.dataNagleAlgorithmField.combobox("setValue",comboValue).combobox("select",comboValue);},getDataChannelBufferSize:function(){return this.dataChannelBufferSizeEnabledBox.prop("checked")?parseInt(this.dataChannelBufferSizeField.numberspinner("getValue"),10):null;},setDataChannelBufferSize:function(value){if(value===null||value===undefined){this.dataChannelBufferSizeEnabledBox.prop("checked",false);this._dataChannelBufferSizeBoxClicked();}else{this.dataChannelBufferSizeEnabledBox.prop("checked",true);this._dataChannelBufferSizeBoxClicked();this.dataChannelBufferSizeField.numberspinner("setValue",value);}},getDataTransferBufferSize:function(){return parseInt(this.dataTransferBufferSizeField.numberspinner("getValue"),10);},setDataTransferBufferSize:function(value){this.dataTransferBufferSizeField.numberspinner("setValue",value);},getPassiveIp:function(){return this.passiveIpField.textbox("getValue").trim();},setPassiveIp:function(value){this.passiveIpField.textbox("setValue",value);},getPassiveIpRegexp:function(){return this.passiveRegexpBox.prop("checked")?this.passiveRegexpField.textbox("getValue").trim():null;},setPassiveIpRegexp:function(value){if(value){this.passiveRegexpBox.prop("checked",true);this.passiveRegexpField.textbox("setValue",value);}else{this.passiveRegexpBox.prop("checked",false);this.passiveRegexpField.textbox("setValue","");}
this._regexpBoxClicked();},getLowerPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortLowerBoundField.numberspinner("getValue"),10):null;},getUpperPortBound:function(){return this.passivePortBox.prop("checked")?parseInt(this.passivePortUpperBoundField.numberspinner("getValue"),10):null;},setPortRange:function(value){if(value.lowerPortBound){this.passivePortBox.prop("checked",true);this.passivePortLowerBoundField.numberspinner("setValue",value.lowerPortBound);this.passivePortUpperBoundField.numberspinner("setValue",value.upperPortBound);}else{this.passivePortBox.prop("checked",false);this.passivePortLowerBoundField.numberspinner("setValue",3000);this.passivePortUpperBoundField.numberspinner("setValue",4000);}
this._portBoxClicked();},isBlockBounceAttack:function(){return this.blockBounceBox.prop("checked");},setBlockBounceAttack:function(value){this.blockBounceBox.prop("checked",value);},isBlockPasvAttack:function(){return this.blockPasvBox.prop("checked");},setBlockPasvAttack:function(value){this.blockPasvBox.prop("checked",value);},isShutdownSslServer:function(){return this.shutdownSslServerBox.prop("checked");},setShutdownSslServer:function(value){this.shutdownSslServerBox.prop("checked",value);},isShutdownSslClient:function(){return this.shutdownSslClientBox.prop("checked");},setShutdownSslClient:function(value){this.shutdownSslClientBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_dataChannelBufferSizeBoxClicked:function(){this.dataChannelBufferSizeField.combobox(this.dataChannelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_regexpBoxClicked:function(){this.passiveRegexpField.textbox(this.passiveRegexpBox.prop("checked")?"enable":"disable");},_portBoxClicked:function(){var enable=this.passivePortBox.prop("checked")?"enable":"disable";this.passivePortLowerBoundField.numberspinner(enable);this.passivePortUpperBoundField.numberspinner(enable);}});jscape.RawConfigurationController=Class.extend({init:function(panel,changeConfigurationController){this.panel=panel;this.changeConfigurationController=changeConfigurationController;},start:function(){jscape.OPERATION_SERVICE.rawProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onVisible:function(){},onChange:function(){this.changeConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPanel();this.panel.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPanel();},_initPanel:function(){this.panel.setTimeout(this.configuration.connectionTimeoutMillis);this.panel.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.panel.setNagleAlgorithm(this.configuration.socketNagleAlgorithmDisabled);this.panel.setBufferSize(this.configuration.bufferSize);}});jscape.RawConfigurationPanel=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.timeoutField=$("#timeoutValueField");this.channelBufferSizeField=$("#rawChannelBufferField");this.nagleAlgorithmField=$("#rawNagleAlgorithmField");this.bufferSizeField=$("#rawTransferBufferField");this.changeButton=$("#changeRawConfigurationButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;},setTimeout:function(value){this.timeoutField.text(jscape.Resources["servicesPage.rawTab.timeoutValue.text"].supplant({value:value/this.TIMEOUT_FACTOR}));},setChannelBufferSize:function(value){this.channelBufferSizeField.text(value===null||value===undefined?jscape.Resources["default"]:jscape.Resources["servicesPage.rawTab.bufferSizeValue.text"].supplant({value:value}));},setNagleAlgorithm:function(value){this.nagleAlgorithmField.text(jscape.Resources[value===null||value===undefined?"default":!value?"enabled":"disabled"]);},setBufferSize:function(value){this.bufferSizeField.text(jscape.Resources["servicesPage.rawTab.bufferSizeValue.text"].supplant({value:value}));},_onChange:function(){this.listener.onChange();}});jscape.ChangeRawConfigurationController=Class.extend({init:function(dialog,sslCiphersController){this.dialog=dialog;this.sslCiphersController=sslCiphersController;},start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.rawProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onSubmit:function(){var configuration={connectionTimeoutMillis:this.dialog.getTimeout(),socketNagleAlgorithmDisabled:this.dialog.getNagleAlgorithm(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),bufferSize:this.dialog.getBufferSize(),cipherSuites:this.ciphers,version:this.configuration.version};jscape.OPERATION_SERVICE.updateRawProxyServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.ciphers=this.configuration.cipherSuites?this.configuration.cipherSuites.slice():[];this.dialog.reset();this.dialog.setTimeout(this.configuration.connectionTimeoutMillis);this.dialog.setNagleAlgorithm(this.configuration.socketNagleAlgorithmDisabled);this.dialog.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.dialog.setBufferSize(this.configuration.bufferSize);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["rawServiceConfigurationAppliedDialog.title"],jscape.Resources["rawServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;}});jscape.ChangeRawConfigurationDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#rawConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["rawConfigurationDialog.title"],width:jscape.Resources.intVal("rawConfigurationDialog.width"),height:jscape.Resources.intVal("rawConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.timeoutField=$("#rawTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["rawConfigurationDialog.error.emptyTimeout.message"]});this.nagleAlgorithmField=$("#rawEditNagleAlgorithmField");this.nagleAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.channelBufferSizeEnabledBox=$("#rawChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#rawChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["rawConfigurationDialog.error.emptyChannelBufferSize.message"]});this.bufferSizeField=$("#rawBufferSizeField");this.bufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["rawConfigurationDialog.error.emptyBufferSize.message"]});this.sslCiphersButton=$("#rawConfigurationSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.timeoutField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getNagleAlgorithm:function(){var value=this.nagleAlgorithmField.combobox("getValue");return value==="DEFAULT"?null:value==="DISABLED";},setNagleAlgorithm:function(value){var comboValue=value===null||value===undefined?"DEFAULT":value?"DISABLED":"ENABLED";this.nagleAlgorithmField.combobox("setValue",comboValue).combobox("select",comboValue);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getBufferSize:function(){return parseInt(this.bufferSizeField.numberspinner("getValue"),10);},setBufferSize:function(value){this.bufferSizeField.numberspinner("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.HttpConfigurationController=Class.extend({init:function(panel,changeConfigurationController){this.panel=panel;this.changeConfigurationController=changeConfigurationController;},start:function(){jscape.OPERATION_SERVICE.httpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onVisible:function(){},onChange:function(){this.changeConfigurationController.start($.proxy(this._configurationUpdated,this));},onClearCache:function(){$.messager.confirm(jscape.Resources["clearHttpCacheDialog.title"],jscape.Resources["clearHttpCacheDialog.message"],$.proxy(function(confirmed){if(confirmed){jscape.OPERATION_SERVICE.clearHttpProxyServiceCache($.proxy(this._cacheCleared,this));}},this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPanel();this.panel.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPanel();},_cacheCleared:function(){$.messager.alert(jscape.Resources["httpServiceCacheClearedDialog.title"],jscape.Resources["httpServiceCacheClearedDialog.message"],"info");},_initPanel:function(){this.panel.setTimeout(this.configuration.connectionTimeoutMillis);this.panel.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.panel.setNagleAlgorithm(this.configuration.socketNagleAlgorithmDisabled);this.panel.setNatHost(this.configuration.natHost);this.panel.setCache(this.configuration.cache);}});jscape.HttpConfigurationPanel=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.timeoutField=$("#httpTimeoutValueField");this.channelBufferSizeField=$("#httpChannelBufferField");this.nagleAlgorithmField=$("#httpNagleAlgorithmField");this.natHostField=$("#httpNatHostValueField");this.cachedBox=$("#httpCacheValueField");this.changeButton=$("#changeHttpConfigurationButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));this.clearCacheButton=$("#clearHttpCacheButton");this.clearCacheButton.linkbutton({width:jscape.Resources.intVal("button.clearCache.width")});this.clearCacheButton.click($.proxy(this._onClearCache,this));},show:function(listener){this.listener=listener;},setTimeout:function(value){this.timeoutField.text(jscape.Resources["servicesPage.httpTab.timeoutValue.text"].supplant({value:value/this.TIMEOUT_FACTOR}));},setChannelBufferSize:function(value){this.channelBufferSizeField.text(value===null||value===undefined?jscape.Resources["default"]:jscape.Resources["servicesPage.httpTab.bufferSizeValue.text"].supplant({value:value}));},setNagleAlgorithm:function(value){this.nagleAlgorithmField.text(jscape.Resources[value===null||value===undefined?"default":!value?"enabled":"disabled"]);},setNatHost:function(value){this.natHostField.text(value?value:"");},setCache:function(value){this.cachedBox.text(value?value.directory:jscape.Resources["disabled"]);},_onChange:function(){this.listener.onChange();},_onClearCache:function(){this.listener.onClearCache();}});jscape.ChangeHttpConfigurationController=Class.extend({init:function(dialog,selectCacheDirectoryController,sslCiphersController,rewriteRulesController){this.dialog=dialog;this.selectCacheDirectoryController=selectCacheDirectoryController;this.sslCiphersController=sslCiphersController;this.rewriteRulesController=rewriteRulesController;},start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.httpProxyServiceConfiguration($.proxy(this._configurationLoaded,this));},onSelectCacheDirectory:function(){this.selectCacheDirectoryController.selectPath($.proxy(function(entry,path){this.dialog.setCacheDirectory(path);},this));},onSelectSslCiphers:function(){this.sslCiphersController.start(this.ciphers,$.proxy(this._ciphersUpdated,this));},onChangeRewriteRules:function(){this.rewriteRulesController.start(this.rules,$.proxy(this._rulesUpdated,this));},onSubmit:function(){var configuration={connectionTimeoutMillis:this.dialog.getTimeout(),socketNagleAlgorithmDisabled:this.dialog.getNagleAlgorithm(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),natHost:this.dialog.getNatHost(),cache:this.dialog.getCache(),cipherSuites:this.ciphers,rewriteRules:this.rules,version:this.configuration.version};jscape.OPERATION_SERVICE.updateHttpProxyServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.ciphers=this.configuration.cipherSuites?this.configuration.cipherSuites.slice():[];this._initRules();this.dialog.reset();this.dialog.setTimeout(this.configuration.connectionTimeoutMillis);this.dialog.setNagleAlgorithm(this.configuration.socketNagleAlgorithmDisabled);this.dialog.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.dialog.setNatHost(this.configuration.natHost);this.dialog.setCache(this.configuration.cache);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["httpServiceConfigurationAppliedDialog.title"],jscape.Resources["httpServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));},_initRules:function(){var rules=[];$.each(this.configuration.rewriteRules,function(index,rule){rules.push($.extend({},rule));});this.rules=rules;},_ciphersUpdated:function(ciphers){this.ciphers=ciphers;},_rulesUpdated:function(rules){this.rules=rules;}});jscape.ChangeHttpConfigurationDialog=Class.extend({TIMEOUT_FACTOR:1000,init:function(){this.dialog=$("#httpConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["httpConfigurationDialog.title"],width:jscape.Resources.intVal("httpConfigurationDialog.width"),height:jscape.Resources.intVal("httpConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.timeoutField=$("#httpTimeoutField");this.timeoutField.numberspinner({min:1,max:99999,value:60,increment:1,required:true,missingMessage:jscape.Resources["httpConfigurationDialog.error.emptyConnectionTimeout.message"]});this.nagleAlgorithmField=$("#httpEditNagleAlgorithmField");this.nagleAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.channelBufferSizeEnabledBox=$("#httpChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#httpChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["httpConfigurationDialog.error.emptyChannelBufferSize.message"]});this.natHostField=$("#httpNatHostField");this.natHostField.textbox({});this.cachedBox=$("#httpCacheBox");this.cachedBox.click($.proxy(this._cacheBoxClicked,this));this.cacheDirectoryField=$("#httpCacheDirectoryField");this.cacheDirectoryField.textbox({required:true,missingMessage:jscape.Resources["httpConfigurationDialog.error.emptyCacheDirectory.message"],validType:[requiredFieldRule("requiredCacheExtension",jscape.Resources["httpConfigurationDialog.error.emptyCacheDirectory.message"])]});this.selectCacheDirectoryButton=$("#selectHttpCacheDirectoryButton");this.selectCacheDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectCacheDirectoryButton.click($.proxy(function(){if(!this.selectCacheDirectoryButton.linkbutton("options").disabled){this.listener.onSelectCacheDirectory();}},this));this.sslCiphersButton=$("#httpConfigurationSslCiphersButton");this.sslCiphersButton.linkbutton({width:jscape.Resources.intVal("sslCiphersButton.width")});this.sslCiphersButton.click($.proxy(function(){this.listener.onSelectSslCiphers();},this));this.rulesButton=$("#httpConfigurationRulesButton");this.rulesButton.linkbutton({width:jscape.Resources.intVal("httpConfigurationDialog.httpRulesButton.width")});this.rulesButton.click($.proxy(function(){this.listener.onChangeRewriteRules();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.timeoutField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getTimeout:function(){return parseInt(this.timeoutField.numberspinner("getValue"),10)*this.TIMEOUT_FACTOR;},setTimeout:function(value){this.timeoutField.numberspinner("setValue",value/this.TIMEOUT_FACTOR);},getNagleAlgorithm:function(){var value=this.nagleAlgorithmField.combobox("getValue");return value==="DEFAULT"?null:value==="DISABLED";},setNagleAlgorithm:function(value){var comboValue=value===null||value===undefined?"DEFAULT":value?"DISABLED":"ENABLED";this.nagleAlgorithmField.combobox("setValue",comboValue).combobox("select",comboValue);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},getNatHost:function(){return this.natHostField.textbox("getValue").trim();},setNatHost:function(value){this.natHostField.textbox("setValue",value);},getCache:function(){if(this.cachedBox.prop("checked")){return{directory:this.cacheDirectoryField.textbox("getValue").trim()};}
return null;},setCache:function(value){if(value){this.cachedBox.prop("checked",true);this.cacheDirectoryField.textbox("setValue",value.directory);this.cacheDirectoryField.textbox("validate");}else{this.cachedBox.prop("checked",false);this.cacheDirectoryField.textbox("setValue","");}
this._cacheBoxClicked();},setCacheDirectory:function(value){this.cacheDirectoryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");},_cacheBoxClicked:function(){var enabled=this.cachedBox.prop("checked");this.cacheDirectoryField.textbox(enabled?"enable":"disable");this.cacheDirectoryField.textbox(enabled?"enableValidation":"disableValidation");this.selectCacheDirectoryButton.linkbutton(enabled?"enable":"disable");}});jscape.UrlRewriteRulesController=Class.extend({init:function(dialog,addRewriteRuleController,editRewriteRuleController,testRewriteRuleController){this.dialog=dialog;this.addRewriteRuleController=addRewriteRuleController;this.editRewriteRuleController=editRewriteRuleController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rules,callback){this._initRules(rules);this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setRules(this.rules);},onSubmit:function(){this.dialog.hide();this.callback(this.rules);},onCancel:function(){this.dialog.hide();},onAddRule:function(){this.addRewriteRuleController.start(this.rules,$.proxy(this._ruleAdded,this));},onEditRule:function(rule){this.editRewriteRuleController.start(rule,$.proxy(this._ruleUpdated,this));},onTestRule:function(rule){this.testRewriteRuleController.start(rule);},onDeleteRule:function(rule){$.messager.confirm(jscape.Resources["deleteRewriteDialog.title"],jscape.Resources["deleteRewriteDialog.message"].supplant(rule),$.proxy(function(confirmed){if(confirmed){this._ruleDeleted(rule);}},this));},_initRules:function(rules){this.rules=[];var i;var rule;var copy;for(i=0;i<rules.length;++i){rule=rules[i];copy={name:rule.name,description:rule.description,findRegexp:rule.findRegexp,replaceRegexp:rule.replaceRegexp,scope:rule.scope,direction:rule.direction,replaceScope:rule.replaceScope};this.rules.push(copy);}},_ruleAdded:function(rule){this.rules.push(rule);this.dialog.setRules(this.rules);},_ruleUpdated:function(rule){var index=this._indexFor(rule.name);this.rules[index]=rule;this.dialog.setRules(this.rules);},_ruleDeleted:function(rule){var index=this._indexFor(rule.name);this.rules.splice(index,1);this.dialog.setRules(this.rules);},_indexFor:function(ruleName){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].name===ruleName){return i;}}
return-1;}});jscape.UrlRewriteRulesDialog=Class.extend({init:function(){this.dialog=$("#rewriteRulesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["rewriteRulesDialog.title"],width:jscape.Resources.intVal("rewriteRulesDialog.width"),height:jscape.Resources.intVal("rewriteRulesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.rulesTable=$("#rewriteRulesTable");this.rulesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.0"],sortable:true,width:20},{field:"scope",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.1"],sortable:true,width:20,formatter:function(value,row){return jscape.Resources["rewriteRule.scope."+row.scope];}},{field:"direction",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.2"],sortable:true,width:10,formatter:function(value,row){return jscape.Resources["rewriteRule.direction."+row.direction];}},{field:"replaceScope",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.3"],sortable:true,width:10,formatter:function(value,row){return jscape.Resources["rewriteRule.replaceScope."+row.replaceScope];}},{field:"findRegexp",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.4"],sortable:false,width:20},{field:"replaceRegexp",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.5"],sortable:false,width:20},{field:"ignoringSubsequentRulesRequired",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.6"],sortable:false,width:20,halign:"center",align:"center",formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});}},{field:"description",title:jscape.Resources["rewriteRulesDialog.rulesTable.column.7"],sortable:false,width:20}]],onSelect:$.proxy(this._ruleSelected,this),onSortColumn:$.proxy(this._resetButtons,this),onDblClickRow:$.proxy(function(index,rule){this.listener.onEditRule(rule);},this)});this.testRuleButton=$("#testRewriteRuleButton");this.testRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.testRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onTestRule(this.rule);}},this));this.addRuleButton=$("#addRewriteRuleButton");this.addRuleButton.linkbutton({width:jscape.Resources.buttonSize()});this.addRuleButton.click($.proxy(function(){this.listener.onAddRule();},this));this.editRuleButton=$("#editRewriteRuleButton");this.editRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onEditRule(this.rule);}},this));this.deleteRuleButton=$("#deleteRewriteRuleButton");this.deleteRuleButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteRuleButton.click($.proxy(function(){if(!this.testRuleButton.linkbutton("options").disabled){this.listener.onDeleteRule(this.rule);}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.rulesTable.datagrid("loadData",[]);},setRules:function(values){this.rulesTable.datagrid("loadData",values);this._resetButtons();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_ruleSelected:function(row,rule){this.row=row;this.rule=rule;this.testRuleButton.linkbutton("enable");this.editRuleButton.linkbutton("enable");this.deleteRuleButton.linkbutton("enable");},_resetButtons:function(){this.testRuleButton.linkbutton("disable");this.editRuleButton.linkbutton("disable");this.deleteRuleButton.linkbutton("disable");}});jscape.AddRewriteRuleController=Class.extend({init:function(dialog,rewriteRuleVariablesController,testRewriteRuleController){this.dialog=dialog;this.rewriteRuleVariablesController=rewriteRuleVariablesController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rules,callback){this.rules=rules;this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){this.dialog.hide();var rule=this._rule();this.callback(rule);},onCancel:function(){this.dialog.hide();},onAddVariable:function(){this.rewriteRuleVariablesController.start($.proxy(this._variableAdded,this));},onTestRule:function(){var rule=this._rule();this.testRewriteRuleController.start(rule);},ruleExists:function(name){var i;for(i=0;i<this.rules.length;++i){if(this.rules[i].name===name){return true;}}
return false;},_rule:function(){return{name:this.dialog.getName(),description:this.dialog.getDescription(),scope:this.dialog.getScope(),direction:this.dialog.getDirection(),findRegexp:this.dialog.getFindRegexp(),replaceRegexp:this.dialog.getReplaceRegexp(),replaceScope:this.dialog.getReplaceScope(),ignoringSubsequentRulesRequired:this.dialog.isExclusive()};},_variableAdded:function(variable){if(variable){this.dialog.setVariable("{"+variable+"}");}}});jscape.AddRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#addRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addRewriteRuleDialog.title"],width:jscape.Resources.intVal("addRewriteRuleDialog.width"),height:jscape.Resources.intVal("addRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onTest,this)},{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.nameField=$("#rewriteRuleNameField");this.nameField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyName.message"],validType:[requiredFieldRule("requiredAddRewriteRuleName",jscape.Resources["addRewriteRuleDialog.error.emptyName.message"]),validationRule("uniqueRuleName",$.proxy(function(value){return!this.listener.ruleExists(value);},this),jscape.Resources["addRewriteRuleDialog.error.nameExists.message"])]});this.nameField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.descriptionField=$("#rewriteRuleDescriptionField");this.descriptionField.textbox({});this.descriptionField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.ruleDirectionField=$("#addRewriteRuleDirectionField");this.ruleDirectionField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleScopeField=$("#addRewriteRuleScopeField");this.ruleScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleReplaceScopeField=$("#addRewriteRuleReplaceScopeField");this.ruleReplaceScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.findRegexpField=$("#rewriteRuleFindRegexpField");this.findRegexpField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyFindRegexp.message"],validType:requiredFieldRule("requiredAddFindRegex",jscape.Resources["addRewriteRuleDialog.error.emptyFindRegexp.message"])});this.findRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.findRegexpField;this.addVariableButton.linkbutton("enable");},this));this.findRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.findRegexpField[0].selectionEnd;},this));this.replaceRegexpField=$("#rewriteRuleReplaceRegexpField");this.replaceRegexpField.textbox({required:true,missingMessage:jscape.Resources["addRewriteRuleDialog.error.emptyReplaceRegexp.message"],validType:requiredFieldRule("requiredAddReplaceRegex",jscape.Resources["addRewriteRuleDialog.error.emptyReplaceRegexp.message"])});this.replaceRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.replaceRegexpField;this.addVariableButton.linkbutton("enable");},this));this.replaceRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.replaceRegexpField[0].selectionEnd;},this));this.exclusiveBox=$("#rewriteRuleExclusiveBox");this.addVariableButton=$("#rewriteRuleAddVariableButton");this.addVariableButton.linkbutton({width:jscape.Resources.intVal("addRewriteRuleDialog.addVariableButton.width"),disabled:true});this.addVariableButton.click($.proxy(function(){if(!this.addVariableButton.linkbutton("options").disabled){this.listener.onAddVariable();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this._clientServerButtonClick();this.nameField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.addVariableButton.linkbutton("disable");},setVariable:function(variable){if(this.currentVariableField){var currentText=this.currentVariableField.textbox("getValue");var insertPosition=this.currentVariableFieldPosition?this.currentVariableFieldPosition:this.currentVariableField[0].selectionEnd;var resultText=currentText.length>0&&insertPosition>=0?currentText.substring(0,insertPosition)+variable+currentText.substring(insertPosition):currentText+variable;this.currentVariableField.textbox("setValue",resultText);}},getName:function(){return this.nameField.textbox("getValue").trim();},getDescription:function(){return this.descriptionField.textbox("getValue").trim();},getDirection:function(){return this.ruleDirectionField.combobox("getValue");},getScope:function(){return this.ruleScopeField.combobox("getValue");},getReplaceScope:function(){return this.ruleReplaceScopeField.combobox("getValue");},getFindRegexp:function(){return this.findRegexpField.textbox("getValue").trim();},getReplaceRegexp:function(){return this.replaceRegexpField.textbox("getValue").trim();},isExclusive:function(){return this.exclusiveBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_onTest:function(){if(this.form.form("validate")){this.listener.onTestRule();}}});jscape.EditRewriteRuleController=Class.extend({init:function(dialog,rewriteRuleVariablesController,testRewriteRuleController){this.dialog=dialog;this.rewriteRuleVariablesController=rewriteRuleVariablesController;this.testRewriteRuleController=testRewriteRuleController;},start:function(rule,callback){this.rule=rule;this.callback=callback;this.dialog.reset();this.dialog.setName(this.rule.name);this.dialog.setDescription(this.rule.description);this.dialog.setDirection(this.rule.direction);this.dialog.setScope(this.rule.scope);this.dialog.setReplaceScope(this.rule.replaceScope);this.dialog.setFindRegexp(this.rule.findRegexp);this.dialog.setReplaceRegexp(this.rule.replaceRegexp);this.dialog.setExclusive(this.rule.ignoringSubsequentRulesRequired);this.dialog.show(this);},onSubmit:function(){this.dialog.hide();var rule=this._rule();this.callback(rule);},onCancel:function(){this.dialog.hide();},onAddVariable:function(){this.rewriteRuleVariablesController.start($.proxy(this._variableAdded,this));},onTestRule:function(){var rule=this._rule();this.testRewriteRuleController.start(rule);},_rule:function(){return{name:this.rule.name,description:this.dialog.getDescription(),scope:this.dialog.getScope(),direction:this.dialog.getDirection(),findRegexp:this.dialog.getFindRegexp(),replaceRegexp:this.dialog.getReplaceRegexp(),replaceScope:this.dialog.getReplaceScope(),ignoringSubsequentRulesRequired:this.dialog.isExclusive()};},_variableAdded:function(variable){if(variable){this.dialog.setVariable("{"+variable+"}");}}});jscape.EditRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#editRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editRewriteRuleDialog.title"],width:jscape.Resources.intVal("editRewriteRuleDialog.width"),height:jscape.Resources.intVal("editRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onTest,this)},{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.descriptionField=$("#editRewriteRuleDescriptionField");this.descriptionField.textbox({});this.descriptionField.textbox("textbox").bind("focus",$.proxy(function(){this.addVariableButton.linkbutton("disable");},this));this.ruleDirectionField=$("#editRewriteRuleDirectionField");this.ruleDirectionField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleScopeField=$("#editRewriteRuleScopeField");this.ruleScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.ruleReplaceScopeField=$("#editRewriteRuleReplaceScopeField");this.ruleReplaceScopeField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.findRegexpField=$("#editRewriteRuleFindRegexpField");this.findRegexpField.textbox({required:true,missingMessage:jscape.Resources["editRewriteRuleDialog.error.emptyFindRegexp.message"],validType:requiredFieldRule("requiredEditFindRegexp",jscape.Resources["editRewriteRuleDialog.error.emptyFindRegexp.message"])});this.findRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.findRegexpField;this.addVariableButton.linkbutton("enable");},this));this.findRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.findRegexpField[0].selectionEnd;},this));this.replaceRegexpField=$("#editRewriteRuleReplaceRegexpField");this.replaceRegexpField.textbox({required:true,missingMessage:jscape.Resources["editRewriteRuleDialog.error.emptyReplaceRegexp.message"],validType:requiredFieldRule("requiredEditReplaceRegexp",jscape.Resources["editRewriteRuleDialog.error.emptyReplaceRegexp.message"])});this.replaceRegexpField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.replaceRegexpField;this.addVariableButton.linkbutton("enable");},this));this.replaceRegexpField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.replaceRegexpField[0].selectionEnd;},this));this.exclusiveBox=$("#editRewriteRuleExclusiveBox");this.addVariableButton=$("#editRewriteRuleAddVariableButton");this.addVariableButton.linkbutton({width:jscape.Resources.intVal("editRewriteRuleDialog.addVariableButton.width"),disabled:true});this.addVariableButton.click($.proxy(function(){if(!this.addVariableButton.linkbutton("options").disabled){this.listener.onAddVariable();}},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.descriptionField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this.addVariableButton.linkbutton("disable");},setVariable:function(variable){if(this.currentVariableField){var currentText=this.currentVariableField.textbox("getValue");var insertPosition=this.currentVariableFieldPosition?this.currentVariableFieldPosition:this.currentVariableField[0].selectionEnd;var resultText=currentText.length>0&&insertPosition>=0?currentText.substring(0,insertPosition)+variable+currentText.substring(insertPosition):currentText+variable;this.currentVariableField.textbox("setValue",resultText);}},setName:function(value){this.dialog.dialog("setTitle",jscape.Resources["editRewriteRuleDialog.title"].supplant({name:value}));},getDescription:function(){return this.descriptionField.textbox("getValue").trim();},setDescription:function(value){this.descriptionField.textbox("setValue",value);},getDirection:function(){return this.ruleDirectionField.combobox("getValue");},setDirection:function(value){this.ruleDirectionField.combobox("setValue",value).combobox("select",value);},getScope:function(){return this.ruleScopeField.combobox("getValue");},setScope:function(value){this.ruleScopeField.combobox("setValue",value).combobox("select",value);},getReplaceScope:function(){return this.ruleReplaceScopeField.combobox("getValue");},setReplaceScope:function(value){this.ruleReplaceScopeField.combobox("setValue",value).combobox("select",value);},getFindRegexp:function(){return this.findRegexpField.textbox("getValue").trim();},setFindRegexp:function(value){this.findRegexpField.textbox("setValue",value);this.findRegexpField.textbox("validate");},getReplaceRegexp:function(){return this.replaceRegexpField.textbox("getValue").trim();},setReplaceRegexp:function(value){this.replaceRegexpField.textbox("setValue",value);this.replaceRegexpField.textbox("validate");},isExclusive:function(){return this.exclusiveBox.prop("checked");},setExclusive:function(value){this.exclusiveBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_onTest:function(){if(this.form.form("validate")){this.listener.onTestRule();}},_clientServerButtonClick:function(){this.requestUriScopeButton.removeAttr("disabled");this.requestUriScopeButton.prop("checked",true);this.contentScopeButton.attr("disabled",true);this.headersContentScopeButton.attr("disabled",true);},_serverClientButtonClick:function(){this.requestUriScopeButton.attr("disabled",true);this.headersScopeButton.prop("checked",true);this.contentScopeButton.removeAttr("disabled");this.headersContentScopeButton.removeAttr("disabled");},_anyDirectionButtonClick:function(){this.requestUriScopeButton.attr("disabled",true);this.headersScopeButton.prop("checked",true);this.contentScopeButton.attr("disabled",true);this.headersContentScopeButton.attr("disabled",true);}});jscape.RewriteRuleVariablesController=Class.extend({VARIABLES:[{name:"SERVER_IP"},{name:"SERVER_HOSTNAME"},{name:"SERVER_PORT"},{name:"CLIENT_IP"},{name:"CLIENT_PORT"},{name:"GATEWAY_OUTER_IP"},{name:"GATEWAY_OUTER_HOSTNAME"},{name:"GATEWAY_IP"},{name:"GATEWAY_PORT"}],init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setVariables(this.VARIABLES);},onSubmit:function(){this.dialog.hide();var variable=this.dialog.getVariable();this.callback(variable);},onCancel:function(){this.dialog.hide();}});jscape.RewriteRuleVariablesDialog=Class.extend({init:function(){this.dialog=$("#rewriteRuleVariablesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["rewriteRuleVariablesDialog.title"],width:jscape.Resources.intVal("rewriteRuleVariablesDialog.width"),height:jscape.Resources.intVal("rewriteRuleVariablesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.variablesTable=$("#rewriteRuleVariablesTable");this.variablesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",sortable:true,width:100}]],showHeader:false,onSelect:$.proxy(this._variableSelected,this),onDblClickRow:$.proxy($.proxy(this._onSubmit,this))});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.variablesTable.datagrid("loadData",[]);this.variable=null;},setVariables:function(values){this.variablesTable.datagrid("loadData",values);},getVariable:function(){return this.variable;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_variableSelected:function(row,variable){this.variable=variable.name;}});jscape.TestRewriteRuleController=Class.extend({init:function(dialog,testResultDialog){this.dialog=dialog;this.testResultDialog=testResultDialog;},start:function(rule){this.rule=rule;this.dialog.reset();this.dialog.setName(this.rule.name);this.dialog.setFindRegexp(this.rule.findRegexp);this.dialog.setReplaceRegexp(this.rule.replaceRegexp);this.dialog.show(this);},onSubmit:function(){var environment=this._environment();var findRegexp=this.rule.findRegexp.supplant(environment);var replaceRegexp=this.rule.replaceRegexp.supplant(environment);var content=this.dialog.getContent();var result=content.replace(new RegExp(findRegexp,"gm"),replaceRegexp);this.testResultDialog.reset();this.testResultDialog.setContent(result);this.testResultDialog.show(this);},onCancel:function(){this.dialog.hide();},onClose:function(){this.testResultDialog.hide();},_environment:function(){return{SERVER_IP:this._quote(this.dialog.getServerIp()),SERVER_HOSTNAME:this._quote(this.dialog.getServerHost()),SERVER_PORT:this.dialog.getServerPort(),CLIENT_IP:this._quote(this.dialog.getClientIp()),CLIENT_PORT:this.dialog.getClientPort(),GATEWAY_OUTER_IP:this._quote(this.dialog.getGatewayOuterIp()),GATEWAY_OUTER_HOSTNAME:this._quote(this.dialog.getGatewayOuterHost()),GATEWAY_IP:this._quote(this.dialog.getGatewayIp()),GATEWAY_PORT:this.dialog.getGatewayPort()};},_quote:function(value){return value.replace(/([.?*+\^$\[\]\\(){}|\-])/g,"\\$1");}});jscape.TestRewriteRuleDialog=Class.extend({init:function(){this.dialog=$("#testRewriteRuleDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["testRewriteRuleDialog.title"],width:jscape.Resources.intVal("testRewriteRuleDialog.width"),height:jscape.Resources.intVal("testRewriteRuleDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.findRegexpField=$("#findRegexpField");this.findRegexpField.textbox({});this.replaceRegexpField=$("#replaceRegexpField");this.replaceRegexpField.textbox({});this.serverIpField=$("#serverIpField");this.serverIpField.textbox({});this.serverHostField=$("#serverHostField");this.serverHostField.textbox({});this.serverPortField=$("#serverPortField");this.serverPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyServerPort.message"]});this.clientIpField=$("#clientIpField");this.clientIpField.textbox({});this.clientPortField=$("#clientPortField");this.clientPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyClientPort.message"]});this.gatewayOuterIpField=$("#gatewayOuterIpField");this.gatewayOuterIpField.textbox({});this.gatewayOuterHostField=$("#gatewayOuterHostField");this.gatewayOuterHostField.textbox({});this.gatewayIpField=$("#gatewayIpField");this.gatewayIpField.textbox({});this.gatewayPortField=$("#gatewayPortField");this.gatewayPortField.numberspinner({min:1,max:65535,value:80,increment:1,required:true,missingMessage:jscape.Resources["testRewriteRuleDialog.error.emptyGatewayPort.message"]});this.contentField=$("#contentField");this.contentField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.serverIpField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setName:function(value){this.dialog.dialog("setTitle",jscape.Resources["testRewriteRuleDialog.title"].supplant({name:value}));},setFindRegexp:function(value){this.findRegexpField.textbox("setValue",value);},setReplaceRegexp:function(value){this.replaceRegexpField.textbox("setValue",value);},getServerIp:function(){return this.serverIpField.textbox("getValue").trim();},getServerHost:function(){return this.serverHostField.textbox("getValue").trim();},getServerPort:function(){return this.serverPortField.numberspinner("getValue");},getClientIp:function(){return this.clientIpField.textbox("getValue").trim();},getClientPort:function(){return this.clientPortField.numberspinner("getValue");},getGatewayOuterIp:function(){return this.gatewayOuterIpField.textbox("getValue").trim();},getGatewayOuterHost:function(){return this.gatewayOuterHostField.textbox("getValue").trim();},getGatewayIp:function(){return this.gatewayIpField.textbox("getValue").trim();},getGatewayPort:function(){return this.gatewayPortField.numberspinner("getValue");},getContent:function(){return this.contentField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.TestRuleResultDialog=Class.extend({init:function(){this.dialog=$("#testRuleResultDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["testRuleResultDialog.title"],width:jscape.Resources.intVal("testRuleResultDialog.width"),height:jscape.Resources.intVal("testRuleResultDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.close.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onClose,this)}],onClose:$.proxy(this._onClose,this),closed:true});this.form=this.dialog.find("form");this.contentField=$("#resultContentField");this.contentField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setContent:function(value){this.contentField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onClose:function(){this.listener.onClose();}});