/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.MonitorController=Class.extend({init:function(page,changeMonitorConfigurationController){this.page=page;this.changeMonitorConfigurationController=changeMonitorConfigurationController;},start:function(){jscape.OPERATION_SERVICE.monitorServiceConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeMonitorConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setStatus(this.configuration.enabled);this.page.setInterval(this.configuration.interval);this.page.setAttempts(this.configuration.attempts);this.page.setHostNotification(this.configuration.emailAlert?this.configuration.emailAlert.recipient:null);this.page.setAgentNotification(this.configuration.agentEmailAlert?this.configuration.agentEmailAlert.recipient:null);}});jscape.MonitorPage=Class.extend({TIME_FACTOR:1000,init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.monitorStatusField=$("#monitorStatusField");this.monitorIntervalField=$("#monitorIntervalField");this.monitorAttemptsField=$("#monitorAttemptsField");this.monitorHostNotificationField=$("#monitorHostNotificationField");this.monitorAgentNotificationField=$("#monitorAgentNotificationField");this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},setStatus:function(value){this.monitorStatusField.text(value?jscape.Resources["enabled"]:jscape.Resources["disabled"]);},setInterval:function(value){this.monitorIntervalField.text(jscape.Resources["monitorPage.intervalField.text"].supplant({value:value/this.TIME_FACTOR}));},setAttempts:function(value){this.monitorAttemptsField.text(jscape.Resources["monitorPage.attemptsField.text"].supplant({value:value}));},setHostNotification:function(value){this.monitorHostNotificationField.text(value?value:jscape.Resources["disabled"]);},setAgentNotification:function(value){this.monitorAgentNotificationField.text(value?value:jscape.Resources["disabled"]);},_onChange:function(){this.listener.onChange();}});jscape.ChangeMonitorConfigurationController=Class.extend({DEFAULT_HOST_ALERT:{recipient:"",subject:"%Protocol% Service Failure Notification",body:"The %Protocol% service running on host %Host% and port %Port% does not meet health monitor criteria."},DEFAULT_AGENT_ALERT:{recipient:"",subject:"JSCAPE MFT Gateway - No Available Agents",body:"The JSCAPE MFT Gateway %Protocol% reverse proxy service running on host %Host% and port %Port% currently has no available agents to service requests."},init:function(dialog,alertDetailsController){this.dialog=dialog;this.alertDetailsController=alertDetailsController;},start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.monitorServiceConfiguration($.proxy(this._configurationLoaded,this));},onChangeHostEmailAlertDetails:function(){this.alertDetailsController.start(this.hostAlert);},onChangeAgentEmailAlertDetails:function(){this.alertDetailsController.start(this.agentAlert);},onSubmit:function(){if(this.dialog.getHostNotificationRecipient()){this.hostAlert.recipient=this.dialog.getHostNotificationRecipient();}
if(this.dialog.getAgentNotificationRecipient()){this.agentAlert.recipient=this.dialog.getAgentNotificationRecipient();}
var configuration={interval:this.dialog.getInterval(),attempts:this.dialog.getAttempts(),emailAlert:this.dialog.getHostNotificationRecipient()?this.hostAlert:null,agentEmailAlert:this.dialog.getAgentNotificationRecipient()?this.agentAlert:null,enabled:this.dialog.isEnabled(),version:this.configuration.version};jscape.OPERATION_SERVICE.updateMonitorServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.hostAlert=$.extend({},this.configuration.emailAlert||this.DEFAULT_HOST_ALERT);this.agentAlert=$.extend({},this.configuration.agentEmailAlert||this.DEFAULT_AGENT_ALERT);this.dialog.reset();this.dialog.setInterval(this.configuration.interval);this.dialog.setAttempts(this.configuration.attempts);this.dialog.setHostNotification(this.configuration.emailAlert?this.configuration.emailAlert:null);this.dialog.setAgentNotification(this.configuration.agentEmailAlert?this.configuration.agentEmailAlert:null);this.dialog.setEnabled(this.configuration.enabled);this.dialog.show(this);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["monitorServiceConfigurationAppliedDialog.title"],jscape.Resources["monitorServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));}});jscape.ChangeMonitorConfigurationDialog=Class.extend({TIME_FACTOR:1000,init:function(){this.dialog=$("#monitorConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["monitorConfigurationDialog.title"],width:jscape.Resources.intVal("monitorConfigurationDialog.width"),height:jscape.Resources.intVal("monitorConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.intervalField=$("#intervalField");this.intervalField.numberspinner({min:1,max:999999,value:60,increment:1,required:true,missingMessage:jscape.Resources["monitorConfigurationDialog.error.emptyInterval.message"]});this.attemptsField=$("#attemptsField");this.attemptsField.numberspinner({min:1,max:99,value:3,increment:1,required:true,missingMessage:jscape.Resources["monitorConfigurationDialog.error.emptyRetry.message"]});this.hostNotificationBox=$("#hostNotificationBox");this.hostNotificationBox.click($.proxy(this._hostNotificationBoxClicked,this));this.hostRecipientField=$("#hostRecipientField");this.hostRecipientField.textbox({required:true,validType:"email",missingMessage:jscape.Resources["monitorConfigurationDialog.error.emptyHostNotificationRecipient.message"]});this.hostEmailDetailsButton=$("#hostEmailDetailsButton");this.hostEmailDetailsButton.linkbutton({width:jscape.Resources.buttonSize()});this.hostEmailDetailsButton.click($.proxy(function(){if(!this.hostEmailDetailsButton.linkbutton("options").disabled){this.listener.onChangeHostEmailAlertDetails();}},this));this.agentNotificationBox=$("#agentNotificationBox");this.agentNotificationBox.click($.proxy(this._agentNotificationBoxClicked,this));this.agentRecipientField=$("#agentRecipientField");this.agentRecipientField.textbox({required:true,validType:"email",missingMessage:jscape.Resources["monitorConfigurationDialog.error.emptyAgentNotificationRecipient.message"]});this.agentEmailDetailsButton=$("#agentEmailDetailsButton");this.agentEmailDetailsButton.linkbutton({width:jscape.Resources.buttonSize()});this.agentEmailDetailsButton.click($.proxy(function(){if(!this.agentEmailDetailsButton.linkbutton("options").disabled){this.listener.onChangeAgentEmailAlertDetails();}},this));this.enabledBox=$("#enabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.intervalField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getInterval:function(){return parseInt(this.intervalField.numberspinner("getValue"),10)*this.TIME_FACTOR;},setInterval:function(value){this.intervalField.numberspinner("setValue",value/this.TIME_FACTOR);},getAttempts:function(){return parseInt(this.attemptsField.numberspinner("getValue"),10);},setAttempts:function(value){this.attemptsField.numberspinner("setValue",value);},getHostNotificationRecipient:function(){return this.hostNotificationBox.prop("checked")?this.hostRecipientField.textbox("getValue").trim():null;},setHostNotification:function(value){if(value){this.hostNotificationBox.prop("checked",true);this.hostRecipientField.textbox("setValue",value.recipient);this.hostRecipientField.textbox("validate");}
this._hostNotificationBoxClicked();},getAgentNotificationRecipient:function(){return this.agentNotificationBox.prop("checked")?this.agentRecipientField.textbox("getValue").trim():null;},setAgentNotification:function(value){if(value){this.agentNotificationBox.prop("checked",true);this.agentRecipientField.textbox("setValue",value.recipient);this.agentRecipientField.textbox("validate");}
this._agentNotificationBoxClicked();},isEnabled:function(){return this.enabledBox.prop("checked");},setEnabled:function(value){this.enabledBox.prop("checked",value);},_hostNotificationBoxClicked:function(){var enabled=this.hostNotificationBox.prop("checked");this.hostRecipientField.textbox(enabled?"enable":"disable");this.hostRecipientField.textbox(enabled?"enableValidation":"disableValidation");this.hostEmailDetailsButton.linkbutton(enabled?"enable":"disable");},_agentNotificationBoxClicked:function(){var enabled=this.agentNotificationBox.prop("checked");this.agentRecipientField.textbox(enabled?"enable":"disable");this.agentRecipientField.textbox(enabled?"enableValidation":"disableValidation");this.agentEmailDetailsButton.linkbutton(enabled?"enable":"disable");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.AlertDetailsController=Class.extend({init:function(dialog,variableController){this.dialog=dialog;this.variableController=variableController;},start:function(alert){this.alert=alert;this.dialog.reset();this.dialog.setSubject(this.alert.subject);this.dialog.setMessage(this.alert.body);this.dialog.show(this);},onAddVariable:function(){this.variableController.start($.proxy(this._variableAdded,this));},onSubmit:function(){this.alert.subject=this.dialog.getSubject();this.alert.body=this.dialog.getMessage();this.dialog.hide();},onCancel:function(){this.dialog.hide();},_variableAdded:function(variable){if(variable){this.dialog.setVariable("%"+variable+"%");}}});jscape.AlertDetailsDialog=Class.extend({init:function(){this.dialog=$("#alertDetailsDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["alertDetailsDialog.title"],width:jscape.Resources.intVal("alertDetailsDialog.width"),height:jscape.Resources.intVal("alertDetailsDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.subjectField=$("#alertDetailsSubjectField");this.subjectField.textbox({});this.subjectField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.subjectField;},this));this.subjectField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.subjectField[0].selectionEnd;},this));this.messageField=$("#alertDetailsMessageField");this.messageField.textbox({multiline:true,height:120});this.messageField.textbox("textbox").bind("focus",$.proxy(function(){this.currentVariableField=this.messageField;},this));this.messageField.textbox("textbox").bind("blur",$.proxy(function(){this.currentVariableFieldPosition=this.messageField[0].selectionEnd;},this));this.addVariableButton=$("#alertDetailsAddVariableButton");this.addVariableButton.linkbutton({width:jscape.Resources.intVal("alertDetailsDialog.addVariableButton.width")});this.addVariableButton.click($.proxy(function(){this.listener.onAddVariable();},this));},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.subjectField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setVariable:function(variable){if(this.currentVariableField){var currentText=this.currentVariableField.textbox("getValue");var insertPosition=this.currentVariableFieldPosition?this.currentVariableFieldPosition:this.currentVariableField[0].selectionEnd;var resultText=currentText.length>0&&insertPosition>=0?currentText.substring(0,insertPosition)+variable+currentText.substring(insertPosition):currentText+variable;this.currentVariableField.textbox("setValue",resultText);}},getSubject:function(){return this.subjectField.textbox("getValue").trim();},setSubject:function(value){this.subjectField.textbox("setValue",value);},getMessage:function(){return this.messageField.textbox("getValue").trim();},setMessage:function(value){this.messageField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();}});jscape.AlertVariablesController=Class.extend({VARIABLES:[{name:"Host"},{name:"Port"},{name:"Protocol"},{name:"Date"}],init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);this.dialog.setVariables(this.VARIABLES);},onSubmit:function(){this.dialog.hide();var variable=this.dialog.getVariable();this.callback(variable);},onCancel:function(){this.dialog.hide();}});jscape.AlertVariablesDialog=Class.extend({init:function(){this.dialog=$("#alertVariablesDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["alertVariablesDialog.title"],width:jscape.Resources.intVal("alertVariablesDialog.width"),height:jscape.Resources.intVal("alertVariablesDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.variablesTable=$("#alertVariablesTable");this.variablesTable.datagrid({singleSelect:true,fitColumns:true,remoteSort:false,columns:[[{field:"name",width:100,sortable:true}]],showHeader:false,onSelect:$.proxy(this._variableSelected,this),onDblClickRow:$.proxy($.proxy(this._onSubmit,this))});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.variablesTable.datagrid("loadData",[]);this.variable=null;},setVariables:function(values){this.variablesTable.datagrid("loadData",values);},getVariable:function(){return this.variable;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){this.listener.onSubmit();},_onCancel:function(){this.listener.onCancel();},_variableSelected:function(row,variable){this.variable=variable.name;}});