/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.LoggingController=Class.extend({init:function(page,controllers){this.page=page;this.controllers=controllers;},start:function(){this.page.show(this);$.each(this.controllers,function(index,controller){controller.start();});},onTabVisible:function(index){this.controllers[index].onVisible();}});jscape.LoggingPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true,onSelect:$.proxy(function(title,index){if(this.listener){this.listener.onTabVisible(index);}},this)});},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");},selectTab:function(index){this.infoPanel.tabs("select",index);}});jscape.LogServiceController=Class.extend({init:function(panel,changeLoggingConfigurationController){this.panel=panel;this.changeLoggingConfigurationController=changeLoggingConfigurationController;},start:function(){jscape.OPERATION_SERVICE.logServiceConfiguration($.proxy(this._configurationLoaded,this));},onVisible:function(){},onChange:function(){this.changeLoggingConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPanel();this.panel.show(this);},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPanel();},_initPanel:function(){this.panel.setType(this.configuration.type);if(this.configuration.fileRepositoryConfiguration){this.panel.setLogDirectory(this.configuration.fileRepositoryConfiguration.logDirectory);this.panel.setFileRotationType(this.configuration.fileRepositoryConfiguration.fileRotationType);}else if(this.configuration.databaseRepositoryConfiguration){this.panel.setDbUrl(this.configuration.databaseRepositoryConfiguration.url);this.panel.setDbUsername(this.configuration.databaseRepositoryConfiguration.username);this.panel.setConnectionPoolSize(this.configuration.databaseRepositoryConfiguration.connectionPoolSize);this.panel.setConnectionTtl(this.configuration.databaseRepositoryConfiguration.connectionIdleTimeMillis);}}});jscape.LogServicePanel=Class.extend({init:function(){this.fileLogServicePanel=$("#fileLogServicePanel");this.logDirectoryField=$("#logDirectoryField");this.rotationField=$("#rotationField");this.dbLogServicePanel=$("#dbLogServicePanel");this.dbUrlField=$("#dbUrlField");this.dbUsernameField=$("#dbUsernameField");this.dbConnectionPoolSizeField=$("#dbConnectionPoolSizeField");this.dbConnectionTtlField=$("#dbConnectionTtlField");this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;},setType:function(value){if("FILE"===value){this.fileLogServicePanel.show();this.dbLogServicePanel.hide();}else if("DATABASE"===value){this.fileLogServicePanel.hide();this.dbLogServicePanel.show();}},setLogDirectory:function(value){this.logDirectoryField.text(value);},setFileRotationType:function(value){this.rotationField.text(jscape.Resources["fileRotationType."+value]);},setDbUrl:function(value){this.dbUrlField.text(value);},setDbUsername:function(value){this.dbUsernameField.text(value);},setConnectionPoolSize:function(value){this.dbConnectionPoolSizeField.text(value);},setConnectionTtl:function(value){this.dbConnectionTtlField.text(jscape.Resources["logServicePanel.dbTtlField.text"].supplant({value:value}));},_onChange:function(){this.listener.onChange();}});jscape.ChangeLoggingConfigurationController=Class.extend({init:function(dialog,fileConfigurationController,databaseConfigurationController){this.dialog=dialog;this.fileConfigurationController=fileConfigurationController;this.databaseConfigurationController=databaseConfigurationController;},start:function(callback){this.callback=callback;jscape.OPERATION_SERVICE.logServiceConfiguration($.proxy(this._configurationLoaded,this));},onSubmit:function(){this.dialog.hide();var type=this.dialog.getType();if("FILE"===type){this.fileConfigurationController.start(this.configuration,this.callback);}else if("DATABASE"===type){this.databaseConfigurationController.start(this.configuration,this.callback);}},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setType(this.configuration.type);this.dialog.show(this);}});jscape.ServiceTypeDialog=Class.extend({init:function(){this.dialog=$("#logServiceTypeDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["logServiceTypeDialog.title"],width:jscape.Resources.intVal("logServiceTypeDialog.width"),height:jscape.Resources.intVal("logServiceTypeDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.ok.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.typeBox=$("#typeBox");this.typeBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.typeBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getType:function(){return this.typeBox.combobox("getValue");},setType:function(value){this.typeBox.combobox("setValue",value).combobox("select",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.FileConfigurationController=Class.extend({init:function(dialog,selectLogDirectoryController){this.dialog=dialog;this.selectLogDirectoryController=selectLogDirectoryController;},start:function(configuration,callback){this.configuration=configuration;this.callback=callback;this.dialog.reset();if(this.configuration.fileRepositoryConfiguration){this.dialog.setLogDirectory(this.configuration.fileRepositoryConfiguration.logDirectory);this.dialog.setFileRotationType(this.configuration.fileRepositoryConfiguration.fileRotationType);this.dialog.setMaxFileSize(this.configuration.fileRepositoryConfiguration.maxFileSizeBytes);}
this.dialog.show(this);},onSelectLogDirectory:function(){this.selectLogDirectoryController.selectDirectory($.proxy(function(entry,path){this.dialog.setLogDirectory(path);},this));},onSubmit:function(){var configuration={type:"FILE",fileRepositoryConfiguration:{logDirectory:this.dialog.getLogDirectory(),fileRotationType:this.dialog.getFileRotationType(),maxFileSizeBytes:this.dialog.getMaxFileSize()},version:this.configuration.version};jscape.OPERATION_SERVICE.updateLogServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["logServiceConfigurationAppliedDialog.title"],jscape.Resources["logServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));}});jscape.FileConfigurationDialog=Class.extend({SIZE_FACTOR:1024*1024,init:function(){this.dialog=$("#logFileConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["logFileConfigurationDialog.title"],width:jscape.Resources.intVal("logFileConfigurationDialog.width"),height:jscape.Resources.intVal("logFileConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.logDirectoryField=$("#fileLogDirectoryField");this.logDirectoryField.textbox({required:true,missingMessage:jscape.Resources["logFileConfigurationDialog.error.emptyLogDirectory.message"],validType:requiredFieldRule("requiredLogDirectory",jscape.Resources["logFileConfigurationDialog.error.emptyLogDirectory.message"])});this.selectLogDirectoryButton=$("#selectLogDirectoryButton");this.selectLogDirectoryButton.linkbutton({width:jscape.Resources.intVal("button.browse.width"),height:jscape.Resources.intVal("button.browse.height")});this.selectLogDirectoryButton.click($.proxy(function(){this.listener.onSelectLogDirectory();},this));this.dailyButton=$("#dailyButton");this.dailyButton.click($.proxy(function(){this.fileSizeField.numberspinner("disable");},this));this.weeklyButton=$("#weeklyButton");this.weeklyButton.click($.proxy(function(){this.fileSizeField.numberspinner("disable");},this));this.monthlyButton=$("#monthlyButton");this.monthlyButton.click($.proxy(function(){this.fileSizeField.numberspinner("disable");},this));this.sizeButton=$("#sizeButton");this.sizeButton.click($.proxy(function(){this.fileSizeField.numberspinner("enable");},this));this.fileSizeField=$("#sizeField");this.fileSizeField.numberspinner({min:1,max:99999,value:10,increment:1,disabled:true});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.logDirectoryField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getLogDirectory:function(){return this.logDirectoryField.textbox("getValue").trim();},setLogDirectory:function(value){this.logDirectoryField.textbox("setValue",value);this.logDirectoryField.textbox("validate");},getFileRotationType:function(){if(this.dailyButton.prop("checked")){return"DAILY";}else if(this.weeklyButton.prop("checked")){return"WEEKLY";}else if(this.monthlyButton.prop("checked")){return"MONTHLY";}else{return"MAX_SIZE";}},setFileRotationType:function(value){if("DAILY"===value){this.dailyButton.prop("checked",true);}else if("WEEKLY"===value){this.weeklyButton.prop("checked",true);}else if("MONTHLY"===value){this.monthlyButton.prop("checked",true);}else{this.sizeButton.prop("checked",true);}},getMaxFileSize:function(){return this.sizeButton.prop("checked")?this.fileSizeField.numberspinner("getValue")*this.SIZE_FACTOR:null;},setMaxFileSize:function(value){this.fileSizeField.numberspinner("setValue",value/this.SIZE_FACTOR);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.DatabaseConfigurationController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(configuration,callback){this.configuration=configuration;this.callback=callback;this.dialog.reset();if(this.configuration.databaseRepositoryConfiguration){this.dialog.setUrl(this.configuration.databaseRepositoryConfiguration.url);this.dialog.setUsername(this.configuration.databaseRepositoryConfiguration.username);this.dialog.setPassword(this.configuration.databaseRepositoryConfiguration.password);this.dialog.setPoolSize(this.configuration.databaseRepositoryConfiguration.connectionPoolSize);this.dialog.setTtl(this.configuration.databaseRepositoryConfiguration.connectionIdleTimeMillis);}
this.dialog.show(this);},onCreate:function(){var configuration=this._configuration();jscape.OPERATION_SERVICE.initLogServiceRepository(configuration,$.proxy(this._databaseCreated,this));},onTest:function(){var configuration=this._configuration();jscape.OPERATION_SERVICE.testLogServiceConfiguration(configuration,$.proxy(this._testPassed,this));},onSubmit:function(){var configuration=this._configuration();jscape.OPERATION_SERVICE.updateLogServiceConfiguration(configuration,$.proxy(this._configurationUpdated,this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_configurationUpdated:function(configuration){this.dialog.hide();$.messager.alert(jscape.Resources["logServiceConfigurationAppliedDialog.title"],jscape.Resources["logServiceConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));},_configuration:function(){return{type:"DATABASE",databaseRepositoryConfiguration:{url:this.dialog.getUrl(),username:this.dialog.getUsername(),password:this.dialog.getPassword(),connectionPoolSize:this.dialog.getPoolSize(),connectionIdleTimeMillis:this.dialog.getTtl()},version:this.configuration.version};},_databaseCreated:function(){$.messager.alert(jscape.Resources["logDatabaseConfigurationDialog.createdDialog.title"],jscape.Resources["logDatabaseConfigurationDialog.createdDialog.message"],"info");},_testPassed:function(){$.messager.alert(jscape.Resources["logDatabaseConfigurationDialog.testDialog.title"],jscape.Resources["logDatabaseConfigurationDialog.testDialog.message"],"info");}});jscape.DatabaseConfigurationDialog=Class.extend({TIME_FACTOR:1000*60,init:function(){this.dialog=$("#logDatabaseConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["logDatabaseConfigurationDialog.title"],width:jscape.Resources.intVal("logDatabaseConfigurationDialog.width"),height:jscape.Resources.intVal("logDatabaseConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.create.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCreate,this)},{text:jscape.Resources["button.test.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onTest,this)},{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.urlField=$("#databaseUrlField");this.urlField.textbox({required:true,missingMessage:jscape.Resources["logDatabaseConfigurationDialog.error.emptyUrl.message"],validType:requiredFieldRule("requiredDbUrl",jscape.Resources["logDatabaseConfigurationDialog.error.emptyUrl.message"])});this.usernameField=$("#databaseUsernameField");this.usernameField.textbox({});this.passwordField=$("#databasePasswordField");this.passwordField.passwordbox({});this.poolSizeField=$("#databasePoolSizeField");this.poolSizeField.numberspinner({min:1,max:999,value:10,increment:1,required:true,missingMessage:jscape.Resources["logDatabaseConfigurationDialog.error.emptyPool.message"]});this.ttlField=$("#databaseTtlField");this.ttlField.numberspinner({min:1,max:999,value:1,increment:1,required:true,missingMessage:jscape.Resources["logDatabaseConfigurationDialog.error.emptyTtl.message"]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.urlField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getUrl:function(){return this.urlField.textbox("getValue").trim();},setUrl:function(value){this.urlField.textbox("setValue",value);this.urlField.textbox("validate");},getUsername:function(){return this.usernameField.textbox("getValue").trim();},setUsername:function(value){this.usernameField.textbox("setValue",value);},getPassword:function(){return this.passwordField.passwordbox("getValue");},setPassword:function(value){this.passwordField.passwordbox("setValue",value);},getPoolSize:function(){return parseInt(this.poolSizeField.numberspinner("getValue"),10);},setPoolSize:function(value){this.poolSizeField.numberspinner("setValue",value);},getTtl:function(){return parseInt(this.ttlField.numberspinner("getValue"),10)*this.TIME_FACTOR;},setTtl:function(value){this.ttlField.numberspinner("setValue",value/this.TIME_FACTOR);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onCreate:function(){if(this.form.form("validate")){this.listener.onCreate();}},_onTest:function(){if(this.form.form("validate")){this.listener.onTest();}},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.CurrentLogController=Class.extend({init:function(panel,autoUpdateInterval){this.panel=panel;this.autoUpdateInterval=autoUpdateInterval;},start:function(){this.panel.show(this);this._updateLog();},onVisible:function(){},_updateLog:function(){jscape.OPERATION_SERVICE.latestLogRecords(this.panel.getRecordsCount(),$.proxy(this._logUpdated,this));},_logUpdated:function(records){this.panel.setRecords(records);this._scheduleNextLogUpdate();},_scheduleNextLogUpdate:function(){setTimeout($.proxy(this._updateLog,this),this.autoUpdateInterval);}});jscape.CurrentLogPanel=Class.extend({init:function(){this.recordsField=$("#recordsField");this.recordsField.numberspinner({min:1,max:999,value:100,increment:10,required:true,missingMessage:jscape.Resources["loggingPage.error.emptyRecords.message"]});this.logArea=$("#logArea");},show:function(listener){this.listener=listener;},getRecordsCount:function(){var value=parseInt(this.recordsField.numberspinner("getValue"),10);return!isNaN(value)?value:100;},setRecords:function(value){var text="";$.each(value,function(index,record){var data={date:DateFormat.formatPattern("{yyyy}-{MM}-{dd} {HH}:{mm}:{ss}",record.date),serverHost:record.serverHost?record.serverHost:"-",serverPort:record.serverPort?record.serverPort:"-",clientHost:record.clientHost?record.clientHost:"-",clientPort:record.clientPort?record.clientPort:"-",username:record.username?record.username:"-",clientRequest:record.clientRequest?record.clientRequest:"-",clientMessage:record.clientMessage?v.clientMessage:"-",serverStatus:record.serverStatus?record.serverStatus:"-",serverMessage:record.serverMessage?record.serverMessage:"-",inboundBytes:record.inboundBytes?record.inboundBytes:"-",outboundBytes:record.outboundBytes?record.outboundBytes:"-"};text+="{date} {serverHost} {serverPort} {clientHost} {clientPort} {username} {clientRequest} {clientMessage} {serverStatus} {serverMessage} {inboundBytes} {outboundBytes}\r\n".supplant(data);});this.logArea.text(text);}});