/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.KeysController=Class.extend({init:function(page,generateKeyController,importKeyController,keyDetailsController,importCertificateController,generateCertificateController,exportKeyController,deleteKeyController){this.page=page;this.generateKeyController=generateKeyController;this.importKeyController=importKeyController;this.keyDetailsController=keyDetailsController;this.importCertificateController=importCertificateController;this.generateCertificateController=generateCertificateController;this.exportKeyController=exportKeyController;this.deleteKeyController=deleteKeyController;},start:function(){this.page.show(this);},onReload:function(request,successCallback){jscape.OPERATION_SERVICE.serverKeysFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onGenerateKey:function(){this.generateKeyController.start($.proxy(function(){this.page.reload();},this));},onImportKey:function(){this.importKeyController.start($.proxy(function(){this.page.reload();},this));},onShowKeyDetails:function(summary){this.keyDetailsController.start(summary);},onImportCertificate:function(summary){this.importCertificateController.start(summary,$.proxy(function(){this.page.reload();},this));},onGenerateCertificate:function(summary){this.generateCertificateController.start(summary,$.proxy(function(){this.page.reload();},this));},onGenerateCsr:function(summary){jscape.OPERATION_SERVICE.serverKeyCsrFor(summary.name);},onExportKey:function(summary){this.exportKeyController.start(summary);},onDeleteKeys:function(summaries){this.deleteKeyController.start(summaries,$.proxy(function(){this.page.reload();},this));}});jscape.KeysPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.keysTable=$("#keysTable");this.keysTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"name",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"name",title:jscape.Resources["keysPage.keysTable.column.0"],width:20,halign:"left",align:"left",sortable:true,searchable:true},{field:"keyAlgorithm",title:jscape.Resources["keysPage.keysTable.column.1"],width:10,halign:"left",align:"left",sortable:true,searchable:true},{field:"keySize",title:jscape.Resources["keysPage.keysTable.column.2"],width:10,halign:"right",align:"right",sortable:true,searchable:true},{field:"certificateSerialNumber",title:jscape.Resources["keysPage.keysTable.column.3"],width:20,halign:"left",align:"left",sortable:true,searchable:true,formatter:function(value,row){return"{value}(0x{hexValue})".supplant({value:row.certificateSerialNumber,hexValue:row.certificateSerialNumberHex});}},{field:"certificateIssuer",title:jscape.Resources["keysPage.keysTable.column.4"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"certificateSubject",title:jscape.Resources["keysPage.keysTable.column.5"],width:40,halign:"left",align:"left",sortable:true,searchable:true},{field:"certificateBeginDate",title:jscape.Resources["keysPage.keysTable.column.6"],width:20,halign:"right",align:"right",sortable:true,searchable:true,formatter:function(value,row){var dateString=DateFormat.formatShort(row.certificateBeginDate);return row.certificateBeginDate>new Date().getTime()?"<span style='color:red;'>{value}</span>".supplant({value:dateString}):dateString;},finder:"datebox"},{field:"certificateEndDate",title:jscape.Resources["keysPage.keysTable.column.7"],width:20,halign:"right",align:"right",sortable:true,searchable:true,formatter:function(value,row){var dateString=DateFormat.formatShort(row.certificateEndDate);return row.certificateEndDate<new Date().getTime()?"<span style='color:red;'>{value}</span>".supplant({value:dateString}):dateString;},finder:"datebox"}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onShowKeyDetails(this.rowValue);},this)});this.generateKeyButton=$("#generateKeyButton");this.generateKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.generateKeyButton.click($.proxy(function(){this.listener.onGenerateKey();},this));this.importKeyButton=$("#importKeyButton");this.importKeyButton.linkbutton({width:jscape.Resources.buttonSize()});this.importKeyButton.click($.proxy(function(){this.listener.onImportKey();},this));this.keyDetailsButton=$("#keyDetailsButton");this.keyDetailsButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.keyDetailsButton.click($.proxy(function(){if(!this.keyDetailsButton.linkbutton("options").disabled){this.listener.onShowKeyDetails(this.rowValue);}},this));this.importCertificateButton=$("#importCertificateButton");this.importCertificateButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.importCertificateButton.width"),disabled:true});this.importCertificateButton.click($.proxy(function(){if(!this.importCertificateButton.linkbutton("options").disabled){this.listener.onImportCertificate(this.rowValue);}},this));this.generateCertificateButton=$("#generateCertificateButton");this.generateCertificateButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.generateCertificateButton.width"),disabled:true});this.generateCertificateButton.click($.proxy(function(){if(!this.importCertificateButton.linkbutton("options").disabled){this.listener.onGenerateCertificate(this.rowValue);}},this));this.generateCsrButton=$("#generateCsrButton");this.generateCsrButton.linkbutton({width:jscape.Resources.intVal("keysPage.serverKeysTab.generateCsrButton.width"),disabled:true});this.generateCsrButton.click($.proxy(function(){if(!this.generateCsrButton.linkbutton("options").disabled){this.listener.onGenerateCsr(this.rowValue);}},this));this.exportKeyButton=$("#exportKeyButton");this.exportKeyButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.exportKeyButton.click($.proxy(function(){if(!this.exportKeyButton.linkbutton("options").disabled){this.listener.onExportKey(this.rowValue);}},this));this.deleteKeyButton=$("#deleteKeyButton");this.deleteKeyButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteKeyButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");this.keysTable.datagrid("reload");},reload:function(){this.keysTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;if(this.rowValue){this.keyDetailsButton.linkbutton("enable");this.importCertificateButton.linkbutton("enable");this.generateCertificateButton.linkbutton("enable");this.generateCsrButton.linkbutton("enable");this.exportKeyButton.linkbutton("enable");this.deleteKeyButton.linkbutton("enable");}},_rowUnselected:function(){if(this.keysTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.keysTable.datagrid("options").pageNumber;if(pageNumber>1){this.keysTable.datagrid("gotoPage",pageNumber-1);}}},_delete:function(){var values=this.keysTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteKeys(values);}},_resetButtons:function(){this.keyDetailsButton.linkbutton("disable");this.importCertificateButton.linkbutton("disable");this.generateCertificateButton.linkbutton("disable");this.generateCsrButton.linkbutton("disable");this.exportKeyButton.linkbutton("disable");this.deleteKeyButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.keysTable.datagrid("selectRow",this.row);}}});jscape.GenerateKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var data={name:this.dialog.getAlias(),keyAlgorithm:this.dialog.getAlgorithm(),keySize:this.dialog.getLength(),certificateGenerationData:{validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry()}};jscape.OPERATION_SERVICE.generateServerKey(data,$.proxy(this._keyGenerated,this));},onCancel:function(){this.dialog.hide();},_keyGenerated:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["keyGeneratedDialog.title"],jscape.Resources["keyGeneratedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.GenerateKeyDialog=Class.extend({ALGORITHM_SIZES:{RSA:[{text:1024,value:1024},{text:2048,value:2048},{text:4096,value:4096}],DSA:[{text:1024,value:1024}]},TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateKeyDialog.title"],width:jscape.Resources.intVal("generateKeyDialog.width"),height:jscape.Resources.intVal("generateKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#generatedKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["generateKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredGeneratedKeyAlias",jscape.Resources["generateKeyDialog.error.validAlias.message"]),validationRule("generatedKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["generateKeyDialog.error.validAlias.message"])]});this.algorithmBox=$("#generatedKeyAlgorithmBox");this.algorithmBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,onSelect:$.proxy(this._algorithmSelected,this)});this.lengthBox=$("#generatedKeyLengthBox");this.lengthBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.periodField=$("#generatedKeyCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generatedKeyCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateKeyDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGeneratedKeyCommonName",jscape.Resources["generateKeyDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generatedKeyCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generatedKeyCertificateOField");this.organizationField.textbox({});this.localityField=$("#generatedKeyCertificateLField");this.localityField.textbox({});this.stateField=$("#generatedKeyCertificateStField");this.stateField.textbox({});this.countryField=$("#generatedKeyCertificateCField");this.countryField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._algorithmSelected({value:"RSA"});},getAlias:function(){return this.aliasField.textbox("getValue").trim();},getAlgorithm:function(){return this.algorithmBox.combobox("getValue");},getLength:function(){return parseInt(this.lengthBox.combobox("getValue"),10);},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},getLocality:function(){return this.localityField.textbox("getValue").trim();},getState:function(){return this.stateField.textbox("getValue").trim();},getCountry:function(){return this.countryField.textbox("getValue").trim();},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_algorithmSelected:function(record){var sizes=this.ALGORITHM_SIZES[record.value];if(this.lengthBox){this.lengthBox.combobox("loadData",sizes);this.lengthBox.combobox("setValue",sizes[0].value).combobox("select",sizes[0].value);}}});jscape.ImportKeyController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){jscape.OPERATION_SERVICE.importServerKey(this.dialog.getForm(),$.proxy(this._keyImported,this));},onCancel:function(){this.dialog.hide();},_keyImported:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["keyImportedDialog.title"],jscape.Resources["keyImportedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.ImportKeyDialog=Class.extend({init:function(){this.dialog=$("#importKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["importKeyDialog.title"],width:jscape.Resources.intVal("importKeyDialog.width"),height:jscape.Resources.intVal("importKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["importKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.aliasField=$("#importKeyAliasField");this.aliasField.textbox({required:true,missingMessage:jscape.Resources["importKeyDialog.error.validAlias.message"],validType:[requiredFieldRule("requiredImportKeyAlias",jscape.Resources["importKeyDialog.error.validAlias.message"]),validationRule("importKeyAliasFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["importKeyDialog.error.validAlias.message"])]});this.keyFileField=$("#importKeyFileField");this.keyFileField.validatebox({required:true,missingMessage:jscape.Resources["importKeyDialog.error.emptyFile.message"]});this.keyFilePasswordField=$("#importKeyFilePasswordField");this.keyFilePasswordField.passwordbox({});this.keyFileAliasField=$("#importKeyFileAliasField");this.keyFileAliasField.textbox({});this.keyPasswordField=$("#importKeyPasswordField");this.keyPasswordField.passwordbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.aliasField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getForm:function(){return this.form;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.KeyDetailsController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary){this.dialog.reset();this.dialog.setAlias(summary.name);this.dialog.setAlgorithm(summary.keyAlgorithm);this.dialog.setKeySize(summary.keySize);this.dialog.setCertificateSerial(summary.certificateSerialNumber,summary.certificateSerialNumberHex);this.dialog.setCertificateIssuer(summary.certificateIssuer);this.dialog.setCertificateSubject(summary.certificateSubject);this.dialog.setCertificateBeginDate(summary.certificateBeginDate);this.dialog.setCertificateEndDate(summary.certificateEndDate);this.dialog.setKeyUsages(summary.keyUsages);this.dialog.setExtendedKeyUsages(summary.extendedKeyUsages);this.dialog.setCertificateSignatureAlgorithm(summary.certificateSignatureAlgorithm);this.dialog.setCertificateSignature(summary.certificateSignature);this.dialog.setRevocationListUrls(summary.revocationListUrls);this.dialog.show(this);},onClose:function(){this.dialog.hide();}});jscape.KeyDetailsDialog=Class.extend({init:function(){this.dialog=$("#keyDetailsDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["keyDetailsDialog.title"],width:jscape.Resources.intVal("keyDetailsDialog.width"),height:jscape.Resources.intVal("keyDetailsDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.close.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onClose,this)}],onClose:$.proxy(this._onClose,this),closed:true});this.form=this.dialog.find("form");this.keyNameField=$("#keyNameField");this.keyNameField.textbox({novalidate:true,readonly:true});this.keyNameField.next("span").css({"border":"none"});this.keyAlgorithmField=$("#keyAlgorithmField");this.keyAlgorithmField.textbox({novalidate:true,readonly:true});this.keyAlgorithmField.next("span").css({"border":"none"});this.keySizeField=$("#keySizeField");this.keySizeField.textbox({novalidate:true,readonly:true});this.keySizeField.next("span").css({"border":"none"});this.certificateSerialField=$("#certificateSerialField");this.certificateSerialField.textbox({novalidate:true,readonly:true});this.certificateSerialField.next("span").css({"border":"none"});this.certificateIssuerField=$("#certificateIssuerField");this.certificateIssuerField.textbox({novalidate:true,readonly:true});this.certificateIssuerField.next("span").css({"border":"none"});this.certificateSubjectField=$("#certificateSubjectField");this.certificateSubjectField.textbox({novalidate:true,readonly:true});this.certificateSubjectField.next("span").css({"border":"none"});this.certificateBeginDateField=$("#certificateBeginDateField");this.certificateBeginDateField.textbox({novalidate:true,readonly:true});this.certificateBeginDateField.next("span").css({"border":"none"});this.certificateEndDateField=$("#certificateEndDateField");this.certificateEndDateField.textbox({novalidate:true,readonly:true});this.certificateEndDateField.next("span").css({"border":"none"});this.certificateExpirationField=$("#certificateExpirationField");this.certificateKeyUsagesField=$("#certificateKeyUsagesField");this.certificateKeyUsagesField.textbox({novalidate:true,readonly:true});this.certificateKeyUsagesField.next("span").css({"border":"none"});this.certificateExtendedKeyUsagesField=$("#certificateExtendedKeyUsagesField");this.certificateExtendedKeyUsagesField.textbox({novalidate:true,readonly:true});this.certificateExtendedKeyUsagesField.next("span").css({"border":"none"});this.certificateSignatureAlgorithmField=$("#certificateSignatureAlgorithmField");this.certificateSignatureAlgorithmField.textbox({novalidate:true,readonly:true});this.certificateSignatureAlgorithmField.next("span").css({"border":"none"});this.certificateSignatureField=$("#certificateSignatureField");this.certificateSignatureField.textbox({novalidate:true,readonly:true});this.certificateSignatureField.next("span").css({"border":"none"});this.certificateClrField=$("#certificateClrField");this.certificateClrField.textbox({novalidate:true,readonly:true});this.certificateClrField.next("span").css({"border":"none"});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["keyDetailsDialog.title"].supplant({name:value}));this.keyNameField.textbox("setValue",value);},setAlgorithm:function(value){this.keyAlgorithmField.textbox("setValue",value);},setKeySize:function(value){this.keySizeField.textbox("setValue",jscape.Resources["keyDetailsDialog.keySizeField.text"].supplant({value:value}));},setCertificateSerial:function(value,hexValue){this.certificateSerialField.textbox("setValue","{value}(0x{hexValue})".supplant({value:value,hexValue:hexValue}));},setCertificateIssuer:function(value){this.certificateIssuerField.textbox("setValue",value);},setCertificateSubject:function(value){this.certificateSubjectField.textbox("setValue",value);},setCertificateBeginDate:function(value){this.certificateBeginDateField.textbox("setValue",DateFormat.format(value));},setCertificateEndDate:function(value){this.certificateEndDateField.textbox("setValue",DateFormat.format(value));var now=new Date().getTime();this.certificateExpirationField.text(now>value?"<span style='color:red;'>{value}</span>".supplant({value:jscape.Resources["keyDetailsDialog.certificateExpired.text"]}):jscape.Resources["keyDetailsDialog.certificateExpiration.text"].supplant({days:((value-now)/(1000*3600*24)).toFixed(0)}));},setKeyUsages:function(value){var text=$.map(value,function(element,index){return jscape.Resources["keyUsage."+element];}).join(", ");this.certificateKeyUsagesField.textbox("setValue",text);},setExtendedKeyUsages:function(value){var text=$.map(value,function(element,index){return jscape.Resources["extendedKeyUsage."+element];}).join(", ");this.certificateExtendedKeyUsagesField.textbox("setValue",text);},setCertificateSignatureAlgorithm:function(value){this.certificateSignatureAlgorithmField.textbox("setValue",value);},setCertificateSignature:function(value){this.certificateSignatureField.textbox("setValue",value);},setRevocationListUrls:function(value){this.certificateClrField.textbox("setValue",value.join(", "));},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onClose:function(){this.listener.onClose();}});jscape.ImportCertificateController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;this.dialog.reset();this.dialog.setAlias(this.data.name);this.dialog.show(this);},onSubmit:function(){jscape.OPERATION_SERVICE.importServerCertificate(this.data.name,this.dialog.getForm(),$.proxy(this._certificateImported,this));},onCancel:function(){this.dialog.hide();},_certificateImported:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["certificateImportedDialog.title"],jscape.Resources["certificateImportedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.ImportCertificateDialog=Class.extend({init:function(){this.dialog=$("#importCertificateDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["importCertificateDialog.title"],width:jscape.Resources.intVal("importCertificateDialog.width"),height:jscape.Resources.intVal("importCertificateDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["importCertificateDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.keyFileField=$("#importCertificateFileField");this.keyFileField.validatebox({required:true,missingMessage:jscape.Resources["importCertificateDialog.error.emptyFile.message"]});this.certificateFilePasswordField=$("#importCertificateFilePasswordField");this.certificateFilePasswordField.passwordbox({});this.certificateFileAliasField=$("#importCertificateFileAliasField");this.certificateFileAliasField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.keyFileField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["importCertificateDialog.title"].supplant({name:value}));},getForm:function(){return this.form;},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.GenerateCertificateController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;var subject=this._certificateSubjectFor(this.data.certificateSubject);this.dialog.reset();this.dialog.setAlias(this.data.name);this.dialog.setCommonName(subject.CN);this.dialog.setOrganizationUnit(subject.OU);this.dialog.setOrganization(subject.O);this.dialog.setLocality(subject.L);this.dialog.setState(subject.ST);this.dialog.setCountry(subject.C);this.dialog.show(this);},onSubmit:function(){var data={validityPeriodMillis:this.dialog.getPeriod(),commonName:this.dialog.getCommonName(),organizationUnit:this.dialog.getOrganizationUnit(),organization:this.dialog.getOrganization(),locality:this.dialog.getLocality(),state:this.dialog.getState(),country:this.dialog.getCountry()};jscape.OPERATION_SERVICE.generateServerCertificate(this.data.name,data,$.proxy(this._certificateGenerated,this));},onCancel:function(){this.dialog.hide();},_certificateSubjectFor:function(value){var subject={CN:"",OU:"",O:"",L:"",ST:"",C:""};var values={};var entries=value?value.split(","):[];entries.forEach(function(entry){var parts=entry.split("=");if(parts.length===2){values[parts[0].toUpperCase().trim()]=parts[1];}});return $.extend(subject,values);},_certificateGenerated:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["certificateGeneratedDialog.title"],jscape.Resources["certificateGeneratedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.GenerateCertificateDialog=Class.extend({TIME_FACTOR:24*60*60*1000,init:function(){this.dialog=$("#generateCertificateDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["generateCertificateDialog.title"],width:jscape.Resources.intVal("generateCertificateDialog.width"),height:jscape.Resources.intVal("generateCertificateDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["generateCertificateDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.periodField=$("#generatedCertificatePeriodField");this.periodField.numberspinner({min:1,max:99999,value:365,increment:10,required:true,missingMessage:jscape.Resources["generateKeyDialog.error.emptyPeriod.message"]});this.commonNameField=$("#generatedCertificateCnField");this.commonNameField.textbox({required:true,missingMessage:jscape.Resources["generateCertificateDialog.error.emptyCommonName.message"],validType:[requiredFieldRule("requiredGeneratedCertificateCommonName",jscape.Resources["generateCertificateDialog.error.emptyCommonName.message"])]});this.organizationUnitField=$("#generatedCertificateOuField");this.organizationUnitField.textbox({});this.organizationField=$("#generatedCertificateOField");this.organizationField.textbox({});this.localityField=$("#generatedCertificateLField");this.localityField.textbox({});this.stateField=$("#generatedCertificateStField");this.stateField.textbox({});this.countryField=$("#generatedCertificateCField");this.countryField.textbox({});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.periodField.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["generateCertificateDialog.title"].supplant({name:value}));},getPeriod:function(){return this.periodField.numberspinner("getValue")*this.TIME_FACTOR;},getCommonName:function(){return this.commonNameField.textbox("getValue").trim();},setCommonName:function(value){this.commonNameField.textbox("setValue",value);this.commonNameField.textbox("validate");},getOrganizationUnit:function(){return this.organizationUnitField.textbox("getValue").trim();},setOrganizationUnit:function(value){this.organizationUnitField.textbox("setValue",value);},getOrganization:function(){return this.organizationField.textbox("getValue").trim();},setOrganization:function(value){this.organizationField.textbox("setValue",value);},getLocality:function(){return this.localityField.textbox("getValue").trim();},setLocality:function(value){this.localityField.textbox("setValue",value);},getState:function(){return this.stateField.textbox("getValue").trim();},setState:function(value){this.stateField.textbox("setValue",value);},getCountry:function(){return this.countryField.textbox("getValue").trim();},setCountry:function(value){this.countryField.textbox("setValue",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.ExportKeyController=Class.extend({init:function(typeDialog,passwordDialog){this.typeDialog=typeDialog;this.passwordDialog=passwordDialog;},start:function(summary){this.data=summary;this.typeDialog.reset();this.typeDialog.setAlias(this.data.name);this.typeDialog.show(this);},onSubmit:function(){var type=this.typeDialog.getType();var format=this.typeDialog.getFormat();if(type==="certificate"){this.typeDialog.hide();jscape.OPERATION_SERVICE.serverCertificateFor(this.data.name,format);}else if(type==="publicKey"){this.typeDialog.hide();jscape.OPERATION_SERVICE.serverPublicKeyFor(this.data.name,format);}else if(type==="privateKey"){this.passwordDialog.reset();this.passwordDialog.setAlias(this.data.name);this.passwordDialog.show(this);}},onCancel:function(){this.typeDialog.hide();},onPasswordSubmit:function(){this.passwordDialog.hide();this.typeDialog.hide();jscape.OPERATION_SERVICE.serverKeyFor(this.data.name,this.typeDialog.getFormat(),this.passwordDialog.getPassword());},onPasswordCancel:function(){this.passwordDialog.hide();}});jscape.ExportKeyDialog=Class.extend({FORMATS:{"certificate":[{value:"X509"},{value:"PEM"}],"publicKey":[{value:"X509"},{value:"PEM"},{value:"Putty"},{value:"SSH"}],"privateKey":[{value:"JKS"},{value:"PKCS12"},{value:"PKCS8"},{value:"PEM"}]},init:function(){this.dialog=$("#exportKeyDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["exportKeyDialog.title"],width:jscape.Resources.intVal("exportKeyDialog.width"),height:jscape.Resources.intVal("exportKeyDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["exportKeyDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.typeBox=$("#exportKeyTypeBox");this.typeBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150,onSelect:$.proxy(this._typeSelected,this)});this.formatBox=$("#exportKeyFormatBox");this.formatBox.combobox({valueField:"value",panelHeight:"auto",panelMaxHeight:150,textField:"value",editable:false});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.typeBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");this._typeSelected(this.getType());},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["exportKeyDialog.title"].supplant({name:value}));},getType:function(){return this.typeBox.combobox("getValue");},getFormat:function(){return this.formatBox.combobox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_typeSelected:function(data){var formats=this.FORMATS[data.value||data];if(this.formatBox){this.formatBox.combobox("loadData",formats);this.formatBox.combobox("setValue",formats[0].value).combobox("select",formats[0].value);}}});jscape.ExportKeyPasswordDialog=Class.extend({init:function(){this.dialog=$("#exportKeyPasswordDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["exportKeyPasswordDialog.title"],width:jscape.Resources.intVal("exportKeyPasswordDialog.width"),height:jscape.Resources.intVal("exportKeyPasswordDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["exportKeyPasswordDialog.okButton.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.passwordField=$("#exportKeyPasswordField");this.passwordField.passwordbox({required:true,missingMessage:jscape.Resources["exportKeyPasswordDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredKeyPassword",jscape.Resources["exportKeyPasswordDialog.error.emptyPassword.message"])]});this.passwordConfirmationField=$("#exportKeyPasswordConfirmationField");this.passwordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["exportKeyPasswordDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredKeyPasswordConfirmation",jscape.Resources["exportKeyPasswordDialog.error.emptyPasswordConfirmation.message"]),validationRule("sameExportPasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["exportKeyPasswordDialog.error.nonEqualPasswords.message"])]});},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.passwordField.passwordbox("passwordbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setAlias:function(value){this.dialog.dialog("setTitle",jscape.Resources["exportKeyPasswordDialog.title"].supplant({name:value}));},getPassword:function(){return this.passwordField.passwordbox("getValue");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onPasswordSubmit();}},_onCancel:function(){this.listener.onPasswordCancel();}});jscape.DeleteKeyController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteKeyDialog.title"],this.values.length===1?jscape.Resources["deleteKeyDialog.message"].supplant(this.values[0]):jscape.Resources["deleteKeyDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.OPERATION_SERVICE.deleteServerKey(this.values[this.valueIndex++].name,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){$.messager.alert(jscape.Resources["keyDeletedDialog.title"],this.values.length===1?jscape.Resources["keyDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["keyDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}),"info",$.proxy(this.callback,this));}});