/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.AgentsController=Class.extend({init:function(page,addAgentController,editAgentController,deleteAgentController){this.page=page;this.addAgentController=addAgentController;this.editAgentController=editAgentController;this.deleteAgentController=deleteAgentController;},start:function(){this.page.show(this);},onReload:function(request,successCallback){jscape.OPERATION_SERVICE.agentsFor(request,function(page){successCallback({total:page.totalRecords,rows:page.records});});},onCreateAgent:function(){this.addAgentController.start($.proxy(function(){this.page.reload();},this));},onEditAgent:function(summary){this.editAgentController.start(summary,$.proxy(function(){this.page.reload();},this));},onDeleteAgents:function(summaries){this.deleteAgentController.start(summaries,$.proxy(function(){this.page.reload();},this));}});jscape.AgentsPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.agentsTable=$("#agentsTable");this.agentsTable.datagrid({fitColumns:true,pagination:true,search:true,remoteSearch:true,remoteSort:true,sortName:"username",sortOrder:"asc",singleSelect:false,ctrlSelect:true,columns:[[{field:"username",title:jscape.Resources["agentsPage.agentsTable.column.0"],width:90,halign:"left",align:"left",sortable:true,searchable:true},{field:"enabled",title:jscape.Resources["agentsPage.agentsTable.column.1"],width:10,halign:"center",align:"center",sortable:true,searchable:true,formatter:function(value){return"<input type='checkbox' {checked} disabled='disabled'/>".supplant({checked:value?" checked='checked'":""});},finder:{type:"combobox",options:{panelHeight:"auto",data:[{text:jscape.Resources["true"],value:1},{text:jscape.Resources["false"],value:0}]}}}]],onSelect:$.proxy(this._rowSelected,this),onUnselect:$.proxy(this._rowUnselected,this),loader:$.proxy(function(params,success){this.listener.onReload(asPageRequest(params),success);},this),onLoadSuccess:$.proxy(this._dataLoaded,this),onBeforeLoad:$.proxy(function(){return!!this.listener;},this),onDblClickRow:$.proxy(function(){this.listener.onEditAgent(this.rowValue);},this)});this.addAgentButton=$("#addAgentButton");this.addAgentButton.linkbutton({width:jscape.Resources.buttonSize()});this.addAgentButton.click($.proxy(function(){this.listener.onCreateAgent();},this));this.editAgentButton=$("#editAgentButton");this.editAgentButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.editAgentButton.click($.proxy(function(){if(!this.editAgentButton.linkbutton("options").disabled){this.listener.onEditAgent(this.rowValue);}},this));this.deleteAgentButton=$("#deleteAgentButton");this.deleteAgentButton.linkbutton({width:jscape.Resources.buttonSize(),disabled:true});this.deleteAgentButton.click($.proxy(this._delete,this));},show:function(listener){this.listener=listener;this.infoPanel.css("visibility","visible");this.agentsTable.datagrid("reload");},reload:function(){this.agentsTable.datagrid("reload");},_rowSelected:function(row,value){this.row=row;this.rowValue=value;this.editAgentButton.linkbutton("enable");this.deleteAgentButton.linkbutton("enable");},_rowUnselected:function(){if(this.agentsTable.datagrid("getSelections").length===0){this._resetButtons();}},_dataLoaded:function(data){this._resetButtons();if(data.rows.length!==0){this._restoreSelection();}else if(data.total>0){var pageNumber=this.agentsTable.datagrid("options").pageNumber;if(pageNumber>1){this.agentsTable.datagrid("gotoPage",pageNumber-1);}}},_delete:function(){var values=this.agentsTable.datagrid("getSelections");if(values.length>0){this.listener.onDeleteAgents(values);}},_resetButtons:function(){this.editAgentButton.linkbutton("disable");this.deleteAgentButton.linkbutton("disable");},_restoreSelection:function(){if(this.row>=0){this.agentsTable.datagrid("selectRow",this.row);}}});jscape.AddAgentController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(callback){this.callback=callback;this.dialog.reset();this.dialog.show(this);},onSubmit:function(){var agent={username:this.dialog.getLogin(),password:this.dialog.getPassword(),enabled:this.dialog.isEnabled()};jscape.OPERATION_SERVICE.addAgent(agent,$.proxy(this._agentCreated,this));},onCancel:function(){this.dialog.hide();},_agentCreated:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["agentCreatedDialog.title"],jscape.Resources["agentCreatedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.AddAgentDialog=Class.extend({init:function(){this.dialog=$("#addAgentDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["addAgentDialog.title"],width:jscape.Resources.intVal("addAgentDialog.width"),height:jscape.Resources.intVal("addAgentDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.add.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.loginField=$("#addAgentLoginField");this.loginField.textbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.validLogin.message"],validType:[requiredFieldRule("addAgentLoginFieldEmpty",jscape.Resources["addAgentDialog.error.validLogin.message"]),validationRule("addAgentLoginFieldValid",function(value){return new XRegExp("^[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']*[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}0-9_\\-.\\(\\)&']+$").test(value);},jscape.Resources["addAgentDialog.error.validLogin.message"])]});this.passwordField=$("#addAgentPasswordField");this.passwordField.passwordbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.emptyPassword.message"],validType:[requiredFieldRule("requiredPassword",jscape.Resources["addAgentDialog.error.emptyPassword.message"])]});this.passwordConfirmationField=$("#addAgentPasswordConfirmationField");this.passwordConfirmationField.passwordbox({required:true,missingMessage:jscape.Resources["addAgentDialog.error.emptyPasswordConfirmation.message"],validType:[requiredFieldRule("requiredPasswordConfirmation",jscape.Resources["addAgentDialog.error.emptyPasswordConfirmation.message"]),validationRule("samePasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["addAgentDialog.error.nonEqualPasswords.message"])]});this.enabledBox=$("#addAgentEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.enabledBox.prop("checked",true);this.loginField.textbox("textbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},getLogin:function(){return this.loginField.textbox("getValue").trim();},getPassword:function(){return this.passwordField.passwordbox("getValue");},isEnabled:function(){return this.enabledBox.prop("checked");},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.EditAgentController=Class.extend({init:function(dialog){this.dialog=dialog;},start:function(summary,callback){this.data=summary;this.callback=callback;jscape.OPERATION_SERVICE.agentFor(this.data.username,$.proxy(this._agentLoaded,this));},onSubmit:function(){var agent={username:this.data.username,password:this.dialog.getPassword(),enabled:this.dialog.isEnabled(),version:this.data.version};jscape.OPERATION_SERVICE.updateAgent(agent,$.proxy(this._agentUpdated,this));},onCancel:function(){this.dialog.hide();},_agentLoaded:function(data){this.data=data;this.dialog.reset();this.dialog.setLogin(this.data.username);this.dialog.setEnabled(this.data.enabled);this.dialog.show(this);},_agentUpdated:function(summary){this.dialog.hide();$.messager.alert(jscape.Resources["agentUpdatedDialog.title"],jscape.Resources["agentUpdatedDialog.message"].supplant(summary),"info",$.proxy(this.callback,this));}});jscape.EditAgentDialog=Class.extend({init:function(){this.dialog=$("#editAgentDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["editAgentDialog.title"],width:jscape.Resources.intVal("editAgentDialog.width"),height:jscape.Resources.intVal("editAgentDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.passwordField=$("#editAgentPasswordField");this.passwordField.passwordbox({});this.passwordConfirmationField=$("#editAgentPasswordConfirmationField");this.passwordConfirmationField.passwordbox({validType:[validationRule("sameEditAgentPasswords",$.proxy(function(){return this.passwordField.val()===this.passwordConfirmationField.val();},this),jscape.Resources["editAgentDialog.error.nonEqualPasswords.message"])]});this.enabledBox=$("#editAgentEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.passwordField.passwordbox("passwordbox").focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setLogin:function(value){this.dialog.dialog("setTitle",jscape.Resources["editAgentDialog.title"].supplant({username:value}));},getPassword:function(){return this.passwordField.passwordbox("getValue");},isEnabled:function(){return this.enabledBox.prop("checked");},setEnabled:function(value){this.enabledBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();}});jscape.DeleteAgentController=Class.extend({start:function(values,callback){this.values=values;this.callback=callback;this._showConfirmation();},_showConfirmation:function(){$.messager.confirm(jscape.Resources["deleteAgentDialog.title"],this.values.length===1?jscape.Resources["deleteAgentDialog.message"].supplant(this.values[0]):jscape.Resources["deleteAgentDialog.message.selected"],$.proxy(function(confirmed){if(confirmed){this._confirmed();}},this));},_confirmed:function(){this.valueIndex=0;this._operation();},_operation:function(){if(this.valueIndex<this.values.length){jscape.OPERATION_SERVICE.deleteAgent(this.values[this.valueIndex++].username,$.proxy(this._operation,this));}else{this._operationCompleted();}},_operationCompleted:function(){$.messager.alert(jscape.Resources["agentDeletedDialog.title"],this.values.length===1?jscape.Resources["agentDeletedDialog.message"].supplant(this.values[0]):jscape.Resources["agentDeletedDialog.message.selected"].supplant({count:this.valueIndex===this.values.length?this.valueIndex:this.valueIndex-1}),"info",$.proxy(this.callback,this));}});