/* Copyright &#169; JSCAPE Corp. 2009-2018. All Rights Reserved */
jscape.AgentController=Class.extend({init:function(page,changeAgentConfigurationController,autoUpdateInterval){this.page=page;this.changeAgentConfigurationController=changeAgentConfigurationController;this.autoUpdateInterval=autoUpdateInterval;},start:function(){jscape.OPERATION_SERVICE.agentServiceConfiguration($.proxy(this._configurationLoaded,this));},onChange:function(){this.changeAgentConfigurationController.start($.proxy(this._configurationUpdated,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this._initPage();this.page.show(this);this._updateSessions();},_configurationUpdated:function(configuration){this.configuration=configuration;this._initPage();},_initPage:function(){this.page.setConfiguration(this.configuration);},_updateSessions:function(){jscape.OPERATION_SERVICE.agentSessions($.proxy(this._sessionsUpdated,this));},_sessionsUpdated:function(summaries){this.page.setAgentSessions(summaries);this._scheduleNextSessionsUpdate();},_scheduleNextSessionsUpdate:function(){setTimeout($.proxy(this._updateSessions,this),this.autoUpdateInterval);}});jscape.AgentPage=Class.extend({init:function(){this.infoPanel=$("#infoPanel");this.infoPanel.tabs({border:true,plain:true});this.agentField=$("#agentField");this.agentSessionsTable=$("#agentSessionsTable");this.agentSessionsTable.datagrid({fitColumns:true,remoteSort:true,sortName:"creationTime",sortOrder:"desc",singleSelect:true,columns:[[{field:"id",title:jscape.Resources["agentPage.agentSessionsTable.column.0"],width:15,halign:"left",align:"left",sortable:false},{field:"username",title:jscape.Resources["agentPage.agentSessionsTable.column.1"],width:20,halign:"left",align:"left",sortable:true},{field:"remoteAddress",title:jscape.Resources["agentPage.agentSessionsTable.column.2"],width:15,halign:"left",align:"left",sortable:true,formatter:function(value,row){return"{host}:{port}".supplant(row.remoteAddress);}},{field:"creationTime",title:jscape.Resources["agentPage.agentSessionsTable.column.3"],width:15,halign:"right",align:"right",sortable:true,formatter:function(value,row){return DateFormat.format(new Date(row.creationTime))}},{field:"uptime",title:jscape.Resources["agentPage.agentSessionsTable.column.4"],width:20,halign:"left",align:"left",sortable:true,formatter:$.proxy(this._uptimeOf,this)},{field:"currentConnections",title:jscape.Resources["agentPage.agentSessionsTable.column.5"],width:15,halign:"right",align:"right",sortable:true},{field:"currentPorts",title:jscape.Resources["agentPage.agentSessionsTable.column.6"],width:15,halign:"right",align:"right",sortable:true}]],onSortColumn:$.proxy(this._sort,this)});this.sorter={"username.asc":function(a,b){return window.sort(a.username,b.username);},"username.desc":function(a,b){return window.sort(b.username,a.username);},"remoteAddress.asc":$.proxy(function(a,b){return window.sortAddress(a.remoteAddress,b.remoteAddress);},this),"remoteAddress.desc":$.proxy(function(a,b){return window.sortAddress(b.remoteAddress,a.remoteAddress);},this),"date.asc":function(a,b){return window.sort(a.creationTime,b.creationTime);},"date.desc":function(a,b){return window.sort(b.creationTime,a.creationTime);}};this.changeButton=$("#changeButton");this.changeButton.linkbutton({width:jscape.Resources.buttonSize()});this.changeButton.click($.proxy(this._onChange,this));},show:function(listener){this.listener=listener;this.agentSessions=[];this.infoPanel.css("visibility","visible");},setConfiguration:function(value){this.agentField.text(value.enabled?jscape.Resources["agentPage.agentField.text"].supplant({host:value.address.host,port:value.address.port,key:value.keyAlias}):jscape.Resources["disabled"]);},setAgentSessions:function(value){this.agentSessions=value;this._sort(this.sortedColumn||"date",this.sortOrder||"desc");},_sort:function(name,order){this.sortedColumn=name;this.sortOrder=order;this.agentSessions.sort(this.sorter[name+"."+order]);this.agentSessionsTable.datagrid("loadData",this.agentSessions);},_uptimeOf:function(value,entry){var interval=new TimeInterval(new Date().getTime()-entry.creationTime);var pattern=[];if(interval.hours){pattern.push("{hours} hrs.");}
if(interval.minutes){pattern.push("{minutes} min.");}
if(interval.seconds){pattern.push("{seconds} sec.");}
return pattern.join(" ").supplant(interval);},_onChange:function(){this.listener.onChange();}});jscape.ChangeAgentConfigurationController=Class.extend({init:function(dialog){this.dialog=dialog;this.parametersController=new jscape.AgentParametersController();},start:function(callback){this.callback=callback;this.parametersController.start($.proxy(this._parametersLoaded,this));},onSubmit:function(){var configuration={address:{host:this.dialog.getHost(),port:this.dialog.getPort()},keyAlias:this.dialog.getKey(),socketNagleAlgorithmDisabled:this.dialog.getNagleAlgorithm(),socketBufferSizeBytes:this.dialog.getChannelBufferSize(),enabled:this.dialog.isEnabled(),version:this.configuration.version};jscape.OPERATION_SERVICE.updateAgentConnectorFactoryConfiguration(configuration,$.proxy(function(){this._configurationUpdated(configuration);},this));},onCancel:function(){this.dialog.hide();this.callback(this.configuration);},_parametersLoaded:function(hosts,keys){this.dialog.setHosts(hosts);this.dialog.setKeys(keys);jscape.OPERATION_SERVICE.agentServiceConfiguration($.proxy(this._configurationLoaded,this));},_configurationLoaded:function(configuration){this.configuration=configuration;this.dialog.reset();this.dialog.setEnabled(this.configuration.enabled);this.dialog.setHost(this.configuration.address.host);this.dialog.setPort(this.configuration.address.port);this.dialog.setKey(this.configuration.keyAlias);this.dialog.setNagleAlgorithm(this.configuration.socketNagleAlgorithmDisabled);this.dialog.setChannelBufferSize(this.configuration.socketBufferSizeBytes);this.dialog.show(this);},_configurationUpdated:function(configuration,error){this.dialog.hide();$.messager.alert(jscape.Resources["agentConfigurationAppliedDialog.title"],jscape.Resources["agentConfigurationAppliedDialog.message"],"info",$.proxy(function(){this.callback(configuration);},this));}});jscape.ChangeAgentConfigurationDialog=Class.extend({DEFAULT_HOST:"0.0.0.0",init:function(){this.dialog=$("#agentConfigurationDialog");this.dialog.show();this.dialog.dialog({title:jscape.Resources["agentConfigurationDialog.title"],width:jscape.Resources.intVal("agentConfigurationDialog.width"),height:jscape.Resources.intVal("agentConfigurationDialog.height"),modal:true,resizable:true,closable:true,buttons:[{text:jscape.Resources["button.save.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onSubmit,this)},{text:jscape.Resources["button.cancel.text"],width:jscape.Resources.buttonSize(),handler:$.proxy(this._onCancel,this)}],onClose:$.proxy(this._onCancel,this),closed:true});this.form=this.dialog.find("form");this.agentHostBox=$("#agentHostBox");this.agentHostBox.combobox({editable:false,valueField:"value",textField:"value",required:true,panelHeight:"auto",panelMaxHeight:150,missingMessage:jscape.Resources["agentConfigurationDialog.error.emptyHost.message"],validType:requiredFieldRule("requiredAgentHost",jscape.Resources["agentConfigurationDialog.error.emptyHost.message"])});this.agentPortField=$("#agentPortField");this.agentPortField.numberspinner({min:1,max:65535,value:30843,increment:1,required:true,missingMessage:jscape.Resources["agentConfigurationDialog.error.emptyPort.message"]});this.agentKeyBox=$("#agentKeyBox");this.agentKeyBox.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.nagleAlgorithmField=$("#agentNagleAlgorithmField");this.nagleAlgorithmField.combobox({editable:false,panelHeight:"auto",panelMaxHeight:150});this.channelBufferSizeEnabledBox=$("#agentChannelBufferSizeEnabledBox");this.channelBufferSizeEnabledBox.click($.proxy(this._channelBufferSizeBoxClicked,this));this.channelBufferSizeField=$("#agentChannelBufferSizeField");this.channelBufferSizeField.numberspinner({min:10,max:9999999,value:65536,increment:1024,required:true,missingMessage:jscape.Resources["httpConfigurationDialog.error.emptyChannelBufferSize.message"]});this.agentEnabledBox=$("#agentEnabledBox");},show:function(listener){this.listener=listener;this.dialog.dialog("center");this.dialog.dialog("open");this.agentEnabledBox.focus();},hide:function(){if(!this._closed()){this.dialog.dialog("close");}},reset:function(){this.form.form("reset");},setHosts:function(values){var hosts=$.map(values,function(value){return{value:value};});hosts.unshift({value:this.DEFAULT_HOST});this.agentHostBox.combobox("loadData",hosts);this.agentHostBox.combobox("loadData",hosts);},setKeys:function(values){this.keys=$.map(values,function(value){return{text:value,value:value};});this.agentKeyBox.combobox("loadData",this.keys);if(this.keys.length===0){this.agentEnabledBox.prop("disabled",true);}},getHost:function(){return this.agentHostBox.combobox("getValue").trim();},setHost:function(value){value=value&&value.length>0?value:this.DEFAULT_HOST;this.agentHostBox.combobox("setValue",value).combobox("select",value);},getPort:function(){return parseInt(this.agentPortField.numberspinner("getValue"),10);},setPort:function(value){this.agentPortField.numberspinner("setValue",value);},getKey:function(){return this.agentKeyBox.combobox("getValue");},setKey:function(value){if($.grep(this.keys,function(candidate){return candidate.value===value;}).length>0){this.agentKeyBox.combobox("setValue",value).combobox("select",value);}else if(this.keys&&this.keys.length>0){this.agentKeyBox.combobox("setValue",this.keys[0].value).combobox("select",this.keys[0].value);}},getNagleAlgorithm:function(){var value=this.nagleAlgorithmField.combobox("getValue");return value==="DEFAULT"?null:value==="DISABLED";},setNagleAlgorithm:function(value){var comboValue=value===null||value===undefined?"DEFAULT":value?"DISABLED":"ENABLED";this.nagleAlgorithmField.combobox("setValue",comboValue).combobox("select",comboValue);},getChannelBufferSize:function(){return this.channelBufferSizeEnabledBox.prop("checked")?parseInt(this.channelBufferSizeField.numberspinner("getValue"),10):null;},setChannelBufferSize:function(value){if(value===null||value===undefined){this.channelBufferSizeEnabledBox.prop("checked",false);this._channelBufferSizeBoxClicked();}else{this.channelBufferSizeEnabledBox.prop("checked",true);this._channelBufferSizeBoxClicked();this.channelBufferSizeField.numberspinner("setValue",value);}},isEnabled:function(){return!this.agentEnabledBox.prop("disabled")&&this.agentEnabledBox.prop("checked");},setEnabled:function(value){this.agentEnabledBox.prop("checked",value);},_closed:function(){return!this.dialog||!!this.dialog.dialog("options").closed;},_onSubmit:function(){if(this.form.form("validate")){this.listener.onSubmit();}},_onCancel:function(){this.listener.onCancel();},_channelBufferSizeBoxClicked:function(){this.channelBufferSizeField.combobox(this.channelBufferSizeEnabledBox.prop("checked")?"enable":"disable");}});jscape.AgentParametersController=Class.extend({start:function(callback){this.callback=callback;this._loadAddresses();},_loadAddresses:function(){jscape.OPERATION_SERVICE.serverAddresses($.proxy(this._addressesLoaded,this));},_addressesLoaded:function(addresses){this.addresses=addresses;this._loadKeys();},_loadKeys:function(){jscape.OPERATION_SERVICE.serverKeyAliases($.proxy(this._keysLoaded,this));},_keysLoaded:function(keys){this.callback(this.addresses,keys);}});