/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.TlsHMAC;

public class JceTlsHMAC
implements TlsHMAC {
    private static final Map<String, Integer> internalBlockSizes = new HashMap<String, Integer>();
    private final Mac hmac;
    private final String algorithm;
    private final Integer internalBlockSize;

    public JceTlsHMAC(Mac hmac, String algorithm) {
        this(hmac, algorithm, JceTlsHMAC.getInternalBlockSize(algorithm));
    }

    private static int getInternalBlockSize(String algorithm) {
        if (!internalBlockSizes.containsKey(algorithm)) {
            throw new IllegalArgumentException("HMAC " + algorithm + " unknown");
        }
        return internalBlockSizes.get(algorithm);
    }

    public JceTlsHMAC(Mac hmac, String algorithm, int internalBlockSize) {
        this.hmac = hmac;
        this.algorithm = algorithm;
        this.internalBlockSize = internalBlockSize;
    }

    @Override
    public void setKey(byte[] key) {
        try {
            this.hmac.init(new SecretKeySpec(key, this.algorithm));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.hmac.update(input, inOff, length);
    }

    @Override
    public byte[] calculateMAC() {
        return this.hmac.doFinal();
    }

    @Override
    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    @Override
    public int getMacLength() {
        return this.hmac.getMacLength();
    }

    @Override
    public void reset() {
        this.hmac.reset();
    }

    static {
        internalBlockSizes.put("HmacMD5", 64);
        internalBlockSizes.put("HmacSHA1", 64);
        internalBlockSizes.put("HmacSHA256", 64);
        internalBlockSizes.put("HmacSHA384", 128);
        internalBlockSizes.put("HmacSHA512", 128);
    }
}

