/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;

public class JceTlsECDH
implements TlsAgreement {
    protected JceTlsECDomain domain;
    protected KeyPair localKeyPair;
    protected ECPublicKey peerPublicKey;

    public JceTlsECDH(JceTlsECDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((ECPublicKey)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] data = this.domain.calculateECDHAgreement(this.peerPublicKey, (ECPrivateKey)this.localKeyPair.getPrivate());
            return this.domain.getCrypto().adoptLocalSecret(data);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("cannot calculate secret", e);
        }
    }
}

