/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import org.bouncycastle.util.BigIntegers;

public class JceTlsDHDomain
implements TlsDHDomain {
    protected JcaTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameterSpec dhDomain;

    public JceTlsDHDomain(JcaTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhDomain = this.getParameters(dhConfig);
    }

    public byte[] calculateDHAgreement(DHPublicKey publicKey, DHPrivateKey privateKey) throws GeneralSecurityException {
        KeyAgreement agreement = this.crypto.getHelper().createKeyAgreement("DH");
        agreement.init(privateKey);
        agreement.doPhase(publicKey, true);
        return agreement.generateSecret("TlsPremasterSecret").getEncoded();
    }

    @Override
    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public static BigInteger decodeParameter(byte[] encoding) throws IOException {
        return new BigInteger(1, encoding);
    }

    public DHPublicKey decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = JceTlsDHDomain.decodeParameter(encoding);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DH");
            return (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(y, this.dhDomain.getP(), this.dhDomain.getG()));
        }
        catch (Exception e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return BigIntegers.asUnsignedByteArray((BigInteger)x);
    }

    public byte[] encodePublicKey(DHPublicKey publicKey) throws IOException {
        return this.encodeParameter(publicKey.getY());
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize(this.getParameters(this.dhConfig), this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to create key pair: " + e.getMessage(), e);
        }
    }

    public JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    public DHParameterSpec getParameters(TlsDHConfig dhConfig) {
        BigInteger[] pg = dhConfig.getExplicitPG();
        if (pg != null) {
            return new DHParameterSpec(pg[0], pg[1]);
        }
        throw new IllegalStateException("No DH configuration provided");
    }
}

