/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

public class JceDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    private final JcaTlsCrypto crypto;
    private final String algorithm;
    private final Certificate certificate;
    private final PrivateKey privateKey;

    public JceDefaultTlsCredentialedAgreement(JcaTlsCrypto crypto, Certificate certificate, PrivateKey privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
        if (privateKey instanceof DHPrivateKey) {
            this.algorithm = "DH";
        } else if (privateKey instanceof ECPrivateKey) {
            this.algorithm = "ECDH";
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        try {
            KeyAgreement agreement = this.crypto.getHelper().createKeyAgreement(this.algorithm);
            agreement.init(this.privateKey);
            agreement.doPhase(JcaTlsCertificate.convert(peerCertificate, this.crypto.getHelper()).getPublicKey(), true);
            return new JceTlsSecret(this.crypto, agreement.generateSecret("TlsPremasterSecret").getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("unable to perform agreement: " + e.getMessage(), e);
        }
    }
}

