/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsVerifier;

public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    protected RSAPublicKey pubKeyRSA;

    public JcaTlsRSAVerifier(RSAPublicKey pubKeyRSA, JcaJceHelper helper) {
        if (pubKeyRSA == null) {
            throw new IllegalArgumentException("'pubKeyRSA' cannot be null");
        }
        this.pubKeyRSA = pubKeyRSA;
        this.helper = helper;
    }

    @Override
    public boolean verifySignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        try {
            Signature signer = this.helper.createSignature("NoneWithRSA");
            signer.initVerify(this.pubKeyRSA);
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                try {
                    byte[] digInfo = new DigestInfo(new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE), hash).getEncoded();
                    signer.update(digInfo, 0, digInfo.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

