/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsRSASigner
implements TlsSigner {
    private final PrivateKey privateKey;
    private final JcaTlsCrypto crypto;

    public JcaTlsRSASigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        this.crypto = crypto;
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.crypto.getHelper().createSignature("NoneWithRSA");
            signer.initSign(this.privateKey, this.crypto.getSecureRandom());
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                try {
                    byte[] digInfo = new DigestInfo(new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE), hash).getEncoded();
                    signer.update(digInfo, 0, digInfo.length);
                }
                catch (IOException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

