/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.ChaCha20Poly1305Cipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipher;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceStreamCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;

    protected JcaTlsCrypto(JcaJceHelper helper, SecureRandom entropySource, SecureRandom nonceEntropySource) {
        this.helper = helper;
        this.entropySource = entropySource;
        this.nonceEntropySource = nonceEntropySource;
    }

    JceTlsSecret adoptLocalSecret(byte[] data) {
        return new JceTlsSecret(this, data);
    }

    @Override
    public byte[] createNonce(int size) {
        byte[] nonce = new byte[size];
        this.nonceEntropySource.nextBytes(nonce);
        return nonce;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new JcaTlsCertificate(encoding, this.helper);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        try {
            switch (encryptionAlgorithm) {
                case 7: {
                    return this.createDESedeCipher(cryptoParams, macAlgorithm);
                }
                case 8: {
                    return this.createAESCipher(cryptoParams, 16, macAlgorithm);
                }
                case 15: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(cryptoParams, 16, 16);
                }
                case 103: {
                    return this.createCipher_AES_OCB(cryptoParams, 16, 12);
                }
                case 9: {
                    return this.createAESCipher(cryptoParams, 32, macAlgorithm);
                }
                case 17: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(cryptoParams, 32, 16);
                }
                case 104: {
                    return this.createCipher_AES_OCB(cryptoParams, 32, 12);
                }
                case 12: {
                    return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
                }
                case 13: {
                    return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
                }
                case 102: {
                    return this.createChaCha20Poly1305(cryptoParams);
                }
                case 0: {
                    return this.createNullCipher(cryptoParams, macAlgorithm);
                }
                case 2: {
                    return this.createRC4Cipher(cryptoParams, 16, macAlgorithm);
                }
                case 14: {
                    return this.createSEEDCipher(cryptoParams, macAlgorithm);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    @Override
    public final TlsHMAC createHMAC(int macAlgorithm) throws IOException {
        try {
            switch (macAlgorithm) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.createHMAC("HmacMD5");
                }
                case 2: {
                    return this.createHMAC("HmacSHA1");
                }
                case 3: {
                    return this.createHMAC("HmacSHA256");
                }
                case 4: {
                    return this.createHMAC("HmacSHA384");
                }
                case 5: {
                    return this.createHMAC("HmacSHA512");
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create HMAC: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpClient.init(srpGroup, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], this.createHash((short)2));
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        if (encryptionAlgorithm == 102) {
            try {
                this.helper.createCipher("ChaCha7539");
                this.helper.createMac("Poly1305");
            }
            catch (GeneralSecurityException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TlsSecret createSecret(byte[] data) {
        JceTlsSecret jceTlsSecret = this.adoptLocalSecret(Arrays.clone((byte[])data));
        return jceTlsSecret;
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    @Override
    public TlsHash createHash(short algorithm) {
        try {
            return this.createHash(this.getDigestName(algorithm));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to create message digest:" + e.getMessage(), e);
        }
    }

    @Override
    public TlsHash createHash(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null) {
            return new CombinedHash(this);
        }
        return this.createHash(signatureAndHashAlgorithm.getHash());
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new JceTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new JceTlsECDomain(this, ecConfig);
    }

    @Override
    public TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        JcaTlsCertificate jcaCert = JcaTlsCertificate.convert(certificate, this.getHelper());
        jcaCert.validateKeyUsage(32);
        final RSAPublicKey pubKeyRSA = jcaCert.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    Cipher encoding = JcaTlsCrypto.this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
                    encoding.init(3, (Key)pubKeyRSA, JcaTlsCrypto.this.getSecureRandom());
                    return encoding.doFinal(input, inOff, length);
                }
                catch (GeneralSecurityException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    protected TlsAEADCipherImpl createAEADCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsStreamCipherImpl createStreamCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceStreamCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsHMAC createHMAC(String hmacName) throws GeneralSecurityException {
        return new JceTlsHMAC(this.helper.createMac(hmacName), hmacName);
    }

    protected TlsMAC createMAC(String macName) throws GeneralSecurityException {
        return new JceTlsMAC(this.helper.createMac(macName), macName);
    }

    protected TlsHash createHash(String digestName) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(digestName));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(cryptoParams, this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm));
    }

    JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "AES", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "AES", false, cipherKeySize), this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "Camellia", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "Camellia", false, cipherKeySize), this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "DESede", true, 24), this.createCBCBlockOperator(cryptoParams, "DESede", false, 24), this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm), 24);
    }

    private TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "SEED", true, 16), this.createCBCBlockOperator(cryptoParams, "SEED", false, 16), this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm), 16);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters cryptoParams, String algorithm, boolean forEncryption, int keySize) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(cryptoParams)) {
            return this.createBlockCipher(cipherName, algorithm, keySize, forEncryption);
        }
        return this.createBlockCipherWithCBCImplicitIV(cipherName, algorithm, keySize, forEncryption);
    }

    private TlsHMAC createMAC(TlsCryptoParameters cryptoParams, int macAlgorithm) throws GeneralSecurityException, IOException {
        if (TlsImplUtils.isSSL(cryptoParams)) {
            return this.createSSL3HMAC(macAlgorithm);
        }
        return this.createHMAC(macAlgorithm);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        return new ChaCha20Poly1305Cipher(cryptoParams, this.createStreamCipher("ChaCha7539", "ChaCha7539", 32, true), this.createStreamCipher("ChaCha7539", "ChaCha7539", 32, false), this.createMAC("Poly1305"), this.createMAC("Poly1305"));
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize, 2);
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsStreamCipher createRC4Cipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsStreamCipher(cryptoParams, this.createStreamCipher("RC4", "RC4", 128, true), this.createStreamCipher("RC4", "RC4", 128, false), this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm), cipherKeySize, false);
    }

    private TlsHMAC createSSL3HMAC(int macAlgorithm) throws IOException, GeneralSecurityException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return new SSL3Mac(this.createHash(this.getDigestName((short)1)), 16, 64);
            }
            case 2: {
                return new SSL3Mac(this.createHash(this.getDigestName((short)2)), 20, 64);
            }
            case 3: {
                return new SSL3Mac(this.createHash(this.getDigestName((short)4)), 32, 64);
            }
            case 4: {
                return new SSL3Mac(this.createHash(this.getDigestName((short)5)), 48, 128);
            }
            case 5: {
                return new SSL3Mac(this.createHash(this.getDigestName((short)6)), 64, 128);
            }
        }
        throw new TlsFatalAlert(80);
    }

    String getDigestName(short algorithm) {
        String digestName;
        switch (algorithm) {
            case 1: {
                digestName = "MD5";
                break;
            }
            case 2: {
                digestName = "SHA-1";
                break;
            }
            case 3: {
                digestName = "SHA-224";
                break;
            }
            case 4: {
                digestName = "SHA-256";
                break;
            }
            case 5: {
                digestName = "SHA-384";
                break;
            }
            case 6: {
                digestName = "SHA-512";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown HashAlgorithm");
            }
        }
        return digestName;
    }

    private static class SSL3Mac
    implements TlsHMAC {
        private static final byte IPAD_BYTE = 54;
        private static final byte OPAD_BYTE = 92;
        private static final byte[] IPAD = SSL3Mac.genPad((byte)54, 48);
        private static final byte[] OPAD = SSL3Mac.genPad((byte)92, 48);
        private TlsHash digest;
        private final int digestSize;
        private final int internalBlockSize;
        private int padLength;
        private byte[] secret;

        public SSL3Mac(TlsHash digest, int digestSize, int internalBlockSize) {
            this.digest = digest;
            this.digestSize = digestSize;
            this.internalBlockSize = internalBlockSize;
            this.padLength = digestSize == 20 ? 40 : 48;
        }

        @Override
        public void setKey(byte[] key) {
            this.secret = key;
            this.reset();
        }

        @Override
        public void update(byte[] in, int inOff, int len) {
            this.digest.update(in, inOff, len);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] tmp = this.digest.calculateHash();
            this.digest.update(this.secret, 0, this.secret.length);
            this.digest.update(OPAD, 0, this.padLength);
            this.digest.update(tmp, 0, tmp.length);
            byte[] rv = this.digest.calculateHash();
            this.reset();
            return rv;
        }

        @Override
        public int getInternalBlockSize() {
            return this.internalBlockSize;
        }

        @Override
        public int getMacLength() {
            return this.digestSize;
        }

        @Override
        public void reset() {
            this.digest.reset();
            this.digest.update(this.secret, 0, this.secret.length);
            this.digest.update(IPAD, 0, this.padLength);
        }

        private static byte[] genPad(byte b, int count) {
            byte[] padding = new byte[count];
            Arrays.fill((byte[])padding, (byte)b);
            return padding;
        }
    }
}

