/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.util.Arrays;

public class SSL3Mac
implements Mac,
TlsHMAC {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = SSL3Mac.genPad((byte)54, 48);
    private static final byte[] OPAD = SSL3Mac.genPad((byte)92, 48);
    private Digest digest;
    private int padLength;
    private byte[] secret;

    public SSL3Mac(Digest digest) {
        this.digest = digest;
        this.padLength = digest.getDigestSize() == 20 ? 40 : 48;
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/SSL3MAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    public void init(CipherParameters params) {
        this.secret = Arrays.clone((byte[])((KeyParameter)params).getKey());
        this.reset();
    }

    public int getMacSize() {
        return this.digest.getDigestSize();
    }

    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void setKey(byte[] key) {
        this.secret = Arrays.clone((byte[])key);
        this.reset();
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public byte[] calculateMAC() {
        byte[] rv = new byte[this.digest.getDigestSize()];
        this.doFinal(rv, 0);
        return rv;
    }

    @Override
    public int getInternalBlockSize() {
        return ((ExtendedDigest)this.digest).getByteLength();
    }

    @Override
    public int getMacLength() {
        return this.digest.getDigestSize();
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(OPAD, 0, this.padLength);
        this.digest.update(tmp, 0, tmp.length);
        int len = this.digest.doFinal(out, outOff);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(IPAD, 0, this.padLength);
    }

    private static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill((byte[])padding, (byte)b);
        return padding;
    }
}

