/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;

public class BcTlsSecret
extends AbstractTlsSecret {
    protected final BcTlsCrypto crypto;

    public BcTlsSecret(BcTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public synchronized TlsSecret deriveSSLKeyBlock(byte[] seed, int length) {
        this.checkAlive();
        int md5Count = (length + 16 - 1) / 16;
        byte[] md5Buf = this.prf_SSL(seed, md5Count);
        BcTlsSecret result = this.crypto.adoptLocalSecret(Arrays.copyOfRange((byte[])md5Buf, (int)0, (int)length));
        Arrays.fill((byte[])md5Buf, (byte)0);
        return result;
    }

    @Override
    public synchronized TlsSecret deriveSSLMasterSecret(byte[] seed) {
        this.checkAlive();
        return this.crypto.adoptLocalSecret(this.prf_SSL(seed, 3));
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, byte[] labelSeed, int length) {
        this.checkAlive();
        byte[] result = prfAlgorithm == 0 ? this.prf_1_0(this.data, labelSeed, length) : this.prf_1_2(this.crypto.createPRFHash(prfAlgorithm), this.data, labelSeed, length);
        return this.crypto.adoptLocalSecret(result);
    }

    protected void hmacHash(Digest digest, byte[] secret, byte[] seed, byte[] output) {
        HMac mac = new HMac(digest);
        mac.init((CipherParameters)new KeyParameter(secret));
        byte[] a = seed;
        int size = digest.getDigestSize();
        int iterations = (output.length + size - 1) / size;
        byte[] b1 = new byte[mac.getMacSize()];
        byte[] b2 = new byte[mac.getMacSize()];
        for (int i = 0; i < iterations; ++i) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, size * i, Math.min(size, output.length - size * i));
        }
    }

    protected byte[] prf_SSL(byte[] seed, int md5Count) {
        Digest md5 = BcTlsCrypto.createDigest((short)1);
        Digest sha1 = BcTlsCrypto.createDigest((short)2);
        int md5Size = md5.getDigestSize();
        byte[] md5Buf = new byte[md5Size * md5Count];
        int md5Pos = 0;
        byte[] sha1Buf = new byte[sha1.getDigestSize()];
        for (int i = 0; i < md5Count; ++i) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(this.data, 0, this.data.length);
            sha1.update(seed, 0, seed.length);
            sha1.doFinal(sha1Buf, 0);
            md5.update(this.data, 0, this.data.length);
            md5.update(sha1Buf, 0, sha1Buf.length);
            md5.doFinal(md5Buf, md5Pos);
            md5Pos += md5Size;
        }
        return md5Buf;
    }

    protected byte[] prf_1_0(byte[] secret, byte[] labelSeed, int length) {
        int s_half = (secret.length + 1) / 2;
        byte[] s1 = new byte[s_half];
        byte[] s2 = new byte[s_half];
        System.arraycopy(secret, 0, s1, 0, s_half);
        System.arraycopy(secret, secret.length - s_half, s2, 0, s_half);
        byte[] b1 = new byte[length];
        byte[] b2 = new byte[length];
        this.hmacHash(BcTlsCrypto.createDigest((short)1), s1, labelSeed, b1);
        this.hmacHash(BcTlsCrypto.createDigest((short)2), s2, labelSeed, b2);
        for (int i = 0; i < length; ++i) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
        }
        return b1;
    }

    protected byte[] prf_1_2(Digest prfDigest, byte[] secret, byte[] labelSeed, int length) {
        byte[] result = new byte[length];
        this.hmacHash(prfDigest, secret, labelSeed, result);
        return result;
    }
}

