/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsVerifier;

public class BcTlsRSAVerifier
implements TlsVerifier {
    protected RSAKeyParameters pubKeyRSA;

    public BcTlsRSAVerifier(RSAKeyParameters pubKeyRSA) {
        if (pubKeyRSA == null) {
            throw new IllegalArgumentException("'pubKeyRSA' cannot be null");
        }
        if (pubKeyRSA.isPrivate()) {
            throw new IllegalArgumentException("'pubKeyRSA' must be a public key");
        }
        this.pubKeyRSA = pubKeyRSA;
    }

    @Override
    public boolean verifySignature(DigitallySigned signedParams, byte[] hash) {
        GenericSigner signer;
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            signer = new RSADigestSigner((Digest)new NullDigest(), TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner((AsymmetricBlockCipher)new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine()), (Digest)new NullDigest());
        }
        signer.init(false, (CipherParameters)this.pubKeyRSA);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signedParams.getSignature());
    }
}

