/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import org.bouncycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected BcTlsCrypto crypto;
    protected TlsECConfig ecConfig;
    protected ECDomainParameters ecDomain;

    public BcTlsECDomain(BcTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.ecConfig = ecConfig;
        this.ecDomain = this.getParameters(ecConfig);
    }

    public byte[] calculateECDHAgreement(ECPublicKeyParameters publicKey, ECPrivateKeyParameters privateKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init((CipherParameters)privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement((CipherParameters)publicKey);
        return BigIntegers.asUnsignedByteArray((int)basicAgreement.getFieldSize(), (BigInteger)agreementValue);
    }

    @Override
    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecDomain.getCurve().decodePoint(encoding);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint point = this.decodePoint(encoding);
            return new ECPublicKeyParameters(point, this.ecDomain);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKeyParameters publicKey) throws IOException {
        return this.encodePoint(publicKey.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.ecDomain, this.crypto.getSecureRandom()));
        return keyPairGenerator.generateKeyPair();
    }

    public BcTlsCrypto getCrypto() {
        return this.crypto;
    }

    public ECDomainParameters getParameters(TlsECConfig ecConfig) {
        return this.getParametersForNamedCurve(ecConfig.getNamedCurve());
    }

    public ECDomainParameters getParametersForNamedCurve(int namedCurve) {
        String curveName = NamedCurve.getNameOfSpecificCurve(namedCurve);
        if (curveName == null) {
            return null;
        }
        X9ECParameters ecP = CustomNamedCurves.getByName((String)curveName);
        if (ecP == null && (ecP = ECNamedCurveTable.getByName((String)curveName)) == null) {
            return null;
        }
        return new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }
}

