/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public abstract class BcTlsDSSVerifier
implements TlsVerifier {
    protected final AsymmetricKeyParameter pubKey;
    protected final BcTlsCrypto crypto;

    protected BcTlsDSSVerifier(BcTlsCrypto crypto, AsymmetricKeyParameter pubKey) {
        if (pubKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        if (pubKey.isPrivate()) {
            throw new IllegalArgumentException("'pubKey' must be a public key");
        }
        this.crypto = crypto;
        this.pubKey = pubKey;
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    @Override
    public boolean verifySignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), (Digest)new NullDigest());
        signer.init(false, (CipherParameters)this.pubKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(signedParams.getSignature());
    }
}

