/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public abstract class BcTlsDSSSigner
implements TlsSigner {
    private final AsymmetricKeyParameter privateKey;
    private final BcTlsCrypto crypto;

    protected BcTlsDSSSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        this.crypto = crypto;
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        this.privateKey = privateKey;
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        DSADigestSigner s = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), (Digest)new NullDigest());
        s.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        DSADigestSigner signer = s;
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

