/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import org.bouncycastle.util.BigIntegers;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhDomain;

    public BcTlsDHDomain(BcTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhDomain = this.getParameters(dhConfig);
    }

    public byte[] calculateDHAgreement(DHPublicKeyParameters publicKey, DHPrivateKeyParameters privateKey) {
        DHBasicAgreement basicAgreement = new DHBasicAgreement();
        basicAgreement.init((CipherParameters)privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement((CipherParameters)publicKey);
        return BigIntegers.asUnsignedByteArray((BigInteger)agreementValue);
    }

    @Override
    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public static BigInteger decodeParameter(byte[] encoding) throws IOException {
        return new BigInteger(1, encoding);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = BcTlsDHDomain.decodeParameter(encoding);
            return new DHPublicKeyParameters(y, this.dhDomain);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return BigIntegers.asUnsignedByteArray((BigInteger)x);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters publicKey) throws IOException {
        return this.encodeParameter(publicKey.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator keyPairGenerator = new DHBasicKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhDomain));
        return keyPairGenerator.generateKeyPair();
    }

    public BcTlsCrypto getCrypto() {
        return this.crypto;
    }

    public DHParameters getParameters(TlsDHConfig dhConfig) {
        BigInteger[] pg = dhConfig.getExplicitPG();
        if (pg != null) {
            return new DHParameters(pg[0], pg[1]);
        }
        throw new IllegalStateException("No DH configuration provided");
    }
}

