/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.bouncycastle.crypto.agreement.srp.SRP6Server;
import org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.macs.Poly1305;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.SRP6GroupParameters;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.ChaCha20Poly1305Cipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipher;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.SSL3Mac;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Times;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final DigestRandomGenerator nonceGen;
    private final SecureRandom entropySource;
    private static long counter = Times.nanoTime();

    public BcTlsCrypto(SecureRandom entropySource) {
        this.entropySource = entropySource;
        Digest digest = BcTlsCrypto.createDigest((short)4);
        this.nonceGen = new DigestRandomGenerator(digest);
        this.nonceGen.addSeedMaterial(BcTlsCrypto.nextCounterValue());
        this.nonceGen.addSeedMaterial(Times.nanoTime());
        byte[] seed = new byte[digest.getDigestSize()];
        entropySource.nextBytes(seed);
        this.nonceGen.addSeedMaterial(seed);
    }

    BcTlsSecret adoptLocalSecret(byte[] data) {
        return new BcTlsSecret(this, data);
    }

    @Override
    public byte[] createNonce(int size) {
        byte[] nonce = new byte[size];
        this.nonceGen.nextBytes(nonce);
        return nonce;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(cryptoParams, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(cryptoParams, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 103: {
                return this.createCipher_AES_OCB(cryptoParams, 16, 12);
            }
            case 9: {
                return this.createAESCipher(cryptoParams, 32, macAlgorithm);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 104: {
                return this.createCipher_AES_OCB(cryptoParams, 32, 12);
            }
            case 12: {
                return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 102: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(cryptoParams, 16, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(cryptoParams, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new BcTlsECDomain(this, ecConfig);
    }

    @Override
    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificate bcCert = BcTlsCertificate.convert(this, certificate);
        bcCert.validateKeyUsage(32);
        final RSAKeyParameters pubKeyRSA = bcCert.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                    encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubKeyRSA, BcTlsCrypto.this.getSecureRandom()));
                    return encoding.processBlock(input, inOff, length);
                }
                catch (InvalidCipherTextException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TlsSecret createSecret(byte[] data) {
        BcTlsSecret bcTlsSecret = this.adoptLocalSecret(Arrays.clone((byte[])data));
        return bcTlsSecret;
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.entropySource.nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    static Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    @Override
    public TlsHash createHash(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null) {
            return new CombinedHash(this);
        }
        return new BcTlsHash(signatureAndHashAlgorithm.getHash(), BcTlsCrypto.createDigest(signatureAndHashAlgorithm.getHash()));
    }

    @Override
    public TlsHash createHash(short algorithm) {
        return new BcTlsHash(algorithm, BcTlsCrypto.createDigest(algorithm));
    }

    public static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public Digest createPRFHash(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                return new CombinedPRF();
            }
        }
        return BcTlsCrypto.createDigest(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createAESBlockCipher(), true), new BlockOperator(this.createAESBlockCipher(), false), this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createCamelliaBlockCipher(), true), new BlockOperator(this.createCamelliaBlockCipher(), false), this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new ChaCha20Poly1305Cipher(cryptoParams, new StreamOperator((StreamCipher)new ChaCha7539Engine(), true), new StreamOperator((StreamCipher)new ChaCha7539Engine(), false), new MacOperator((Mac)new Poly1305()), new MacOperator((Mac)new Poly1305()));
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_CCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_CCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_GCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_OCB(), true), new AeadOperator(this.createAEADBlockCipher_AES_OCB(), false), cipherKeySize, macSize, 2);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), true), new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createDESedeBlockCipher(), true), new BlockOperator(this.createDESedeBlockCipher(), false), this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm));
    }

    protected TlsStreamCipher createRC4Cipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(cryptoParams, new StreamOperator(this.createRC4StreamCipher(), true), new StreamOperator(this.createRC4StreamCipher(), false), this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm), cipherKeySize, false);
    }

    protected TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createSEEDBlockCipher(), true), new BlockOperator(this.createSEEDBlockCipher(), false), this.createMac(cryptoParams, macAlgorithm), this.createMac(cryptoParams, macAlgorithm), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_OCB() {
        return new OCBBlockCipher(this.createAESEngine(), this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new SEEDEngine());
    }

    private TlsHMAC createMac(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        if (TlsImplUtils.isSSL(cryptoParams)) {
            return this.createSSl3HMAC((short)macAlgorithm);
        }
        return this.createHMAC((short)macAlgorithm);
    }

    protected Digest createHMACDigest(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return BcTlsCrypto.createDigest((short)1);
            }
            case 2: {
                return BcTlsCrypto.createDigest((short)2);
            }
            case 3: {
                return BcTlsCrypto.createDigest((short)4);
            }
            case 4: {
                return BcTlsCrypto.createDigest((short)5);
            }
            case 5: {
                return BcTlsCrypto.createDigest((short)6);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsHMAC createHMAC(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return new HMacOperator(BcTlsCrypto.createDigest((short)1));
            }
            case 2: {
                return new HMacOperator(BcTlsCrypto.createDigest((short)2));
            }
            case 3: {
                return new HMacOperator(BcTlsCrypto.createDigest((short)4));
            }
            case 4: {
                return new HMacOperator(BcTlsCrypto.createDigest((short)5));
            }
            case 5: {
                return new HMacOperator(BcTlsCrypto.createDigest((short)6));
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpClient.init(srpGroup, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], (Digest)new SHA1Digest());
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    protected TlsHMAC createSSl3HMAC(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return new SSL3Mac(BcTlsCrypto.createDigest((short)1));
            }
            case 2: {
                return new SSL3Mac(BcTlsCrypto.createDigest((short)2));
            }
            case 3: {
                return new SSL3Mac(BcTlsCrypto.createDigest((short)4));
            }
            case 4: {
                return new SSL3Mac(BcTlsCrypto.createDigest((short)5));
            }
            case 5: {
                return new SSL3Mac(BcTlsCrypto.createDigest((short)6));
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        @Override
        public void setKey(byte[] key) {
            this.hmac.init((CipherParameters)new KeyParameter(key));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        @Override
        public void reset() {
            this.hmac.reset();
        }
    }

    private class MacOperator
    implements TlsMAC {
        private final Mac mac;

        MacOperator(Mac mac) {
            this.mac = mac;
        }

        @Override
        public void setKey(byte[] key) {
            this.mac.init((CipherParameters)new KeyParameter(key));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.mac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.mac.getMacSize()];
            this.mac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public int getMacLength() {
            return this.mac.getMacSize();
        }

        @Override
        public void reset() {
            this.mac.reset();
        }
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean isEncrypting;
        private final AEADBlockCipher cipher;
        private KeyParameter key;

        public AeadOperator(AEADBlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key) {
            this.key = new KeyParameter(key);
        }

        @Override
        public void init(byte[] nonce, int macSize, byte[] additionalData) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, macSize * 8, nonce, additionalData));
        }

        @Override
        public int getOutputSize(int inputLength) {
            return this.cipher.getOutputSize(inputLength);
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            try {
                return len + this.cipher.doFinal(output, outputOffset + len);
            }
            catch (InvalidCipherTextException e) {
                e.printStackTrace();
                throw new RuntimeCryptoException(e.toString());
            }
        }
    }

    private class StreamOperator
    implements TlsStreamCipherImpl {
        private final boolean isEncrypting;
        private final StreamCipher cipher;
        private KeyParameter key;

        StreamOperator(StreamCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key) {
            this.key = new KeyParameter(key);
        }

        @Override
        public void init(byte[] iv) {
            if (iv != null) {
                this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, iv));
            } else {
                this.cipher.init(this.isEncrypting, (CipherParameters)this.key);
            }
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            return this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
        }
    }

    private class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key) {
            this.key = new KeyParameter(key);
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, new byte[this.cipher.getBlockSize()]));
        }

        @Override
        public void init(byte[] iv) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, iv));
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int blockSize = this.cipher.getBlockSize();
            for (int i = 0; i < inputLength; i += blockSize) {
                this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            }
            return inputLength;
        }

        @Override
        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }
    }

    public class CombinedPRF
    implements Digest {
        private final MD5Digest md5 = new MD5Digest();
        private final SHA1Digest sha1 = new SHA1Digest();

        CombinedPRF() {
        }

        public String getAlgorithmName() {
            return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName();
        }

        public int getDigestSize() {
            return this.md5.getDigestSize() + this.sha1.getDigestSize();
        }

        public void update(byte input) {
            this.md5.update(input);
            this.sha1.update(input);
        }

        public void update(byte[] input, int inOff, int len) {
            this.md5.update(input, inOff, len);
            this.sha1.update(input, inOff, len);
        }

        public int doFinal(byte[] output, int outOff) {
            int i1 = this.md5.doFinal(output, outOff);
            int i2 = this.sha1.doFinal(output, outOff + i1);
            return i1 + i2;
        }

        public void reset() {
            this.md5.reset();
            this.sha1.reset();
        }
    }

    private static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short hashAlgorithm, Digest digest) {
            this.hashAlgorithm = hashAlgorithm;
            this.digest = digest;
        }

        @Override
        public void update(byte[] data, int offSet, int length) {
            this.digest.update(data, offSet, length);
        }

        @Override
        public byte[] calculateHash() {
            byte[] rv = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(rv, 0);
            return rv;
        }

        @Override
        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCrypto.cloneDigest(this.hashAlgorithm, this.digest));
        }

        @Override
        public void reset() {
            this.digest.reset();
        }
    }
}

