/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;

public class BcTlsCertificate
implements TlsCertificate {
    private final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this.crypto = crypto;
        try {
            this.certificate = Certificate.getInstance((Object)encoding);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("unable to decode certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                return new BcTlsRSAVerifier(this.getPubKeyRSA());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (publicKey instanceof RSAKeyParameters) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (publicKey instanceof ECPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        DHPublicKeyParameters pubKeyDH;
        try {
            pubKeyDH = (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDH(pubKeyDH);
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        DSAPublicKeyParameters pubKeyDSS;
        try {
            pubKeyDSS = (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDSS(pubKeyDSS);
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        ECPublicKeyParameters pubKeyEC;
        try {
            pubKeyEC = (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyEC(pubKeyEC);
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        RSAKeyParameters pubKeyRSA;
        try {
            pubKeyRSA = (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyRSA(pubKeyRSA);
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo keyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = this.certificate.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions((Extensions)exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DHPublicKeyParameters validatePubKeyDH(DHPublicKeyParameters pubKeyDH) throws IOException {
        TlsDHUtils.validateDHPublicValues(pubKeyDH.getY(), pubKeyDH.getParameters().getP());
        return pubKeyDH;
    }

    protected DSAPublicKeyParameters validatePubKeyDSS(DSAPublicKeyParameters pubKeyDSS) throws IOException {
        return pubKeyDSS;
    }

    protected ECPublicKeyParameters validatePubKeyEC(ECPublicKeyParameters pubKeyEC) throws IOException {
        return pubKeyEC;
    }

    protected RSAKeyParameters validatePubKeyRSA(RSAKeyParameters pubKeyRSA) throws IOException {
        return pubKeyRSA;
    }
}

