/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.BigIntegers;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new DHCredentialedAgreement(crypto, privateKey, certificate);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new ECCredentialedAgreement(crypto, privateKey, certificate);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(peerCertificate);
    }

    private class ECCredentialedAgreement
    implements TlsCredentialedAgreement {
        private final Certificate certificate;
        private final BcTlsCrypto crypto;
        private final AsymmetricKeyParameter privateKey;
        protected BasicAgreement basicAgreement = new ECDHBasicAgreement();

        public ECCredentialedAgreement(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate) {
            this.crypto = crypto;
            this.privateKey = privateKey;
            this.certificate = certificate;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            TlsCertificate localCert = this.certificate.getCertificateAt(0);
            AsymmetricKeyParameter peerPublicKey = BcTlsCertificate.convert(this.crypto, localCert).getPublicKey();
            this.basicAgreement.init((CipherParameters)this.privateKey);
            BigInteger agreementValue = this.basicAgreement.calculateAgreement((CipherParameters)peerPublicKey);
            return this.crypto.adoptLocalSecret(BigIntegers.asUnsignedByteArray((int)this.basicAgreement.getFieldSize(), (BigInteger)agreementValue));
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    private class DHCredentialedAgreement
    implements TlsCredentialedAgreement {
        private final Certificate certificate;
        private final BcTlsCrypto crypto;
        protected AsymmetricKeyParameter privateKey;
        protected BasicAgreement basicAgreement = new DHBasicAgreement();

        public DHCredentialedAgreement(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate) {
            this.crypto = crypto;
            this.privateKey = privateKey;
            this.certificate = certificate;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            TlsCertificate localCert = this.certificate.getCertificateAt(0);
            AsymmetricKeyParameter peerPublicKey = BcTlsCertificate.convert(this.crypto, localCert).getPublicKey();
            this.basicAgreement.init((CipherParameters)this.privateKey);
            BigInteger agreementValue = this.basicAgreement.calculateAgreement((CipherParameters)peerPublicKey);
            return this.crypto.adoptLocalSecret(BigIntegers.asUnsignedByteArray((BigInteger)agreementValue));
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

