/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

class TlsSuiteHMac
implements TlsSuiteMac {
    protected TlsCryptoParameters cryptoParams;
    protected byte[] secret;
    protected TlsHMAC mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsSuiteHMac(TlsCryptoParameters cryptoParams, TlsHMAC mac) {
        this.cryptoParams = cryptoParams;
        this.digestBlockSize = mac.getInternalBlockSize();
        this.digestOverhead = this.digestBlockSize / 8;
        if (TlsImplUtils.isSSL(cryptoParams) && mac.getMacLength() == 20) {
            this.digestOverhead = 4;
        }
        this.mac = mac;
    }

    @Override
    public void setKey(byte[] key) throws IOException {
        this.secret = Arrays.clone((byte[])key);
        this.mac.setKey(this.secret);
        this.macLength = this.mac.getMacLength();
        if (this.cryptoParams.getSecurityParameters().isTruncatedHMac()) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    @Override
    public int getSize() {
        return this.macLength;
    }

    @Override
    public byte[] calculateMac(long seqNo, short type, byte[] message, int offset, int length) {
        ProtocolVersion serverVersion = this.cryptoParams.getServerVersion();
        boolean isSSL = serverVersion.isSSL();
        byte[] macHeader = new byte[isSSL ? 11 : 13];
        TlsUtils.writeUint64(seqNo, macHeader, 0);
        TlsUtils.writeUint8(type, macHeader, 8);
        if (!isSSL) {
            TlsUtils.writeVersion(serverVersion, macHeader, 9);
        }
        TlsUtils.writeUint16(length, macHeader, macHeader.length - 2);
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, length);
        return this.truncate(this.mac.calculateMAC());
    }

    @Override
    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] message, int offset, int length, int expectedLength, byte[] dummyData) {
        byte[] result = this.calculateMac(seqNo, type, message, offset, length);
        int headerLength = TlsImplUtils.isSSL(this.cryptoParams) ? 11 : 13;
        int extra = this.getDigestBlockCount(headerLength + expectedLength) - this.getDigestBlockCount(headerLength + length);
        while (--extra >= 0) {
            this.mac.update(dummyData, 0, this.digestBlockSize);
        }
        this.mac.update(dummyData, 0, 1);
        this.mac.reset();
        return result;
    }

    protected int getDigestBlockCount(int inputLength) {
        return (inputLength + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] bs) {
        if (bs.length <= this.macLength) {
            return bs;
        }
        return Arrays.copyOf((byte[])bs, (int)this.macLength);
    }
}

