/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsCryptoParameters cryptoParams;
    protected TlsStreamCipherImpl encryptCipher;
    protected TlsStreamCipherImpl decryptCipher;
    protected TlsSuiteMac writeMac;
    protected TlsSuiteMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsCryptoParameters cryptoParams, TlsStreamCipherImpl encryptCipher, TlsStreamCipherImpl decryptCipher, TlsHMAC clientWriteDigest, TlsHMAC serverWriteDigest, int cipherKeySize, boolean usesNonce) throws IOException {
        byte[] decryptParams;
        byte[] encryptParams;
        boolean isServer = cryptoParams.isServer();
        this.cryptoParams = cryptoParams;
        this.usesNonce = usesNonce;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        int key_block_size = 2 * cipherKeySize + clientWriteDigest.getMacLength() + serverWriteDigest.getMacLength();
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        TlsSuiteHMac clientWriteMac = new TlsSuiteHMac(cryptoParams, clientWriteDigest);
        clientWriteMac.setKey(Arrays.copyOfRange((byte[])key_block, (int)offset, (int)(offset + clientWriteDigest.getMacLength())));
        TlsSuiteHMac serverWriteMac = new TlsSuiteHMac(cryptoParams, serverWriteDigest);
        serverWriteMac.setKey(Arrays.copyOfRange((byte[])key_block, (int)(offset += clientWriteDigest.getMacLength()), (int)(offset + serverWriteDigest.getMacLength())));
        byte[] clientWriteKey = Arrays.copyOfRange((byte[])key_block, (int)(offset += serverWriteDigest.getMacLength()), (int)(offset + cipherKeySize));
        byte[] serverWriteKey = Arrays.copyOfRange((byte[])key_block, (int)(offset += cipherKeySize), (int)(offset + cipherKeySize));
        if ((offset += cipherKeySize) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (isServer) {
            this.writeMac = serverWriteMac;
            this.readMac = clientWriteMac;
            encryptParams = serverWriteKey;
            decryptParams = clientWriteKey;
        } else {
            this.writeMac = clientWriteMac;
            this.readMac = serverWriteMac;
            encryptParams = clientWriteKey;
            decryptParams = serverWriteKey;
        }
        this.encryptCipher.setKey(encryptParams);
        this.decryptCipher.setKey(decryptParams);
        if (usesNonce) {
            byte[] dummyNonce = new byte[8];
            this.encryptCipher.init(dummyNonce);
            this.decryptCipher.init(dummyNonce);
        } else {
            this.encryptCipher.init(null);
            this.decryptCipher.init(null);
        }
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, seqNo);
        }
        byte[] outBuf = new byte[len + this.writeMac.getSize()];
        byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        System.arraycopy(plaintext, offset, outBuf, 0, len);
        System.arraycopy(mac, 0, outBuf, len, mac.length);
        this.encryptCipher.doFinal(outBuf, 0, outBuf.length, outBuf, 0);
        return outBuf;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int macSize;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, seqNo);
        }
        if (len < (macSize = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int plaintextLength = len - macSize;
        byte[] deciphered = new byte[len];
        this.decryptCipher.doFinal(ciphertext, offset, len, deciphered, 0);
        this.checkMAC(seqNo, type, deciphered, plaintextLength, len, deciphered, 0, plaintextLength);
        return Arrays.copyOfRange((byte[])deciphered, (int)0, (int)plaintextLength);
    }

    protected void checkMAC(long seqNo, short type, byte[] recBuf, int recStart, int recEnd, byte[] calcBuf, int calcOff, int calcLen) throws IOException {
        byte[] computedMac;
        byte[] receivedMac = Arrays.copyOfRange((byte[])recBuf, (int)recStart, (int)recEnd);
        if (!Arrays.constantTimeAreEqual((byte[])receivedMac, (byte[])(computedMac = this.readMac.calculateMac(seqNo, type, calcBuf, calcOff, calcLen)))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(TlsStreamCipherImpl cipher, boolean forEncryption, long seqNo) throws IOException {
        byte[] nonce = new byte[8];
        TlsUtils.writeUint64(seqNo, nonce, 0);
        cipher.init(nonce);
    }
}

