/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class ChaCha20Poly1305Cipher
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsCryptoParameters context;
    protected TlsMAC writeMac;
    protected TlsMAC readMac;
    protected TlsStreamCipherImpl encryptCipher;
    protected TlsStreamCipherImpl decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public ChaCha20Poly1305Cipher(TlsCryptoParameters context, TlsStreamCipherImpl encryptCipher, TlsStreamCipherImpl decryptCipher, TlsMAC writeMac, TlsMAC readMac) throws IOException {
        byte[] decryptKey;
        byte[] encryptKey;
        if (!TlsImplUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        int cipherKeySize = 32;
        int fixed_iv_length = 12;
        int key_block_size = 2 * cipherKeySize + 2 * fixed_iv_length;
        byte[] key_block = TlsImplUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        byte[] client_write_key = Arrays.copyOfRange((byte[])key_block, (int)offset, (int)(offset + cipherKeySize));
        byte[] server_write_key = Arrays.copyOfRange((byte[])key_block, (int)(offset += cipherKeySize), (int)(offset + cipherKeySize));
        byte[] client_write_IV = Arrays.copyOfRange((byte[])key_block, (int)(offset += cipherKeySize), (int)(offset + fixed_iv_length));
        byte[] server_write_IV = Arrays.copyOfRange((byte[])key_block, (int)(offset += fixed_iv_length), (int)(offset + fixed_iv_length));
        if ((offset += fixed_iv_length) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        this.writeMac = writeMac;
        this.readMac = readMac;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (context.isServer()) {
            encryptKey = server_write_key;
            decryptKey = client_write_key;
            this.encryptIV = server_write_IV;
            this.decryptIV = client_write_IV;
        } else {
            encryptKey = client_write_key;
            decryptKey = server_write_key;
            this.encryptIV = client_write_IV;
            this.decryptIV = server_write_IV;
        }
        this.encryptCipher.setKey(encryptKey);
        this.encryptCipher.init(this.encryptIV);
        this.decryptCipher.setKey(decryptKey);
        this.decryptCipher.init(this.decryptIV);
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - 16;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        this.initRecord(this.encryptCipher, seqNo, this.encryptIV);
        byte[] cipherOut = new byte[64 + len];
        System.arraycopy(plaintext, offset, cipherOut, 64, len);
        this.encryptCipher.doFinal(cipherOut, 0, cipherOut.length, cipherOut, 0);
        byte[] output = new byte[len + 16];
        byte[] macKey = Arrays.copyOfRange((byte[])cipherOut, (int)0, (int)32);
        System.arraycopy(cipherOut, 64, output, 0, len);
        Arrays.fill((byte[])cipherOut, (byte)0);
        this.writeMac.setKey(macKey);
        byte[] additionalData = this.getAdditionalData(seqNo, type, len);
        byte[] mac = this.calculateRecordMAC(this.writeMac, additionalData, output, 0, len);
        System.arraycopy(mac, 0, output, len, mac.length);
        return output;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        this.initRecord(this.decryptCipher, seqNo, this.decryptIV);
        int plaintextLength = len - 16;
        byte[] cipherOut = new byte[64 + plaintextLength];
        System.arraycopy(ciphertext, offset, cipherOut, 64, plaintextLength);
        this.decryptCipher.doFinal(cipherOut, 0, cipherOut.length, cipherOut, 0);
        byte[] macKey = Arrays.copyOfRange((byte[])cipherOut, (int)0, (int)32);
        this.readMac.setKey(macKey);
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        byte[] calculatedMAC = this.calculateRecordMAC(this.readMac, additionalData, ciphertext, offset, plaintextLength);
        byte[] receivedMAC = Arrays.copyOfRange((byte[])ciphertext, (int)(offset + plaintextLength), (int)(offset + len));
        byte[] output = new byte[plaintextLength];
        System.arraycopy(cipherOut, 64, output, 0, plaintextLength);
        Arrays.fill((byte[])cipherOut, (byte)0);
        if (!Arrays.constantTimeAreEqual((byte[])calculatedMAC, (byte[])receivedMAC)) {
            throw new TlsFatalAlert(20);
        }
        return output;
    }

    protected void initRecord(TlsStreamCipherImpl cipher, long seqNo, byte[] iv) throws IOException {
        byte[] nonce = this.calculateNonce(seqNo, iv);
        cipher.init(nonce);
    }

    protected byte[] calculateNonce(long seqNo, byte[] iv) {
        byte[] nonce = new byte[12];
        TlsUtils.writeUint64(seqNo, nonce, 4);
        for (int i = 0; i < 12; ++i) {
            int n = i;
            nonce[n] = (byte)(nonce[n] ^ iv[i]);
        }
        return nonce;
    }

    protected byte[] calculateRecordMAC(TlsMAC mac, byte[] additionalData, byte[] buf, int off, int len) {
        this.updateRecordMACText(mac, additionalData, 0, additionalData.length);
        this.updateRecordMACText(mac, buf, off, len);
        this.updateRecordMACLength(mac, additionalData.length);
        this.updateRecordMACLength(mac, len);
        return mac.calculateMAC();
    }

    protected void updateRecordMACLength(TlsMAC mac, int len) {
        byte[] longLen = Pack.longToLittleEndian((long)((long)len & 0xFFFFFFFFL));
        mac.update(longLen, 0, longLen.length);
    }

    protected void updateRecordMACText(TlsMAC mac, byte[] buf, int off, int len) {
        mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            mac.update(ZEROES, 0, 16 - partial);
        }
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] additional_data = new byte[13];
        TlsUtils.writeUint64(seqNo, additional_data, 0);
        TlsUtils.writeUint8(type, additional_data, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), additional_data, 9);
        TlsUtils.writeUint16(len, additional_data, 11);
        return additional_data;
    }
}

