/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Set;
import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_elliptic_curves = Integers.valueOf((int)10);
    public static final Integer EXT_ec_point_formats = Integers.valueOf((int)11);

    public static void addSupportedEllipticCurvesExtension(Hashtable extensions, int[] namedCurves) throws IOException {
        extensions.put(EXT_elliptic_curves, TlsECCUtils.createSupportedEllipticCurvesExtension(namedCurves));
    }

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static int[] getSupportedEllipticCurvesExtension(Hashtable extensions, Set<Integer> acceptedCurves) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_elliptic_curves);
        return extensionData == null ? null : TlsECCUtils.readSupportedEllipticCurvesExtension(extensionData, acceptedCurves);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_ec_point_formats);
        return extensionData == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(extensionData);
    }

    public static byte[] createSupportedEllipticCurvesExtension(int[] namedCurves) throws IOException {
        if (namedCurves == null || namedCurves.length < 1) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(namedCurves);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null || !Arrays.contains((short[])ecPointFormats, (short)0)) {
            ecPointFormats = Arrays.append((short[])ecPointFormats, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(ecPointFormats);
    }

    public static int[] readSupportedEllipticCurvesExtension(byte[] extensionData, Set<Integer> acceptedCurves) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        int length = TlsUtils.readUint16(buf);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] namedCurves = TlsUtils.readUint16Array(length / 2, buf);
        TlsProtocol.assertEmpty(buf);
        int count = 0;
        for (int i = 0; i != namedCurves.length; ++i) {
            if (!acceptedCurves.contains(namedCurves[i])) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (count != namedCurves.length) {
            int ind = 0;
            int[] acceptedNamedCurves = new int[count];
            for (int i = 0; i != namedCurves.length; ++i) {
                if (!acceptedCurves.contains(namedCurves[i])) continue;
                acceptedNamedCurves[ind++] = namedCurves[i];
            }
            return acceptedNamedCurves;
        }
        return namedCurves;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        short length = TlsUtils.readUint8(buf);
        if (length < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] ecPointFormats = TlsUtils.readUint8Array(length, buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.contains((short[])ecPointFormats, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return ecPointFormats;
    }

    public static boolean containsECCipherSuites(int[] cipherSuites) {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!TlsECCUtils.isECCipherSuite(cipherSuites[i])) continue;
            return true;
        }
        return false;
    }

    public static int getMinimumCurveBits(int cipherSuite) {
        switch (cipherSuite) {
            case 65024: 
            case 65026: 
            case 65028: {
                return 255;
            }
            case 65025: 
            case 65027: 
            case 65029: {
                return 384;
            }
        }
        if (!TlsECCUtils.isECCipherSuite(cipherSuite)) {
            return 0;
        }
        return 1;
    }

    public static boolean isECCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static short getCompressionFormat(int namedCurve) throws IOException {
        if (NamedCurve.isPrime(namedCurve)) {
            return 1;
        }
        if (NamedCurve.isChar2(namedCurve)) {
            return 2;
        }
        throw new TlsFatalAlert(47);
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, int namedCurve) throws IOException {
        return TlsECCUtils.isCompressionPreferred(peerECPointFormats, TlsECCUtils.getCompressionFormat(namedCurve));
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, short compressionFormat) {
        if (peerECPointFormats == null || compressionFormat == 0) {
            return false;
        }
        for (int i = 0; i < peerECPointFormats.length; ++i) {
            short ecPointFormat = peerECPointFormats[i];
            if (ecPointFormat == 0) {
                return false;
            }
            if (ecPointFormat != compressionFormat) continue;
            return true;
        }
        return false;
    }

    public static void checkPointEncoding(short[] localECPointFormats, int namedCurve, byte[] encoding) throws IOException {
        if (encoding == null || encoding.length < 1) {
            throw new TlsFatalAlert(47);
        }
        short actualFormat = TlsECCUtils.getActualFormat(namedCurve, encoding);
        TlsECCUtils.checkActualFormat(localECPointFormats, actualFormat);
    }

    public static void checkActualFormat(short[] localECPointFormats, short actualFormat) throws IOException {
        if (!(actualFormat == 0 || localECPointFormats != null && Arrays.contains((short[])localECPointFormats, (short)actualFormat))) {
            throw new TlsFatalAlert(47);
        }
    }

    public static short getActualFormat(int namedCurve, byte[] encoding) throws IOException {
        switch (encoding[0]) {
            case 2: 
            case 3: {
                return TlsECCUtils.getCompressionFormat(namedCurve);
            }
            case 4: {
                return 0;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig readECConfig(short[] peerECPointFormats, InputStream input) throws IOException {
        short curveType = TlsUtils.readUint8(input);
        if (curveType != 3) {
            throw new TlsFatalAlert(40);
        }
        int namedCurve = TlsUtils.readUint16(input);
        if (!NamedCurve.refersToASpecificNamedCurve(namedCurve)) {
            throw new TlsFatalAlert(47);
        }
        boolean compressed = TlsECCUtils.isCompressionPreferred(peerECPointFormats, namedCurve);
        TlsECConfig result = new TlsECConfig();
        result.setNamedCurve(namedCurve);
        result.setPointCompression(compressed);
        return result;
    }

    public static TlsECConfig receiveECConfig(TlsECConfigVerifier ecConfigVerifier, short[] peerECPointFormats, InputStream input) throws IOException {
        TlsECConfig ecConfig = TlsECCUtils.readECConfig(peerECPointFormats, input);
        if (!ecConfigVerifier.accept(ecConfig)) {
            throw new TlsFatalAlert(47);
        }
        return ecConfig;
    }

    public static void writeECConfig(TlsECConfig ecConfig, OutputStream output) throws IOException {
        TlsECCUtils.writeNamedECParameters(ecConfig.getNamedCurve(), output);
    }

    public static void writeNamedECParameters(int namedCurve, OutputStream output) throws IOException {
        if (!NamedCurve.refersToASpecificNamedCurve(namedCurve)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedCurve);
        TlsUtils.writeUint16(namedCurve, output);
    }
}

