/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHash;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable<Short, TlsHash> hashes;
    private Short prfHashAlgorithm;

    DeferredHash(TlsContext context) {
        this.context = context;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = null;
    }

    private DeferredHash(TlsContext context, Short prfHashAlgorithm, TlsHash prfHash) {
        this.context = context;
        this.buf = null;
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = prfHashAlgorithm;
        this.hashes.put(prfHashAlgorithm, prfHash);
    }

    private DeferredHash(DeferredHash defHash) {
        this.context = defHash.context;
        this.buf = null;
        this.prfHashAlgorithm = defHash.prfHashAlgorithm;
        this.hashes = (Hashtable)defHash.hashes.clone();
        throw new IllegalStateException("not complete");
    }

    @Override
    public TlsHandshakeHash notifyPRFDetermined() {
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            CombinedHash legacyHash = new CombinedHash(this.context);
            this.buf.updateDigest(legacyHash);
            return legacyHash.notifyPRFDetermined();
        }
        this.prfHashAlgorithm = TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm);
        this.checkTrackingHash(this.prfHashAlgorithm);
        return this;
    }

    @Override
    public void trackHashAlgorithm(short hashAlgorithm) {
        if (this.buf == null) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(hashAlgorithm);
    }

    @Override
    public void sealHashAlgorithms() {
        this.checkStopBuffering();
    }

    @Override
    public TlsHandshakeHash stopTracking() {
        TlsHash prfHash = (TlsHash)this.hashes.get(this.prfHashAlgorithm).clone();
        if (this.buf != null) {
            this.buf.updateDigest(prfHash);
        }
        DeferredHash result = new DeferredHash(this.context, this.prfHashAlgorithm, prfHash);
        return result;
    }

    @Override
    public TlsHash forkPRFHash() {
        this.checkStopBuffering();
        if (this.buf != null) {
            TlsHash prfHash = this.context.getCrypto().createHash(this.prfHashAlgorithm);
            this.buf.updateDigest(prfHash);
            return prfHash;
        }
        return (TlsHash)this.hashes.get(this.prfHashAlgorithm).clone();
    }

    @Override
    public byte[] getFinalHash(short hashAlgorithm) {
        TlsHash d = this.hashes.get(hashAlgorithm);
        if (d == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(hashAlgorithm) + " is not being tracked");
        }
        d = (TlsHash)d.clone();
        if (this.buf != null) {
            this.buf.updateDigest(d);
        }
        return d.calculateHash();
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.buf != null) {
            this.buf.write(input, inOff, len);
            return;
        }
        Enumeration<TlsHash> e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = e.nextElement();
            hash.update(input, inOff, len);
        }
    }

    @Override
    public byte[] calculateHash() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    @Override
    public Object clone() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    @Override
    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration<TlsHash> e = this.hashes.elements();
        while (e.hasMoreElements()) {
            TlsHash hash = e.nextElement();
            hash.reset();
        }
    }

    protected void checkStopBuffering() {
        if (this.buf != null && this.hashes.size() <= 4) {
            Enumeration<TlsHash> e = this.hashes.elements();
            while (e.hasMoreElements()) {
                TlsHash hash = e.nextElement();
                this.buf.updateDigest(hash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short hashAlgorithm) {
        if (!this.hashes.containsKey(hashAlgorithm)) {
            TlsHash hash = this.context.getCrypto().createHash(hashAlgorithm);
            this.hashes.put(hashAlgorithm, hash);
        }
    }
}

