/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected int[] namedCurves;

    public DefaultTlsECConfigVerifier(int minimumCurveBits, int[] namedCurves) {
        this.minimumCurveBits = minimumCurveBits;
        this.namedCurves = Arrays.clone((int[])namedCurves);
    }

    @Override
    public boolean accept(TlsECConfig ecConfig) {
        int namedCurve = ecConfig.getNamedCurve();
        if (NamedCurve.getCurveBits(namedCurve) < this.minimumCurveBits) {
            return false;
        }
        return this.namedCurves == null || Arrays.contains((int[])this.namedCurves, (int)namedCurve);
    }
}

