/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;

public class DefaultTlsDHConfigVerifier
implements TlsDHConfigVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 1024;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dhParameters) {
        DEFAULT_GROUPS.addElement(TlsDHUtils.selectDHConfig(dhParameters));
    }

    public DefaultTlsDHConfigVerifier() {
        this(1024);
    }

    public DefaultTlsDHConfigVerifier(int minimumPrimeBits) {
        this(DEFAULT_GROUPS, minimumPrimeBits);
    }

    public DefaultTlsDHConfigVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = groups;
        this.minimumPrimeBits = minimumPrimeBits;
    }

    @Override
    public boolean accept(TlsDHConfig dhConfig) {
        if (dhConfig.getExplicitPG()[0].bitLength() < this.getMinimumPrimeBits()) {
            return false;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dhConfig, (TlsDHConfig)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(TlsDHConfig a, TlsDHConfig b) {
        return a == b || this.areParametersEqual(a.getExplicitPG(), b.getExplicitPG());
    }

    protected boolean areParametersEqual(BigInteger[] pgA, BigInteger[] pgB) {
        return pgA == pgB || this.areParametersEqual(pgA[0], pgB[0]) && this.areParametersEqual(pgA[1], pgB[1]);
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    static {
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc5996_768);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc5996_1024);
    }
}

