/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.SSL3Constants;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

public class CombinedHash
implements TlsHandshakeHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    public CombinedHash(TlsContext context) {
        this(context.getCrypto());
        this.context = context;
    }

    public CombinedHash(TlsCrypto crypto) {
        this.crypto = crypto;
        this.md5 = crypto.createHash((short)1);
        this.sha1 = crypto.createHash((short)2);
    }

    public CombinedHash(CombinedHash t) {
        this.context = t.context;
        this.crypto = t.crypto;
        this.md5 = (TlsHash)t.md5.clone();
        this.sha1 = (TlsHash)t.sha1.clone();
    }

    @Override
    public TlsHandshakeHash notifyPRFDetermined() {
        return this;
    }

    @Override
    public void trackHashAlgorithm(short hashAlgorithm) {
        throw new IllegalStateException("CombinedHash only supports calculating the legacy PRF for handshake hash");
    }

    @Override
    public void sealHashAlgorithms() {
    }

    @Override
    public TlsHandshakeHash stopTracking() {
        return new CombinedHash(this);
    }

    @Override
    public TlsHash forkPRFHash() {
        return new CombinedHash(this);
    }

    @Override
    public byte[] getFinalHash(short hashAlgorithm) {
        throw new IllegalStateException("CombinedHash doesn't support multiple hashes");
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        this.md5.update(input, inOff, len);
        this.sha1.update(input, inOff, len);
    }

    @Override
    public byte[] calculateHash() {
        if (this.context != null && TlsUtils.isSSL(this.context)) {
            byte[] ipad = SSL3Constants.getInputPad();
            byte[] opad = SSL3Constants.getOutputPad();
            this.ssl3Complete(this.md5, ipad, opad, 48);
            this.ssl3Complete(this.sha1, ipad, opad, 40);
        }
        return Arrays.concatenate((byte[])this.md5.calculateHash(), (byte[])this.sha1.calculateHash());
    }

    @Override
    public Object clone() {
        return new CombinedHash(this);
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }

    protected void ssl3Complete(TlsHash d, byte[] ipad, byte[] opad, int padLength) {
        byte[] master_secret = this.crypto.adoptSecret(this.context.getSecurityParameters().getMasterSecret()).extract();
        d.update(master_secret, 0, master_secret.length);
        d.update(ipad, 0, padLength);
        byte[] tmp = d.calculateHash();
        d.update(master_secret, 0, master_secret.length);
        d.update(opad, 0, padLength);
        d.update(tmp, 0, tmp.length);
    }
}

