/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

abstract class AbstractTlsContext
implements TlsContext {
    private TlsCrypto crypto;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    AbstractTlsContext(TlsCrypto crypto, SecurityParameters securityParameters) {
        this.crypto = crypto;
        this.securityParameters = securityParameters;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    @Override
    public TlsSession getSession() {
        return this.session;
    }

    void setSession(TlsSession session) {
        this.session = session;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = this.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, seed, seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, sp.getMasterSecret(), asciiLabel, seed, length).extract();
    }
}

