/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import javax.net.ssl.X509TrustManager;

class ProvX509TrustManager
implements X509TrustManager {
    private final Provider pkixProvider;
    private final KeyStore trustStore;

    public ProvX509TrustManager(Provider pkixProvider, KeyStore trustStore) {
        this.pkixProvider = pkixProvider;
        this.trustStore = trustStore;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        try {
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>(this.trustStore.size());
            Enumeration<String> en = this.trustStore.aliases();
            while (en.hasMoreElements()) {
                Certificate cert;
                String alias = en.nextElement();
                if (!this.trustStore.isCertificateEntry(alias) || !((cert = this.trustStore.getCertificate(alias)) instanceof X509Certificate)) continue;
                certs.add((X509Certificate)cert);
            }
            return certs.toArray(new X509Certificate[certs.size()]);
        }
        catch (Exception e) {
            return new X509Certificate[0];
        }
    }

    protected void validatePath(X509Certificate[] x509Certificates) throws CertificateException {
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509Certificates)), this.pkixProvider);
            CertPathBuilder pathBuilder = CertPathBuilder.getInstance("PKIX", this.pkixProvider);
            X509CertSelector constraints = new X509CertSelector();
            constraints.setCertificate(x509Certificates[0]);
            PKIXBuilderParameters param = new PKIXBuilderParameters(this.trustStore, (CertSelector)constraints);
            param.addCertStore(certStore);
            param.setRevocationEnabled(false);
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)((Object)pathBuilder.build(param));
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("unable to process certificates: " + e.getMessage(), e);
        }
    }
}

