/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager manager) {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = manager.getProvSSLParameters();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        Socket socket;
        Principal[] issuers;
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 11: 
            case 20: {
                return null;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        X509KeyManager km = this.manager.getContextData().getKeyManager();
        if (km == null) {
            return null;
        }
        String keyType = JsseUtils.getAuthType(keyExchangeAlgorithm);
        String alias = km.chooseServerAlias(keyType, issuers = null, socket = null);
        if (alias == null) {
            return null;
        }
        TlsCrypto crypto = this.getCrypto();
        if (!(crypto instanceof JcaTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = km.getPrivateKey(alias);
        Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
            }
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
                SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
                return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
            }
            case 1: {
                return new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)crypto, certificate, privateKey);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        boolean shouldRequest;
        boolean bl = shouldRequest = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!shouldRequest) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms();
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        X509TrustManager tm = this.manager.getContextData().getTrustManager();
        if (tm != null) {
            for (X509Certificate caCert : tm.getAcceptedIssuers()) {
                certificateAuthorities.addElement(X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded()));
            }
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        String[] protocols = this.sslParameters.getProtocols();
        if (protocols != null && protocols.length > 0) {
            for (ProtocolVersion version = this.clientVersion; version != null; version = version.getPreviousVersion()) {
                String versionString = this.manager.getContext().getProtocolString(version);
                if (versionString == null || !JsseUtils.contains(protocols, versionString)) continue;
                this.serverVersion = version;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean noClientCert;
        assert (this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth());
        boolean bl = noClientCert = clientCertificate == null || clientCertificate.isEmpty();
        if (noClientCert) {
            if (this.sslParameters.getNeedClientAuth()) {
                throw new TlsFatalAlert(40);
            }
        } else {
            String authType;
            X509Certificate[] chain = JsseUtils.getX509CertificateChain(clientCertificate);
            if (!this.manager.isClientTrusted(chain, authType = JsseUtils.getAuthType(TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite)))) {
                throw new TlsFatalAlert(42);
            }
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getServerSessionContext();
        SSLSession session = sessionContext.reportSession(this.context.getSession());
        this.manager.notifyHandshakeComplete(session);
    }
}

