/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager) {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = manager.getProvSSLParameters();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                Socket socket;
                String alias;
                int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite);
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return null;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                X509KeyManager km = ProvTlsClient.this.manager.getContextData().getKeyManager();
                if (km == null) {
                    return null;
                }
                short[] certTypes = certificateRequest.getCertificateTypes();
                if (certTypes == null || certTypes.length == 0) {
                    return null;
                }
                String[] keyTypes = new String[certTypes.length];
                for (int i = 0; i < certTypes.length; ++i) {
                    keyTypes[i] = JsseUtils.getClientAuthType(certTypes[i]);
                }
                Principal[] issuers = null;
                Vector cas = certificateRequest.getCertificateAuthorities();
                if (cas != null && cas.size() > 0) {
                    X500Name[] names = cas.toArray(new X500Name[cas.size()]);
                    Set<X500Principal> principals = JsseUtils.toX500Principals(names);
                    issuers = principals.toArray(new Principal[principals.size()]);
                }
                if ((alias = km.chooseClientAlias(keyTypes, issuers, socket = null)) == null) {
                    return null;
                }
                TlsCrypto crypto = ProvTlsClient.this.getCrypto();
                if (!(crypto instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                PrivateKey privateKey = km.getPrivateKey(alias);
                X509Certificate[] chain = km.getCertificateChain(alias);
                Certificate certificate = JsseUtils.getCertificateMessage(crypto, chain);
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
                        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.supportedSignatureAlgorithms, signatureAlgorithm);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            @Override
            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                String authType;
                boolean noServerCert;
                boolean bl = noServerCert = serverCertificate == null || serverCertificate.isEmpty();
                if (noServerCert) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(serverCertificate);
                if (!ProvTlsClient.this.manager.isServerTrusted(chain, authType = JsseUtils.getAuthType(TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite)))) {
                    throw new TlsFatalAlert(42);
                }
            }
        };
    }

    @Override
    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return this.manager.getContext().getMinimumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getClientSessionContext();
        SSLSession session = sessionContext.reportSession(this.context.getSession());
        this.manager.notifyHandshakeComplete(session);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String selected = this.manager.getContext().getProtocolString(serverVersion);
        if (selected != null) {
            for (String protocol : this.sslParameters.getProtocols()) {
                if (!selected.equals(protocol)) continue;
                return;
            }
        }
        throw new TlsFatalAlert(70);
    }
}

