/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.ProvExtendedSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLServerSocket;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;

class ProvSSLSessionContext
implements SSLSessionContext {
    static final boolean hasExtendedSSLSession;
    protected final Map<SessionID, ProvSSLSession> sessionMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLContextSpi sslContext;
    protected int sessionCacheSize = 0;
    protected int sessionTimeout = 0;

    ProvSSLSessionContext(ProvSSLContextSpi sslContext) {
        this.sslContext = sslContext;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.sslContext;
    }

    SSLSession reportSession(TlsSession tlsSession) {
        ProvSSLSession sslSession = new ProvSSLSession(this, tlsSession);
        if (hasExtendedSSLSession) {
            return new ProvExtendedSSLSession(sslSession);
        }
        return sslSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<byte[]> getIds() {
        Map<SessionID, ProvSSLSession> map = this.sessionMap;
        synchronized (map) {
            Set<SessionID> keys = this.sessionMap.keySet();
            ArrayList<byte[]> ids = new ArrayList<byte[]>(keys.size());
            for (SessionID key : keys) {
                ids.add(key.getBytes());
            }
            return Collections.enumeration(ids);
        }
    }

    @Override
    public SSLSession getSession(byte[] sessionId) {
        SessionID key = new SessionID(sessionId);
        ProvSSLSession session = this.sessionMap.get(key);
        return session;
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public synchronized void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = size;
    }

    @Override
    public synchronized void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeout = seconds;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = ProvSSLServerSocket.class.getClassLoader().loadClass("javax.net.ssl.ExtendedSSLSession");
        }
        catch (Exception e) {
            clazz = null;
        }
        hasExtendedSSLSession = clazz != null;
    }
}

