/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLServerSocket;
import org.bouncycastle.jsse.provider.SSLParametersUtil;

class ProvSSLParameters {
    static final boolean hasSslParameters;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    ProvSSLParameters() {
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    static ProvSSLParameters extractDefaultParameters(ProvSSLContextSpi context) {
        String[] protocols;
        if (hasSslParameters) {
            return SSLParametersUtil.toProvSSLParameters(context.engineGetDefaultSSLParameters());
        }
        ProvSSLParameters params = new ProvSSLParameters();
        String[] cipherSuites = context.getDefaultCipherSuites();
        if (cipherSuites != null) {
            params.setCipherSuites(cipherSuites);
        }
        if ((protocols = context.getDefaultProtocols()) != null) {
            params.setProtocols(protocols);
        }
        params.setNeedClientAuth(false);
        params.setWantClientAuth(false);
        return params;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = ProvSSLServerSocket.class.getClassLoader().loadClass("javax.net.ssl.SSLParameters");
        }
        catch (Exception e) {
            clazz = null;
        }
        hasSslParameters = clazz != null;
    }
}

