/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements ProvTlsManager {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected SSLSession session = ProvSSLSession.NULL_SESSION;
    protected SSLSession handshakeSession = null;

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData, String host, int port) {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
        this.determineHandshakeStatus();
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.initialHandshakeBegun && mode != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        int count;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.HandshakeStatus prevHandshakeStatus = this.handshakeStatus;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (!this.protocol.isClosed()) {
            byte[] buf = new byte[src.remaining()];
            src.get(buf);
            try {
                this.protocol.offerInput(buf);
            }
            catch (IOException e) {
                throw new SSLException(e);
            }
            bytesConsumed += buf.length;
        }
        int appDataAvailable = this.protocol.getAvailableInputBytes();
        for (int dstIndex = 0; dstIndex < length && appDataAvailable > 0; appDataAvailable -= count, ++dstIndex) {
            ByteBuffer dst = dsts[dstIndex];
            count = Math.min(dst.remaining(), appDataAvailable);
            byte[] input = new byte[count];
            int numRead = this.protocol.readInput(input, 0, count);
            assert (numRead == count);
            dst.put(input);
            bytesProduced += count;
        }
        SSLEngineResult.Status returnStatus = SSLEngineResult.Status.OK;
        if (appDataAvailable > 0) {
            returnStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
        } else if (this.protocol.isClosed()) {
            returnStatus = SSLEngineResult.Status.CLOSED;
        }
        this.determineHandshakeStatus();
        SSLEngineResult.HandshakeStatus returnHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && prevHandshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            returnHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
        }
        return new SSLEngineResult(returnStatus, returnHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.HandshakeStatus previousHandshakeStatus = this.handshakeStatus;
        int bytesConsumed = 0;
        byte[] buffer = new byte[1024];
        try {
            int bytesProduced;
            int read;
            for (int i = offset; i < length; ++i) {
                ByteBuffer src = srcs[i];
                while (src.remaining() > 0) {
                    int read2 = Math.min(buffer.length, src.remaining());
                    src.get(buffer, 0, read2);
                    this.protocol.writeApplicationData(buffer, 0, read2);
                    bytesConsumed += read2;
                }
            }
            int availableDataLength = this.protocol.getAvailableOutputBytes();
            int allowedDataLength = Math.min(availableDataLength, dst.remaining());
            for (bytesProduced = 0; bytesProduced < allowedDataLength; bytesProduced += read) {
                read = this.protocol.readOutput(buffer, 0, buffer.length);
                dst.put(buffer, 0, read);
            }
            SSLEngineResult.Status returnStatus = SSLEngineResult.Status.OK;
            if (availableDataLength > bytesProduced) {
                returnStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
            } else if (this.protocol.isClosed()) {
                returnStatus = SSLEngineResult.Status.CLOSED;
            }
            this.determineHandshakeStatus();
            SSLEngineResult.HandshakeStatus returnHandshakeStatus = this.handshakeStatus;
            if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && previousHandshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                returnHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return new SSLEngineResult(returnStatus, returnHandshakeStatus, bytesConsumed, bytesProduced);
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    protected void determineHandshakeStatus() {
        this.handshakeStatus = !this.initialHandshakeBegun || this.protocolPeer.isHandshakeComplete() ? SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING : (this.protocol.getAvailableOutputBytes() > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : (this.protocol.isClosed() ? SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING : SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(SSLSession session) {
        this.session = session;
    }
}

