/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;

class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Map<String, Integer> supportedCipherSuites = ProvSSLContextSpi.createSupportedCipherSuites();
    private static final Map<String, ProtocolVersion> supportedProtocols = ProvSSLContextSpi.createSupportedProtocols();
    protected final TlsCryptoProvider cryptoProvider;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509KeyManager km;
    private X509TrustManager tm;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static Map<String, Integer> createSupportedCipherSuites() {
        HashMap<String, Integer> cs = new HashMap<String, Integer>();
        cs.put("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC", 49162);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        cs.put("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_CBC", 49172);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        cs.put("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        cs.put("TLS_RSA_WITH_AES_256_CBC_SHA384", 61);
        cs.put("TLS_RSA_WITH_AES_256_CBC", 53);
        cs.put("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        cs.put("TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        cs.put("TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocols() {
        HashMap<String, ProtocolVersion> ps = new HashMap<String, ProtocolVersion>();
        ps.put("TLSv1", ProtocolVersion.TLSv10);
        ps.put("TLSv1.1", ProtocolVersion.TLSv11);
        ps.put("TLSv1.2", ProtocolVersion.TLSv12);
        return Collections.unmodifiableMap(ps);
    }

    ProvSSLContextSpi(TlsCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    int[] convertCipherSuites(String[] suites) {
        int[] result = new int[suites.length];
        for (int i = 0; i < suites.length; ++i) {
            result[i] = supportedCipherSuites.get(suites[i]);
        }
        return result;
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this);
    }

    String getCipherSuiteString(int suite) {
        if (TlsUtils.isValidUint16(suite)) {
            for (Map.Entry<String, Integer> entry : supportedCipherSuites.entrySet()) {
                if (entry.getValue() != suite) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getDefaultCipherSuites() {
        return new String[]{"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"};
    }

    String[] getDefaultProtocols() {
        return new String[]{"TLSv1.2"};
    }

    ProtocolVersion getMaximumVersion(String[] protocols) {
        ProtocolVersion max = null;
        if (protocols != null) {
            for (String protocol : protocols) {
                ProtocolVersion v;
                if (protocol == null || (v = supportedProtocols.get(protocol)) == null || max != null && !v.isLaterVersionOf(max)) continue;
                max = v;
            }
        }
        return max;
    }

    ProtocolVersion getMinimumVersion(String[] protocols) {
        ProtocolVersion min = null;
        if (protocols != null) {
            for (String protocol : protocols) {
                ProtocolVersion v;
                if (protocol == null || (v = supportedProtocols.get(protocol)) == null || min != null && !min.isLaterVersionOf(v)) continue;
                min = v;
            }
        }
        return min;
    }

    String getProtocolString(ProtocolVersion v) {
        if (v != null) {
            for (Map.Entry<String, ProtocolVersion> entry : supportedProtocols.entrySet()) {
                if (!v.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getSupportedCipherSuites() {
        return supportedCipherSuites.keySet().toArray(new String[supportedCipherSuites.size()]);
    }

    String[] getSupportedProtocols() {
        return supportedProtocols.keySet().toArray(new String[supportedProtocols.size()]);
    }

    boolean isSupportedCipherSuites(String[] suites) {
        if (suites == null) {
            return false;
        }
        for (String suite : suites) {
            if (suite != null && supportedCipherSuites.containsKey(suite)) continue;
            return false;
        }
        return true;
    }

    boolean isSupportedProtocols(String[] protocols) {
        if (protocols == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (protocol != null && supportedProtocols.containsKey(protocol)) continue;
            return false;
        }
        return true;
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String host, int port) {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData(), host, port);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(this.getDefaultCipherSuites());
        r.setProtocols(this.getDefaultProtocols());
        return r;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(this.getSupportedCipherSuites());
        r.setProtocols(this.getSupportedProtocols());
        return r;
    }

    @Override
    protected synchronized void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(sr);
        this.km = this.selectKeyManager(kms);
        this.tm = this.selectTrustManager(tms);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.km, this.tm, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509KeyManager findX509KeyManager(KeyManager[] kms) {
        if (kms != null) {
            for (KeyManager km : kms) {
                if (!(km instanceof X509KeyManager)) continue;
                return (X509KeyManager)km;
            }
        }
        return null;
    }

    protected X509TrustManager findX509TrustManager(TrustManager[] tms) {
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                return (X509TrustManager)tm;
            }
        }
        return null;
    }

    protected X509KeyManager selectKeyManager(KeyManager[] kms) throws KeyManagementException {
        if (kms == null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
                kmf.init(null, null);
                kms = kmf.getKeyManagers();
            }
            catch (GeneralSecurityException e) {
                throw new KeyManagementException(e);
            }
        }
        return this.findX509KeyManager(kms);
    }

    protected X509TrustManager selectTrustManager(TrustManager[] tms) throws KeyManagementException {
        if (tms == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init((KeyStore)null);
                tms = tmf.getTrustManagers();
            }
            catch (GeneralSecurityException e) {
                throw new KeyManagementException(e);
            }
        }
        return this.findX509TrustManager(tms);
    }
}

